/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.fixquotes;

import edu.northwestern.at.morphadorner.tools.fixquotes.FixQuotes;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.SetUtils;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.xml.DOMUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FixXMLQuotes {
    protected static Document document;
    protected static final int INITPARAMS = 3;
    protected static int docsToProcess;
    protected static int currentDocNumber;
    protected static String outputDirectory;
    protected static TaggedStrings contractions;
    protected static Matcher contractionsMatcher;
    protected static final String lsquo = "&lsquo;";
    protected static final String ldquo = "&ldquo;";
    protected static final String rsquo = "&rsquo;";
    protected static final String rdquo = "&rdquo;";
    protected static final String apos = "&apos;";
    protected static final String sq = "\ue060";
    protected static final String dq = "\ue061";
    protected static final String ap = "\ue062";
    protected static String prevChar;
    protected static Set<String> softTags;
    protected static Set<String> jumpTags;
    protected static boolean debug;

    public static void main(String[] args) {
        if (!FixXMLQuotes.initialize(args)) {
            System.exit(1);
        }
        long startTime = System.currentTimeMillis();
        int filesProcessed = FixXMLQuotes.processFiles(args);
        long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        FixXMLQuotes.terminate(filesProcessed, processingTime);
    }

    protected static boolean initialize(String[] args) {
        if (args.length < 2) {
            System.out.println("Not enough parameters.");
            return false;
        }
        try {
            softTags = SetUtils.loadSet(args[0], "utf-8");
        }
        catch (IOException e) {
            return false;
        }
        try {
            jumpTags = SetUtils.loadSet(args[1], "utf-8");
        }
        catch (IOException e) {
            return false;
        }
        outputDirectory = args[2];
        contractions = FixQuotes.loadContractions("resources/contractions.txt");
        Pattern contractionsPattern = FixQuotes.buildContractionsPattern(contractions);
        contractionsMatcher = contractionsPattern.matcher("");
        return true;
    }

    protected static void processOneFile(String xmlFileName) {
        System.out.println("Processing " + xmlFileName + " (" + ++currentDocNumber + "/" + docsToProcess + ")");
        try {
            long startTime = System.currentTimeMillis();
            String docText = FileUtils.readTextFile(xmlFileName, "utf-8");
            docText = docText.replaceAll(apos, ap);
            document = DOMUtils.parseText(docText);
            DocumentType docType = document.getDoctype();
            String dtdName = docType.getSystemId();
            long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            System.out.println("   Document loaded and parsed in " + Formatters.formatLongWithCommas(processingTime) + StringUtils.pluralize(processingTime, " second.", " seconds."));
            Element textRoot = DOMUtils.getChild(document, "TEI");
            List<Node> textRootChildren = DOMUtils.getChildren(textRoot, "text");
            startTime = System.currentTimeMillis();
            for (int i = 0; i < textRootChildren.size(); ++i) {
                FixXMLQuotes.traverse(textRootChildren.get(i));
            }
            docText = DOMUtils.saveToString(document, dtdName);
            docText = docText.replaceAll("&amp;ldquo", "&ldquo");
            docText = docText.replaceAll("&amp;rdquo", "&rdquo");
            docText = docText.replaceAll("&amp;lsquo", "&lsquo");
            docText = docText.replaceAll("&amp;rsquo", "&rsquo");
            docText = docText.replaceAll("&amp;apos", "&apos");
            docText = docText.replaceAll(ap, apos);
            processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            System.out.println("   Quotes fixed in " + Formatters.formatLongWithCommas(processingTime) + StringUtils.pluralize(processingTime, " second.", " seconds."));
            String outputFileName = new File(outputDirectory, FileNameUtils.stripPathName(xmlFileName)).getCanonicalPath();
            FileUtils.writeTextFile(outputFileName, false, docText, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("   *** Failed");
        }
    }

    protected static void traverse(Node node) {
        short type;
        String nodeTag = node.getNodeName();
        String savePrevChar = prevChar;
        if (FixXMLQuotes.isHardTag(nodeTag)) {
            savePrevChar = " ";
            prevChar = " ";
        } else if (FixXMLQuotes.isJumpTag(nodeTag)) {
            prevChar = " ";
        }
        NodeList children = node.getChildNodes();
        if (children != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                FixXMLQuotes.traverse(children.item(i));
            }
        }
        if ((type = node.getNodeType()) == 3) {
            Text textNode = (Text)node;
            String text = textNode.getData();
            if (text != null && text.length() > 0) {
                String lastChar = text.substring(text.length() - 1);
                text = FixQuotes.repairQuotes(prevChar + text + " ", contractionsMatcher, contractions);
                text = text.substring(1, text.length() - 1);
                textNode.setData(text);
                prevChar = lastChar;
            }
        } else {
            prevChar = savePrevChar;
        }
    }

    protected static int processFiles(String[] args) {
        boolean result = false;
        String[] wildCards = new String[args.length - 3];
        for (int i = 3; i < args.length; ++i) {
            wildCards[i - 3] = args[i];
        }
        String[] fileNames = FileNameUtils.expandFileNameWildcards(wildCards);
        docsToProcess = fileNames.length;
        for (int i = 0; i < fileNames.length; ++i) {
            FixXMLQuotes.processOneFile(fileNames[i]);
        }
        return fileNames.length;
    }

    protected static void terminate(int filesProcessed, long processingTime) {
        System.out.println("Processed " + Formatters.formatIntegerWithCommas(filesProcessed) + " files in " + Formatters.formatLongWithCommas(processingTime) + StringUtils.pluralize(processingTime, " second.", " seconds."));
    }

    protected static boolean isSoftTag(String tag) {
        return softTags.contains(tag) || softTags.contains(tag.toLowerCase());
    }

    protected static boolean isJumpTag(String tag) {
        return jumpTags.contains(tag) || jumpTags.contains(tag.toLowerCase());
    }

    protected static boolean isHardTag(String tag) {
        return !FixXMLQuotes.isSoftTag(tag) && !FixXMLQuotes.isJumpTag(tag);
    }

    protected FixXMLQuotes() {
    }

    static {
        docsToProcess = 0;
        currentDocNumber = 0;
        prevChar = " ";
        debug = false;
    }
}

