/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.createsuffixlexicon;

import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.MutableInteger;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.BaseLexicon;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class CreateSuffixLexicon {
    protected static String wordLexiconFileName;
    protected static String suffixLexiconFileName;
    protected static int maxSuffixCount;
    protected static int maxSuffixLength;
    protected static int minSuffixLength;

    private static void generateSuffixLexicon() throws IOException {
        long startTime = System.currentTimeMillis();
        BaseLexicon wordLexicon = new BaseLexicon();
        wordLexicon.loadLexicon(new File(wordLexiconFileName).toURI().toURL(), "utf-8");
        BaseLexicon suffixLexicon = new BaseLexicon();
        String[] entries = wordLexicon.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i];
            int entryCount = wordLexicon.getEntryCount(entry);
            if (entryCount > maxSuffixCount) continue;
            String lowerCaseEntry = entry.toLowerCase();
            int l = lowerCaseEntry.length();
            Map<String, MutableInteger> categoryCounts = wordLexicon.getCategoryCountsForEntry(entry);
            for (String categoryName : categoryCounts.keySet()) {
                int categoryCount = categoryCounts.get(categoryName).intValue();
                for (int j = maxSuffixLength; j > minSuffixLength - 1; --j) {
                    if (lowerCaseEntry.length() <= j) continue;
                    suffixLexicon.updateEntryCount(lowerCaseEntry.substring(l - j, l), categoryName, "*", categoryCount);
                }
            }
        }
        System.out.println("Writing suffix lexicon to " + suffixLexiconFileName + " .");
        System.out.println("   Maximum suffix length is " + maxSuffixLength + " .");
        if (maxSuffixCount == Integer.MAX_VALUE) {
            System.out.println("   Suffixes generated from all spellings.");
        } else {
            System.out.println("   Suffixes generated from spellings appearing no more than " + Formatters.formatIntegerWithCommas(maxSuffixCount) + " time" + (maxSuffixCount == 1 ? "" : "s") + ".");
        }
        suffixLexicon.saveLexiconToTextFile(suffixLexiconFileName, "utf-8");
        long endTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        System.out.println("Lexicon generated in " + Formatters.formatLongWithCommas(endTime) + " seconds.");
        System.out.println("Suffix lexicon contains " + Formatters.formatIntegerWithCommas(suffixLexicon.getLexiconSize()) + " entries.");
        wordLexicon.close();
        suffixLexicon.close();
    }

    protected static void help() {
        System.out.println("Usage: ");
        System.out.println("");
        System.out.println("java -Xmx512m edu.northwestern.at.createlexicon.CreateSuffixLexicon ^");
        System.out.println("   inputwordlexicon outputsuffixlexicon maxsuffixlength maxsuffixcount");
        System.out.println("");
        System.out.println("-- inputwordlexicon specifies the input word lexicon (required).");
        System.out.println("-- outputsuffixlexicon receives output suffix lexicon (required).");
        System.out.println("-- maxsuffixlength is maximum length suffix to generate (optional, default is 6).");
        System.out.println("-- maxsuffixcount is maximum count for spelling to include in suffix lexicon (optional, default is no maximum).");
    }

    protected static boolean initialize(String[] args) {
        boolean result = true;
        if (args.length < 2) {
            result = false;
            CreateSuffixLexicon.help();
        } else {
            wordLexiconFileName = args[0];
            suffixLexiconFileName = args[1];
            if (args.length > 2) {
                try {
                    maxSuffixLength = Integer.parseInt(args[2]);
                }
                catch (Exception e) {
                    result = false;
                    System.out.println("Bad maximum suffix length.");
                }
            }
            if (args.length > 4) {
                try {
                    maxSuffixCount = Integer.parseInt(args[3]);
                }
                catch (Exception e) {
                    result = false;
                    System.out.println("Bad maximum suffix count.");
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        int returnCode = 0;
        if (CreateSuffixLexicon.initialize(args)) {
            try {
                CreateSuffixLexicon.generateSuffixLexicon();
            }
            catch (Exception e) {
                e.printStackTrace();
                returnCode = 1;
            }
        }
        if (returnCode != 0) {
            System.exit(returnCode);
        }
    }

    static {
        maxSuffixCount = Integer.MAX_VALUE;
        maxSuffixLength = 6;
        minSuffixLength = 1;
    }
}

