/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.countadornedwords;

import edu.northwestern.at.morphadorner.tools.countadornedwords.AdornedWordCountInfo;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CountAdornedWords {
    protected static final int SPELLING = 2;
    protected static final int STANDARD = 4;
    protected static final int LEMMA = 5;
    protected static final int POS = 6;
    protected static Map<AdornedWordCountInfo, Integer> adornedWordInfoMap = new TreeMap<AdornedWordCountInfo, Integer>();
    protected static String adornedWordsMapOutputFileName;
    protected static final int INITPARAMS = 1;
    protected static int filesToProcess;
    protected static int currentFileNumber;
    protected static int totalWords;
    protected static int uniqueWords;

    public static void main(String[] args) {
        int filesProcessed = 0;
        long processingTime = 0L;
        try {
            if (!CountAdornedWords.initialize(args)) {
                System.exit(1);
            }
            long startTime = System.currentTimeMillis();
            filesProcessed = CountAdornedWords.processFiles(args);
            processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        CountAdornedWords.terminate(filesProcessed, processingTime);
    }

    protected static boolean initialize(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Not enough parameters.");
            return false;
        }
        adornedWordsMapOutputFileName = args[0];
        return true;
    }

    protected static void processOneFile(String tabFileName) {
        System.out.println("Processing " + tabFileName + " (" + ++currentFileNumber + "/" + filesToProcess + ")");
        String workID = FileNameUtils.changeFileExtension(FileNameUtils.stripPathName(tabFileName), "");
        try {
            UnicodeReader streamReader = new UnicodeReader(new FileInputStream(new File(tabFileName)), "utf-8");
            BufferedReader in = new BufferedReader(streamReader);
            int wordsNow = adornedWordInfoMap.size();
            String inputLine = in.readLine();
            while (inputLine != null) {
                String[] fields = inputLine.split("\t");
                AdornedWordCountInfo adornedWordInfo = new AdornedWordCountInfo();
                adornedWordInfo.setWorkID(workID);
                adornedWordInfo.setSpelling(fields[2]);
                adornedWordInfo.setStandardSpelling(fields[4]);
                adornedWordInfo.setPartsOfSpeech(fields[6]);
                adornedWordInfo.setLemmata(fields[5]);
                adornedWordInfo.setTokenType(0);
                adornedWordInfo.setCount(0);
                CountAdornedWords.incrementWordCountMap(adornedWordInfo);
                inputLine = in.readLine();
            }
            in.close();
            totalWords += adornedWordInfoMap.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("   *** Failed");
        }
    }

    protected static int processFiles(String[] args) throws Exception {
        boolean result = false;
        String[] wildCards = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            wildCards[i - 1] = args[i];
        }
        String[] fileNames = FileNameUtils.expandFileNameWildcards(wildCards);
        filesToProcess = fileNames.length;
        for (int i = 0; i < fileNames.length; ++i) {
            CountAdornedWords.processOneFile(fileNames[i]);
            CountAdornedWords.saveWordInfo(new File(adornedWordsMapOutputFileName), "utf-8");
            adornedWordInfoMap.clear();
            System.gc();
        }
        return fileNames.length;
    }

    protected static void terminate(int filesProcessed, long processingTime) {
        System.out.println("Processed " + Formatters.formatLongWithCommas(totalWords) + StringUtils.pluralize(totalWords, " word in ", " words in ") + Formatters.formatIntegerWithCommas(filesProcessed) + StringUtils.pluralize(filesProcessed, " file in ", " files in ") + Formatters.formatLongWithCommas(processingTime) + StringUtils.pluralize(processingTime, " second.", " seconds."));
    }

    public static void incrementWordCountMap(AdornedWordCountInfo adornedWordInfo) {
        int count = 1;
        if (adornedWordInfoMap.containsKey(adornedWordInfo)) {
            count = adornedWordInfoMap.get(adornedWordInfo) + 1;
            adornedWordInfo.setCount(count);
            adornedWordInfoMap.put(adornedWordInfo, new Integer(count));
        } else {
            adornedWordInfo.setCount(1);
            adornedWordInfoMap.put(adornedWordInfo, new Integer(1));
        }
    }

    public static void saveWordInfo(File adornedWordInfoFile, String encoding) throws IOException, FileNotFoundException {
        Set<AdornedWordCountInfo> adornedWordInfoSet = adornedWordInfoMap.keySet();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(adornedWordInfoFile, true), "utf-8"));
        for (AdornedWordCountInfo adornedWordInfo : adornedWordInfoSet) {
            String value = adornedWordInfo.toString() + "\t" + adornedWordInfoMap.get(adornedWordInfo);
            printWriter.println(value);
        }
        printWriter.flush();
        printWriter.close();
    }

    static {
        filesToProcess = 0;
        currentFileNumber = 0;
        totalWords = 0;
        uniqueWords = 0;
    }
}

