/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.comparestringcounts;

import edu.northwestern.at.utils.Compare;
import edu.northwestern.at.utils.CountMapUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.corpuslinguistics.statistics.Frequency;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareStringCounts {
    public static void main(String[] args) {
        if (args.length >= 2) {
            new CompareStringCounts(args);
        } else {
            CompareStringCounts.displayUsage();
            System.exit(1);
        }
    }

    public static void displayUsage() {
        System.out.println("");
        System.out.println("Compare string counts in two files using Dunning's log-likelihood.");
        System.out.println("Usage: ");
        System.out.println("");
        System.out.println("   java edu.northwestern.at.morphadorner.tools.comparestringcounts.CompareStringCounts analysis.tab reference.tab");
        System.out.println("");
        System.out.println("analysis.tab -- Input tab-separated file of strings and counts for an analysis text.");
        System.out.println("reference.tab -- Input tab-separated file \tof strings and counts for a reference text.");
        System.out.println("");
    }

    public CompareStringCounts(String[] args) {
        Map<String, Number> analysisCounts = null;
        try {
            analysisCounts = CountMapUtils.loadCountMapFromFile(new File(args[0]));
        }
        catch (Exception e) {
            System.err.println("Unable to open analysis counts file " + args[0]);
        }
        Map<String, Number> referenceCounts = null;
        try {
            referenceCounts = CountMapUtils.loadCountMapFromFile(new File(args[1]));
        }
        catch (Exception e) {
            System.err.println("Unable to open reference counts file " + args[1]);
        }
        int analysisTotalCount = CountMapUtils.getTotalWordCount(analysisCounts);
        int refTotalCount = CountMapUtils.getTotalWordCount(referenceCounts);
        System.err.println("Comparing string counts using " + args[0] + " as analysis file and " + args[1] + " as reference file.");
        System.err.println("");
        System.err.println("Analysis unique strings  : " + analysisCounts.size());
        System.err.println("Analysis total strings   : " + analysisTotalCount);
        System.err.println("Reference unique strings : " + referenceCounts.size());
        System.err.println("Reference total strings  : " + refTotalCount);
        Map<String, Number> combinedCounts = CountMapUtils.semiDeepClone(analysisCounts);
        CountMapUtils.addCountMap(combinedCounts, referenceCounts);
        TreeMap<ReverseScoredString, double[]> results = new TreeMap<ReverseScoredString, double[]>();
        Set<String> keySet = combinedCounts.keySet();
        int stringsDone = 0;
        for (String stringToAnalyze : keySet) {
            Number stringCount = analysisCounts.get(stringToAnalyze);
            if (stringCount == null) {
                stringCount = new Integer(0);
            }
            int refCount = 0;
            if (referenceCounts.containsKey(stringToAnalyze)) {
                refCount = referenceCounts.get(stringToAnalyze).intValue();
            }
            double[] freqAnal = CompareStringCounts.doFreq(stringToAnalyze, stringCount.intValue(), analysisTotalCount, refCount, refTotalCount);
            results.put(new ReverseScoredString(stringToAnalyze, freqAnal[4]), freqAnal);
            ++stringsDone;
        }
        CompareStringCounts.displayResults(results);
    }

    public static double[] doFreq(String stringToAnalyze, int analysisCount, int analysisTotalCount, int refCount, int refTotalCount) {
        double[] freqAnal = Frequency.logLikelihoodFrequencyComparison(analysisCount, refCount, analysisTotalCount, refTotalCount, false);
        freqAnal[1] = freqAnal[1] * 100.0;
        freqAnal[3] = freqAnal[3] * 100.0;
        return freqAnal;
    }

    public static void displayResults(Map<ReverseScoredString, double[]> results) {
        System.out.println("String\tOver/under use\tLog likelihood\tAnalysis percent\tReference percent\tAnalysis count\tReference count");
        for (ReverseScoredString key : results.keySet()) {
            double[] freqAnal = results.get(key);
            String overUnderUse = Compare.compare(freqAnal[1], freqAnal[3]) > 0 ? "+" : "-";
            int places = 2;
            System.out.println(key.getString() + "\t" + overUnderUse + "\t" + Formatters.formatDouble(freqAnal[4], places) + "\t" + Formatters.formatDouble(freqAnal[1], places) + "\t" + Formatters.formatDouble(freqAnal[3], places) + "\t" + Formatters.formatDouble(freqAnal[0], 0) + "\t" + Formatters.formatDouble(freqAnal[2], 0));
        }
    }

    public static class ReverseScoredString
    extends ScoredString {
        public ReverseScoredString(String string, double score) {
            super(string, score);
        }

        public int compareTo(Object other) {
            return -super.compareTo(other);
        }
    }
}

