/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.addpseudopages;

import edu.northwestern.at.morphadorner.PseudoPageAdderFilter;
import edu.northwestern.at.morphadorner.tools.FilterAdornedFile;
import edu.northwestern.at.utils.Formatters;
import org.xml.sax.helpers.XMLReaderFactory;

public class AddPseudoPages {
    public AddPseudoPages(String xmlInputFileName, String xmlOutputFileName, int pseudoPageSize, String pageEndingDivTypes) {
        try {
            PseudoPageAdderFilter filter = new PseudoPageAdderFilter(XMLReaderFactory.createXMLReader(), pseudoPageSize, pageEndingDivTypes);
            long startTime = System.currentTimeMillis();
            new FilterAdornedFile(xmlInputFileName, xmlOutputFileName, filter);
            long endTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            System.out.println("PseudoPage milestones added in " + Formatters.formatLongWithCommas(endTime) + " seconds.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String pageEndingDivTypes = "volume chapter sermon";
        int pseudoPageSize = 300;
        if (args.length < 2) {
            AddPseudoPages.displayUsage();
            System.exit(0);
        }
        if (args.length >= 3) {
            pseudoPageSize = Integer.parseInt(args[2]);
        }
        if (args.length >= 4) {
            pageEndingDivTypes = args[3];
        }
        try {
            new AddPseudoPages(args[0], args[1], pseudoPageSize, pageEndingDivTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void displayUsage() {
        System.out.println("Usage: java AddPseudoPages infile outfile pseudoPageSize pageEndingDivTypes");
    }
}

