/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools;

import edu.northwestern.at.utils.FileUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class AdornedXMLWriter {
    public AdornedXMLWriter(Document document, String xmlOutputFileName) throws SAXException, IOException {
        this.outputXML(document, xmlOutputFileName);
    }

    protected void outputXML(Document document, String xmlOutputFileName) throws IOException {
        Format format = Format.getRawFormat();
        format.setIndent("  ");
        format.setEncoding("utf-8");
        format.setExpandEmptyElements(true);
        format.setTextMode(Format.TextMode.NORMALIZE);
        AdornerXMLOutputter xmlOut = new AdornerXMLOutputter(format);
        FileUtils.createPathForFile(xmlOutputFileName);
        FileOutputStream outputStream = new FileOutputStream(xmlOutputFileName, false);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedStream, "utf-8");
        xmlOut.output(document, writer);
    }

    public class AdornerXMLOutputter
    extends XMLOutputter {
        protected Format outputFormat;

        public AdornerXMLOutputter(Format format) {
            super(format);
            this.outputFormat = format;
        }

        protected void printElement(Writer out, Element element, int level, XMLOutputter.NamespaceStack namespaces) throws IOException {
            if (element.getName().equals("c")) {
                element.removeAttribute("part");
                this.outputFormat.setTextMode(Format.TextMode.PRESERVE);
                this.setFormat(this.outputFormat);
            }
            super.printElement(out, element, level, namespaces);
            if (element.getName().equals("c")) {
                this.outputFormat.setTextMode(Format.TextMode.NORMALIZE);
                this.setFormat(this.outputFormat);
            }
        }
    }
}

