/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools;

import edu.northwestern.at.morphadorner.tools.AddXMLPathFilter;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWord;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWordFilter;
import edu.northwestern.at.utils.Env;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.corpuslinguistics.sentencemelder.SentenceMelder;
import edu.northwestern.at.utils.xml.TEITagClassifier;
import edu.northwestern.at.utils.xml.XMLTagClassifier;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdornedXMLReader {
    protected ExtendedAdornedWordFilter wordInfoFilter;

    public AdornedXMLReader(String xmlInputFileName) throws SAXException, IOException {
        this.readXML(xmlInputFileName);
    }

    protected void readXML(String xmlInputFileName) throws SAXException, IOException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        AddXMLPathFilter xmlPathFilter = new AddXMLPathFilter(reader, FileNameUtils.changeFileExtension(FileNameUtils.stripPathName(xmlInputFileName), ""));
        this.wordInfoFilter = new ExtendedAdornedWordFilter(xmlPathFilter, true);
        BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(new FileInputStream(xmlInputFileName), "utf-8"));
        InputSource inputSource = new InputSource(bufferedReader);
        this.wordInfoFilter.parse(inputSource);
        bufferedReader.close();
    }

    public List<String> getAdornedWordIDs() {
        return this.wordInfoFilter.getAdornedWordIDs();
    }

    public List<List<ExtendedAdornedWord>> getSentences() {
        return this.wordInfoFilter.getSentences();
    }

    public ExtendedAdornedWord getExtendedAdornedWord(String id) {
        return this.wordInfoFilter.getExtendedAdornedWord(id);
    }

    public ExtendedAdornedWord getExtendedAdornedWord(int index) {
        return this.wordInfoFilter.getExtendedAdornedWord(index);
    }

    public List<String> getRelatedSplitWordIDs(String wordID) {
        return this.wordInfoFilter.getRelatedSplitWordIDs(wordID);
    }

    public List<ExtendedAdornedWord> getRelatedSplitWords(ExtendedAdornedWord adornedWordInfo) {
        return this.wordInfoFilter.getRelatedSplitWords(adornedWordInfo);
    }

    public int getAdornedWordIndexByID(String id) {
        return this.wordInfoFilter.getAdornedWordIndexByID(id);
    }

    public List<String> getSiblingWordIDs(String wordID) {
        return this.wordInfoFilter.getSiblingWordIDs(wordID);
    }

    public List<String> findWordsByMatchingLeadingPath(String pattern) {
        return this.wordInfoFilter.findWordsByMatchingLeadingPath(pattern);
    }

    public List<String> findWordsByMatchingPath(String pattern) {
        return this.wordInfoFilter.findWordsByMatchingPath(pattern);
    }

    public String trimTag(String tag) {
        return this.wordInfoFilter.trimTag(tag);
    }

    public String[] splitPathFull(String path) {
        return this.wordInfoFilter.splitPathFull(path);
    }

    public String[] splitPath(String path) {
        return this.wordInfoFilter.splitPath(path);
    }

    public List<String> getSelectedWordIDs(String startingWordID, String endingWordID) {
        return this.wordInfoFilter.getSelectedWordIDs(startingWordID, endingWordID);
    }

    public String generateXML(String startingWordID, String endingWordID) {
        List<String> selectedWordIDs = this.getSelectedWordIDs(startingWordID, endingWordID);
        if (selectedWordIDs.size() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        ArrayDeque<String> tagStack = new ArrayDeque<String>();
        MySentenceMelder melder = new MySentenceMelder();
        melder.startSentence();
        TEITagClassifier tagClassifier = new TEITagClassifier();
        String id = selectedWordIDs.get(0);
        ExtendedAdornedWord word = this.getExtendedAdornedWord(id);
        String path = word.getPath();
        String spelling = word.getSpelling();
        String[] tags = this.splitPath(path);
        for (int i = 0; i < tags.length; ++i) {
            String tag = this.trimTag(tags[i]);
            this.outputTag(tag, true, melder, tagClassifier);
            tagStack.addFirst(tag);
        }
        melder.processWord(spelling);
        boolean firstWordInSentence = false;
        String[] prevTags = tags;
        for (int i = 1; i < selectedWordIDs.size(); ++i) {
            int j;
            id = selectedWordIDs.get(i);
            word = this.getExtendedAdornedWord(id);
            path = word.getPath();
            spelling = word.getSpelling();
            if (melder.shouldOutputBlank(spelling, firstWordInSentence)) {
                melder.outputBlank();
            }
            prevTags = tags;
            tags = this.splitPath(path);
            int m3 = Math.min(tags.length, prevTags.length);
            int n = -1;
            for (j = 0; j < m3; ++j) {
                if (tags[j].equals(prevTags[j])) continue;
                n = j;
                break;
            }
            if (n == -1 && prevTags.length != tags.length) {
                n = m3;
            }
            if (n != -1) {
                String tag;
                for (j = n; j < prevTags.length; ++j) {
                    tag = (String)tagStack.removeFirst();
                    this.outputTag(tag, false, melder, tagClassifier);
                }
                for (j = n; j < tags.length; ++j) {
                    tag = this.trimTag(tags[j]);
                    this.outputTag(tag, true, melder, tagClassifier);
                    tagStack.addFirst(tag);
                }
            }
            melder.processWord(spelling);
            if (word.getEOS()) {
                result.append(StringUtils.wrapLine(melder.endSentence(), Env.LINE_SEPARATOR, 65));
                result.append(Env.LINE_SEPARATOR);
                melder.startSentence();
                firstWordInSentence = true;
                continue;
            }
            firstWordInSentence = false;
        }
        result.append(melder.endSentence());
        result.append(Env.LINE_SEPARATOR);
        while (tagStack.size() > 0) {
            String tag = (String)tagStack.removeFirst();
            result.append("</" + tag + ">");
            if (tagClassifier.isSoftTag(tag)) continue;
            result.append(Env.LINE_SEPARATOR);
        }
        return result.toString();
    }

    protected void outputTag(String tag, boolean openingTag, MySentenceMelder melder, XMLTagClassifier tagClassifier) {
        if (openingTag) {
            melder.outputWord("<");
        } else {
            melder.outputWord("</");
        }
        melder.outputWord(tag + ">");
        if (!tagClassifier.isSoftTag(tag)) {
            melder.outputWord(Env.LINE_SEPARATOR);
        }
    }

    public class MySentenceMelder
    extends SentenceMelder {
        public void outputWord(String word) {
            super.outputWord(word);
        }
    }
}

