/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.xml.ExtendedXMLFilterImpl;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class AddXMLPathFilter
extends ExtendedXMLFilterImpl {
    protected List<String> tagStack = ListFactory.createNewList();
    protected List<Map<String, Integer>> tagCounts = ListFactory.createNewList();
    protected String pathRoot = "\\";

    public AddXMLPathFilter(XMLReader reader, String pathRoot) {
        super(reader);
        if (pathRoot != null) {
            this.pathRoot = "\\" + pathRoot;
        }
    }

    public void startDocument() {
        Map counts = MapFactory.createNewMap();
        this.tagCounts.add(counts);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        Map<String, Integer> oldCounts = this.tagCounts.get(this.tagCounts.size() - 1);
        Integer oldCount = oldCounts.get(qName);
        if (oldCount == null) {
            oldCount = 1;
        } else {
            Integer n = oldCount;
            Integer n2 = oldCount = Integer.valueOf(oldCount + 1);
        }
        oldCounts.put(qName, oldCount);
        this.tagStack.add(qName);
        Map counts = MapFactory.createNewMap();
        this.tagCounts.add(counts);
        AttributesImpl newAttributes = new AttributesImpl(atts);
        this.setAttributeValue(newAttributes, "p", this.createXMLPath());
        super.startElement(uri, localName, qName, newAttributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.tagStack.remove(this.tagStack.size() - 1);
        this.tagCounts.remove(this.tagCounts.size() - 1);
        super.endElement(uri, localName, qName);
    }

    protected String createXMLPath() {
        String result = this.pathRoot;
        for (int i = 0; i < this.tagStack.size(); ++i) {
            String tag = this.tagStack.get(i);
            if (i == 0 && tag.equals("TEI") || i == 1 && tag.equals("text")) continue;
            Map<String, Integer> counts = this.tagCounts.get(i);
            result = result + "\\" + tag + "[" + counts.get(tag) + "]";
        }
        return result;
    }
}

