/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.TokenizerUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WordTokenizerServlet
extends BaseAdornerServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        WordTokenizerServlet.initialize(config);
    }

    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result = null;
        boolean clear = request.getParameter("clear") != null;
        boolean tokenize = request.getParameter("tokenize") != null;
        boolean fromForm = clear || tokenize;
        String adornerName = request.getParameter("adornername");
        AdornerInfo adornerInfo = WordTokenizerServlet.getAdornerInfo(adornerName);
        HttpSession session = request.getSession(true);
        String tokenizerResults = (String)session.getAttribute("wordtokenizerresults");
        if (tokenizerResults != null && !fromForm) {
            session.setAttribute("wordtokenizerresults", null);
            result = new ServletResult(false, tokenizerResults, "Word Tokenizer Example", "/morphadorner/wordtokenizer/example/", "wordtokenizerresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String text = "";
            List<List<String>> sentences = null;
            if (tokenize && (text = (text = request.getParameter("text")) == null ? "" : this.unTag(text)).length() > 0) {
                sentences = adornerInfo.extractor.extractSentences(text);
            }
            this.outputForm(out, text, adornerName);
            this.outputSentences(out, sentences);
            result = new ServletResult(fromForm, out.getString(), "Word Tokenizer Example", "/morphadorner/wordtokenizer/example/", "wordtokenizerresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String text, String adornerName) {
        out.println("<p>");
        out.println("Enter text to split into sentences and words in the ");
        out.println("input field below.<br />");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/wordtokenizer/example/WordTokenizer\" name=\"tokenizer\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.print("<td colspan=\"2\"><textarea name=\"text\" rows=\"10\" cols=\"50\">");
        out.print(text);
        out.println("</textarea>");
        out.println("</td>");
        out.println("</tr>");
        this.outputAdornerSelection(out, "Lexicon:", adornerName);
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td colspan=\"2\">");
        out.println("<input type=\"submit\" name=\"tokenize\" value=\"Tokenize\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }

    public void outputSentences(PrintWriter out, List sentences) {
        if (sentences == null) {
            return;
        }
        out.println("<hr noshade=\"noshade\" />");
        switch (sentences.size()) {
            case 0: {
                out.println("<h3>No sentences found.</h3>");
                return;
            }
            case 1: {
                out.println("<h3>1 sentence found.</h3>");
                break;
            }
            default: {
                out.println("<h3>" + sentences.size() + " sentences found.</h3>");
            }
        }
        out.println("<table width=\"100%\">");
        out.println("<tr>");
        out.println("<th align=\"left\" class=\"width1pct\">");
        out.println("S#");
        out.println("</th>");
        out.println("<th align=\"left\" class=\"width1pct\">");
        out.println("W#");
        out.println("</th>");
        out.println("<th align=\"left\" class=\"width48pct\">");
        out.println("Word");
        out.println("</th>");
        out.println("<th align=\"left\" class=\"width48pct\">");
        out.println("Type");
        out.println("</th>");
        out.println("</tr>");
        for (int i = 0; i < sentences.size(); ++i) {
            List sentenceWords = (List)sentences.get(i);
            for (int j = 0; j < sentenceWords.size(); ++j) {
                out.println("<tr>");
                out.println("<td valign=\"top\" class=\"width1pct\">");
                out.println(i + 1 + "");
                out.println("</td>");
                out.println("<td valign=\"top\" class=\"width1pct\">");
                out.println(j + 1 + "");
                out.println("</td>");
                out.println("<td valign=\"top\" class=\"width48pct\">");
                String sentenceWord = (String)sentenceWords.get(j);
                out.println(sentenceWord);
                out.println("</td>");
                out.println("<td valign=\"top\" class=\"width48pct\">");
                out.println(TokenizerUtils.getTokenType((String)sentenceWords.get(j)));
                out.println("</td>");
                out.println("</tr>");
            }
            out.println("<tr>");
            out.println("<td colspan=\"4\">");
            out.println("<hr shade=\"noshade\">");
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }
}

