/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.corpuslinguistics.inflector.Person;
import edu.northwestern.at.utils.corpuslinguistics.inflector.VerbTense;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class VerbConjugatorServlet
extends BaseAdornerServlet {
    protected String notReadyMessage = "Conjugator still initializing, please try again later.";
    protected static final String[] pronouns = new String[]{"I", "You", "He", "We", "You", "They"};

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        VerbConjugatorServlet.initialize(config);
    }

    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result;
        boolean clear = request.getParameter("clear") != null;
        boolean conjugate = request.getParameter("conjugate") != null;
        boolean fromForm = clear || conjugate;
        HttpSession session = request.getSession(true);
        String conjugatorResults = (String)session.getAttribute("conjugatorresults");
        if (conjugatorResults != null && !fromForm) {
            session.setAttribute("conjugatoresults", null);
            result = new ServletResult(false, conjugatorResults, "Verb Conjugator Example", "/morphadorner/conjugator/example", "conjugatoresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String infinitive = "";
            String past = "";
            String pastParticiple = "";
            String presentParticiple = "";
            String present3rd = "";
            String american = request.getParameter("american");
            if (conjugate && (infinitive = (infinitive = request.getParameter("infinitive")) == null ? "" : infinitive.trim()).length() > 0) {
                present3rd = inflector.conjugate(infinitive, VerbTense.PRESENT, Person.THIRD_PERSON_SINGULAR);
                presentParticiple = inflector.conjugate(infinitive, VerbTense.PRESENT_PARTICIPLE, Person.THIRD_PERSON_SINGULAR);
                past = inflector.conjugate(infinitive, VerbTense.PAST, Person.THIRD_PERSON_SINGULAR);
                pastParticiple = inflector.conjugate(infinitive, VerbTense.PAST_PARTICIPLE, Person.THIRD_PERSON_SINGULAR);
            }
            this.outputForm(out, infinitive, past, pastParticiple, presentParticiple, present3rd, american);
            result = new ServletResult(fromForm, out.getString(), "Conjugator Example", "/morphadorner/conjugator/example/", "conjugatoresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String infinitive, String past, String pastParticiple, String presentParticiple, String present3rd, String american) {
        out.println("<p>");
        out.println("Enter an infinitive in the input box below.");
        out.println("Press <strong>Conjugate</strong> to see ");
        out.println("the conjugated forms of the verb. ");
        out.println("Check <strong>American spellings</strong> to display American instead of British spellings.");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/conjugator/example/VerbConjugator\" name=\"conjugator\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.println("<td><strong>Infinitive:</strong></td>");
        out.println("<td><input type=\"text\" name=\"infinitive\"size = \"20\" value=\"" + infinitive + "\" /></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>&nbsp;</td>");
        String checkedAmerican = american == null ? "" : "checked=\"checked\"";
        out.println("<td><input type=\"checkbox\" name=\"american\"value=\"american\" " + checkedAmerican + "/>American spellings</td>");
        out.println("</tr>");
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td>");
        out.println("<input type=\"submit\" name=\"conjugate\" value=\"Conjugate\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        this.outputSpacerRow(out, 2);
        if (infinitive != null && infinitive.length() > 0) {
            VerbConjugatorServlet.doConjugation(out, american, infinitive, VerbTense.PRESENT, "Present: ");
            VerbConjugatorServlet.doConjugation(out, american, infinitive, VerbTense.PAST, "Past: ");
            if (american != null) {
                presentParticiple = britishToUS.mapSpelling(presentParticiple);
                pastParticiple = britishToUS.mapSpelling(pastParticiple);
            }
            out.println("<tr>");
            out.println("<td><strong>Present Participle:</strong></td>");
            out.println("<td><label type=\"text\" name=\"presentparticiple\"size = \"20\">" + presentParticiple + "</label></td>");
            out.println("</tr>");
            out.println("<tr>");
            out.println("<td><strong>Past Participle:</strong></td>");
            out.println("<td><label type=\"text\" name=\"pastparticiple\"size = \"20\">" + pastParticiple + "</label></td>");
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</form>");
    }

    protected static void doConjugation(PrintWriter out, String american, String verb, VerbTense verbTense, String title) {
        int i = 0;
        out.println("<tr>");
        out.println("<td valign=\"top\">");
        out.println("<strong>");
        out.println(title);
        out.println("</strong>");
        out.println("</td>");
        out.println("<td valign=\"top\">");
        for (Person person : Person.values()) {
            String conjugatedVerb = inflector.conjugate(verb, verbTense, person);
            if (american != null) {
                conjugatedVerb = britishToUS.mapSpelling(conjugatedVerb);
            }
            if (verbTense == VerbTense.PRESENT_PARTICIPLE) {
                out.println(" " + pronouns[i++] + " " + inflector.conjugate("be", VerbTense.PRESENT, person) + " " + conjugatedVerb);
            } else if (verbTense == VerbTense.PAST_PARTICIPLE) {
                out.println(" " + pronouns[i++] + " " + inflector.conjugate("be", VerbTense.PAST, person) + " " + conjugatedVerb);
            } else {
                out.println(" " + pronouns[i++] + " " + conjugatedVerb);
            }
            out.println("<br />");
        }
        out.println("</td>");
        out.println("</tr>");
    }
}

