/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.corpuslinguistics.sentencemelder.SentenceMelder;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.AbstractTextSegmenter;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.C99TextSegmenter;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.TextTilingTextSegmenter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSegmenterServlet
extends BaseAdornerServlet {
    @Override
    public void init(ServletConfig config) throws ServletException {
        TextSegmenterServlet.initialize(config);
    }

    @Override
    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result = null;
        boolean clear = request.getParameter("clear") != null;
        boolean segment = request.getParameter("segment") != null;
        boolean fromForm = clear || segment;
        String adornerName = request.getParameter("adornername");
        String segmenterName = request.getParameter("segmentername");
        int c99MaskSize = TextSegmenterServlet.getIntValue(request.getParameter("c99masksize"), 11);
        int c99SegmentsWanted = TextSegmenterServlet.getIntValue(request.getParameter("c99segmentswanted"), -1);
        int tilerSlidingWindowSize = TextSegmenterServlet.getIntValue(request.getParameter("tilerslidingwindowsize"), 10);
        int tilerStepSize = TextSegmenterServlet.getIntValue(request.getParameter("tilerstepsize"), 100);
        AdornerInfo adornerInfo = TextSegmenterServlet.getAdornerInfo(adornerName);
        HttpSession session = request.getSession(true);
        String textSegmenterResults = (String)session.getAttribute("textsegmenterresults");
        if (textSegmenterResults != null && !fromForm) {
            session.setAttribute("textsegmenterresults", null);
            result = new ServletResult(false, textSegmenterResults, "Text Segmenter Example", "/morphadorner/textsegmenter/example/", "textsegmenterresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String text = "";
            List sentences = null;
            List<Integer> segments = null;
            if (segment && (text = (text = request.getParameter("text")) == null ? "" : this.unTag(text)).length() > 0) {
                sentences = adornerInfo.extractor.extractSentences(text);
                if (segmenterName != null) {
                    AbstractTextSegmenter textSegmenter;
                    if (segmenterName.equals("C99")) {
                        textSegmenter = new C99TextSegmenter();
                        ((C99TextSegmenter)textSegmenter).setSegmentsWanted(c99SegmentsWanted);
                        ((C99TextSegmenter)textSegmenter).setMaskSize(c99MaskSize);
                    } else {
                        textSegmenter = new TextTilingTextSegmenter();
                        ((TextTilingTextSegmenter)textSegmenter).setSlidingWindowSize(tilerSlidingWindowSize);
                        ((TextTilingTextSegmenter)textSegmenter).setStepSize(tilerStepSize);
                    }
                    segments = textSegmenter.getSegmentPositions(sentences);
                }
            }
            this.outputForm(out, text, adornerName, segmenterName, c99SegmentsWanted, c99MaskSize, tilerSlidingWindowSize, tilerStepSize);
            this.outputSegmentedText(out, sentences, segments, segmenterName);
            result = new ServletResult(fromForm, out.getString(), "Text Segmenter Example", "/morphadorner/textsegmenter/example/", "textsegmenterresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String text, String adornerName, String segmenterName, int c99SegmentsWanted, int c99MaskSize, int tilerSlidingWindowSize, int tilerStepSize) {
        out.println("<p>");
        out.println("Enter text to segment in the ");
        out.println("input field below.<br />");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/textsegmenter/example/TextSegmenter\" name=\"segmenter\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.print("<td colspan=\"2\"><textarea name=\"text\" rows=\"10\" cols=\"50\">");
        out.print(text);
        out.println("</textarea>");
        out.println("</td>");
        out.println("</tr>");
        this.outputSegmenterSelection(out, "Segmenter:", segmenterName, c99SegmentsWanted, c99MaskSize, tilerSlidingWindowSize, tilerStepSize);
        this.outputAdornerSelection(out, "Lexicon:", adornerName);
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td colspan=\"2\">");
        out.println("<input type=\"submit\" name=\"segment\" value=\"Segment\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }

    public void outputSegmenterSelection(PrintWriter out, String label, String segmenterName, int c99SegmentsWanted, int c99MaskSize, int tilerSlidingWindowSize, int tilerStepSize) {
        out.println("<tr>");
        if (label != null && label.length() > 0) {
            out.println("<td valign=\"top\">");
            out.println("<strong>");
            out.print(label);
            out.println("</strong>");
            out.println("</td>");
        }
        out.println("<td>");
        String checkedC99 = "";
        String checkedTextTiling = "checked=\"checked\"";
        if (segmenterName != null && segmenterName.equals("C99")) {
            checkedC99 = "checked=\"checked\"";
            checkedTextTiling = "";
        }
        out.println("<input type=\"radio\" name=\"segmentername\" value=\"C99\"" + checkedC99 + ">C99</input><br />");
        out.println("<table border=\"0\">");
        out.println("<tr>");
        out.println("<td>");
        out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        out.println("</td>");
        out.println("<td>");
        out.println("Mask size:");
        out.println("</td>");
        out.println("<td>");
        out.println("<input type=\"text\" name=\"c99masksize\"size = \"5\" value=\"" + c99MaskSize + "\" /></input>");
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>");
        out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        out.println("</td>");
        out.println("<td>");
        out.println("Segments desired:");
        out.println("</td>");
        out.println("<td>");
        out.println("<input type=\"text\" name=\"c99segmentswanted\"size = \"5\" value=\"" + c99SegmentsWanted + "\" /></input>");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("<input type=\"radio\" name=\"segmentername\" value=\"Text Tiling\"" + checkedTextTiling + ">Text Tiling</input><br />");
        out.println("<table border=\"0\">");
        out.println("<tr>");
        out.println("<td>");
        out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        out.println("</td>");
        out.println("<td>");
        out.println("Sliding window size:");
        out.println("</td>");
        out.println("<td>");
        out.println("<input type=\"text\" name=\"tilerslidingwindowsize\"size = \"5\" value=\"" + tilerSlidingWindowSize + "\" /></input>");
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>");
        out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        out.println("</td>");
        out.println("<td>");
        out.println("Segment size:");
        out.println("</td>");
        out.println("<td>");
        out.println("<input type=\"text\" name=\"tilerstepsize\"size = \"5\" value=\"" + tilerStepSize + "\" /></input>");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</td>");
        out.println("</tr>");
    }

    public void outputSegmentedText(PrintWriter out, List<List<String>> sentences, List<Integer> segments, String segmenterName) {
        if (sentences == null) {
            return;
        }
        out.println("<hr noshade=\"noshade\" />");
        switch (segments.size()) {
            case 0: {
                out.println("<h3>No segments found.</h3>");
                return;
            }
            case 1: {
                out.println("<h3>1 segment found using " + segmenterName + ".</h3>");
                break;
            }
            default: {
                out.println("<h3>" + segments.size() + " segments found using " + segmenterName + ".</h3>");
            }
        }
        out.println("<table width=\"100%\">");
        out.println("<tr>");
        out.println("<th class=\"width1pct\" align=\"left\">");
        out.println("Segment");
        out.println("</th>");
        out.println("<th class=\"width99pct\" align=\"left\">");
        out.println("Text");
        out.println("</th>");
        out.println("</tr>");
        SentenceMelder melder = new SentenceMelder();
        int firstSentence = 0;
        int lastSentence = 0;
        for (int i = 0; i < segments.size(); ++i) {
            firstSentence = segments.get(i);
            lastSentence = i < segments.size() - 1 ? segments.get(i + 1).intValue() : sentences.size();
            out.println("<tr>");
            out.println("<td valign=\"top\" class=\"width1pct\">");
            out.println(i + 1 + "");
            out.println("</td>");
            out.println("<td class=\"width99pct\">");
            for (int j = firstSentence; j < lastSentence; ++j) {
                List<String> sentence = sentences.get(j);
                String sentenceText = melder.reconstituteSentence(sentence);
                out.println(sentenceText);
                out.println("  ");
            }
            out.println("<br />");
            out.println("<hr />");
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }
}

