/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.EnglishDecruftifier;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellingStandardizerServlet
extends BaseAdornerServlet {
    @Override
    public void init(ServletConfig config) throws ServletException {
        SpellingStandardizerServlet.initialize(config);
    }

    @Override
    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result = null;
        boolean clear = request.getParameter("clear") != null;
        boolean suggest = request.getParameter("suggest") != null;
        boolean extendedSearch = request.getParameter("extendedsearch") != null;
        boolean fromForm = clear || suggest;
        String adornerName = request.getParameter("adornername");
        AdornerInfo adornerInfo = SpellingStandardizerServlet.getAdornerInfo(adornerName);
        HttpSession session = request.getSession(true);
        StringPrintWriter out = new StringPrintWriter();
        String standardizerResults = (String)session.getAttribute("spellingstandardizerresults");
        if (standardizerResults != null && !fromForm) {
            session.setAttribute("spellingstandardizerresults", null);
            result = new ServletResult(false, standardizerResults, "Spelling Standardizer Example", "/morphadorner/spellingstandardizer/example/", "spellingstandardizerresults");
        } else {
            String spelling = "";
            String suggestion = "";
            SortedArrayList<ScoredString> suggestions = null;
            session.setAttribute("spellingSuggestions", null);
            if (suggest && (spelling = (spelling = request.getParameter("spelling")) == null ? "" : spelling.trim()).length() > 0) {
                if (extendedSearch) {
                    suggestions = new SortedArrayList<ScoredString>(adornerInfo.standardizer.getScoredSuggestedSpellings(EnglishDecruftifier.decruftify(spelling)));
                    suggestion = ((ScoredString)suggestions.get(suggestions.size() - 1)).getString();
                    if (suggestion.equals("?")) {
                        suggestion = adornerInfo.standardizer.standardizeSpelling(spelling, "");
                    }
                } else {
                    suggestions = null;
                    suggestion = adornerInfo.simpleStandardizer.standardizeSpelling(spelling, "");
                }
                session.setAttribute("spellingSuggestions", suggestions);
            }
            this.outputForm(out, spelling, suggestion, extendedSearch, adornerName);
            this.outputSuggestions(out, spelling, suggestions);
        }
        result = new ServletResult(fromForm, out.getString(), "Spelling Standardizer Example", "/morphadorner/spellingstandardizer/example/", "spellingstandardizerresults");
        return result;
    }

    public void outputSuggestions(PrintWriter out, String spelling, List<ScoredString> suggestions) {
        ScoredString scoredString;
        if (suggestions == null) {
            return;
        }
        if (suggestions.size() < 1) {
            return;
        }
        if (suggestions.size() == 1 && (scoredString = suggestions.get(0)).getString().equals("?")) {
            return;
        }
        out.println("<hr shade=\"noshade\" />");
        out.println("<h3>" + suggestions.size() + " suggested spellings and scores for <em>");
        out.println(spelling);
        out.println("</em></h3>");
        out.println("<table cellpadding=\"2\">");
        out.println("<tr>");
        out.println("<th align=\"left\">Suggestion</th>");
        out.println("<th align=\"left\">Score</th>");
        out.println("</tr>");
        for (int i = suggestions.size() - 1; i >= 0; --i) {
            ScoredString scoredString2 = suggestions.get(i);
            String sugSpelling = scoredString2.getString() + "";
            String sugScore = Formatters.formatDouble(scoredString2.getScore(), 4);
            out.println("<tr>");
            out.println("<td>" + sugSpelling + "</td>");
            out.println("<td>" + sugScore + "</td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }

    public void outputForm(PrintWriter out, String spelling, String suggestion, boolean extendedSearch, String adornerName) {
        out.println("<p>");
        out.println("Enter a spelling in the input box below.");
        out.println("Press <strong>Suggest</strong> to see ");
        out.println(" a likely standardized spelling.");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/spellingstandardizer/example/SpellingStandardizer\" name=\"spell\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.println("<td><strong>Spelling:</strong></td>");
        out.println("<td><input type=\"text\" name=\"spelling\"size = \"20\" value=\"" + spelling + "\" /></td>");
        out.println("</tr>");
        String checkedExtendedSearch = extendedSearch ? "checked=\"checked\"" : "";
        out.println("<tr>");
        out.println("<td>&nbsp;</td>");
        out.println("<td><input type=\"checkbox\" name=\"extendedsearch\"value=\"extendedsearch\" " + checkedExtendedSearch + " />Perform extended search for suggested spellings</td>");
        out.println("</tr>");
        this.outputAdornerSelection(out, "Lexicon:", adornerName);
        out.println("<tr>");
        out.println("<td>&nbsp;</td>");
        out.println("<td>");
        out.println("<input type=\"submit\" name=\"suggest\" value=\"Suggest\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td><strong>Suggestion:</strong></td>");
        out.println("<td><label type=\"text\" name=\"suggestion\"size = \"20\">" + suggestion + "</label></td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }
}

