/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.corpuslinguistics.sentencemelder.SentenceMelder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceSplitterServlet
extends BaseAdornerServlet {
    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SentenceSplitterServlet.initialize(config);
    }

    @Override
    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result = null;
        boolean clear = request.getParameter("clear") != null;
        boolean split = request.getParameter("split") != null;
        boolean fromForm = clear || split;
        String adornerName = request.getParameter("adornername");
        AdornerInfo adornerInfo = SentenceSplitterServlet.getAdornerInfo(adornerName);
        HttpSession session = request.getSession(true);
        String splitterResults = (String)session.getAttribute("sentencesplitterresults");
        if (splitterResults != null && !fromForm) {
            session.setAttribute("sentencesplitterresults", null);
            result = new ServletResult(false, splitterResults, "Sentence Splitter Example", "/morphadorner/sentencesplitter/example/", "sentencesplitterresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String text = "";
            List<List<String>> sentences = null;
            if (split && (text = (text = request.getParameter("text")) == null ? "" : this.unTag(text)).length() > 0) {
                sentences = adornerInfo.extractor.extractSentences(text);
            }
            this.outputForm(out, text, adornerName);
            this.outputSentences(out, sentences);
            result = new ServletResult(fromForm, out.getString(), "Sentence Splitter Example", "/morphadorner/sentencesplitter/example/", "sentencesplitterresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String text, String adornerName) {
        out.println("<p>");
        out.println("Enter text to split into sentences in the ");
        out.println("input field below.<br />");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/sentencesplitter/example/SentenceSplitter\" name=\"splitter\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.print("<td colspan=\"2\"><textarea name=\"text\" rows=\"10\" cols=\"50\">");
        out.print(text);
        out.println("</textarea>");
        out.println("</td>");
        out.println("</tr>");
        this.outputAdornerSelection(out, "Lexicon:", adornerName);
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td colspan=\"2\">");
        out.println("<input type=\"submit\" name=\"split\" value=\"Split\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }

    public void outputSentences(PrintWriter out, List<List<String>> sentences) {
        if (sentences == null) {
            return;
        }
        out.println("<hr noshade=\"noshade\" />");
        switch (sentences.size()) {
            case 0: {
                out.println("<h3>No sentences found.</h3>");
                return;
            }
            case 1: {
                out.println("<h3>1 sentence found.</h3>");
                break;
            }
            default: {
                out.println("<h3>" + sentences.size() + " sentences found.</h3>");
            }
        }
        out.println("<table width=\"100%\">");
        out.println("<tr>");
        out.println("<th class=\"width1pct\" align=\"left\">");
        out.println("S#");
        out.println("</th>");
        out.println("<th class=\"width99pct\" align=\"left\">");
        out.println("Sentence Text");
        out.println("</th>");
        out.println("</tr>");
        SentenceMelder melder = new SentenceMelder();
        for (int i = 0; i < sentences.size(); ++i) {
            List<String> sentence = sentences.get(i);
            String sentenceText = melder.reconstituteSentence(sentence);
            out.println("<tr>");
            out.println("<td valign=\"top\" class=\"width1pct\">");
            out.println(i + 1 + "");
            out.println("</td>");
            out.println("<td class=\"width99pct\">");
            out.println(sentenceText);
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }
}

