/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PluralizerServlet
extends BaseAdornerServlet {
    protected String notReadyMessage = "Pluralizer still initializing, please try again later.";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        PluralizerServlet.initialize(config);
    }

    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result;
        boolean clear = request.getParameter("clear") != null;
        boolean pluralize = request.getParameter("pluralize") != null;
        boolean fromForm = clear || pluralize;
        HttpSession session = request.getSession(true);
        String pluralizerResults = (String)session.getAttribute("pluralizerresults");
        if (pluralizerResults != null && !fromForm) {
            session.setAttribute("pluralizeresults", null);
            result = new ServletResult(false, pluralizerResults, "Noun Pluralizer Example", "/morphadorner/pluralizer/example", "pluralizerresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String noun = "";
            String plural = "";
            String american = request.getParameter("american");
            if (pluralize && (noun = (noun = request.getParameter("noun")) == null ? "" : noun.trim()).length() > 0) {
                plural = inflector.pluralize(noun);
            }
            if (american != null) {
                noun = britishToUS.mapSpelling(noun);
                plural = britishToUS.mapSpelling(plural);
            }
            this.outputForm(out, noun, plural, american);
            result = new ServletResult(fromForm, out.getString(), "Pluralizer Example", "/morphadorner/pluralizer/example/", "pluralizeresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String noun, String plural, String american) {
        out.println("<p>");
        out.println("Enter a singular noun in the input box below.");
        out.println("Press <strong>Pluralize</strong> to see ");
        out.println("the plural form of the noun. ");
        out.println("Check <strong>American spellings</strong> to display American instead of British spellings.");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/pluralizer/example/Pluralizer\" name=\"pluralizer\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.println("<td><strong>Noun:</strong></td>");
        out.println("<td><input type=\"text\" name=\"noun\"size = \"20\" value=\"" + noun + "\" /></td>");
        out.println("</tr>");
        String checkedAmerican = american == null ? "" : "checked=\"checked\"";
        out.println("<tr>");
        out.println("<td>&nbsp;</td>");
        out.println("<td><input type=\"checkbox\" name=\"american\"value=\"american\" " + checkedAmerican + "/>American spellings</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>");
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td>");
        out.println("<input type=\"submit\" name=\"pluralize\" value=\"Pluralize\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        this.outputSpacerRow(out, 2);
        if (noun != null && noun.length() > 0) {
            out.println("<tr>");
            out.println("<td><strong>Plural:</strong></td>");
            out.println("<td><label type=\"text\" name=\"plural\"size = \"20\">" + plural + "</label></td>");
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("</form>");
    }

    protected static String singularPossessive(String singularNoun) {
        return singularNoun + "'s";
    }

    protected static String pluralPossessive(String pluralNoun) {
        String result = pluralNoun.endsWith("s") || pluralNoun.endsWith("S") ? pluralNoun + "'" : pluralNoun + "'s";
        return result;
    }
}

