/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartOfSpeechTaggerServlet
extends BaseAdornerServlet {
    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        PartOfSpeechTaggerServlet.initialize(config);
    }

    @Override
    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result = null;
        boolean clear = request.getParameter("clear") != null;
        boolean tag = request.getParameter("tag") != null;
        String adornerName = request.getParameter("adornername");
        if (adornerName == null) {
            adornerName = "ncf";
        }
        boolean showLemma = request.getParameter("lemma") != null;
        boolean showStandard = request.getParameter("standard") != null;
        boolean contWordNumbers = request.getParameter("contword") != null;
        boolean fromForm = clear || tag;
        AdornerInfo adornerInfo = PartOfSpeechTaggerServlet.getAdornerInfo(adornerName);
        HttpSession session = request.getSession(true);
        String taggerResults = (String)session.getAttribute("postaggerresults");
        if (taggerResults != null && !fromForm) {
            session.setAttribute("postaggerresults", null);
            result = new ServletResult(false, taggerResults, "Part of Speech Tagger Example", "/morphadorner/postagger/example/", "postaggerresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String text = "";
            List<List<String>> sentences = null;
            List<List<AdornedWord>> taggedSentences = null;
            if (tag && (text = (text = request.getParameter("text")) == null ? "" : this.unTag(text)).length() > 0) {
                sentences = adornerInfo.extractor.extractSentences(text);
                taggedSentences = adornerInfo.tagger.tagSentences(sentences);
            }
            this.outputForm(out, text, adornerName, contWordNumbers, showStandard, showLemma, adornerInfo);
            this.outputTaggedWords(out, taggedSentences, contWordNumbers, showStandard, showLemma, adornerInfo);
            result = new ServletResult(fromForm, out.getString(), "Part of Speech Tagger Example", "/morphadorner/postagger/example/", "postaggerresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String text, String adornerName, boolean contWordNumbers, boolean showStandard, boolean showLemma, AdornerInfo adornerInfo) {
        out.println("<p>");
        out.println("Enter text to tag in the ");
        out.println("input field below.");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/postagger/example/PartOfSpeechTagger\" name=\"postagger\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.print("<td colspan=\"2\"><textarea name=\"text\" rows=\"10\" cols=\"50\">");
        out.print(text);
        out.println("</textarea>");
        out.println("</td>");
        out.println("</tr>");
        this.outputAdornerSelection(out, "Lexicon:", adornerName);
        String checkedContinuous = contWordNumbers ? "checked=\"checked\"" : "";
        out.println("<tr>");
        out.println("<td><strong>Options:</strong></td>");
        out.println("<td><input type=\"checkbox\" name=\"contword\"value=\"contword\" " + checkedContinuous + " />Show continuous word numbers</td>");
        out.println("</tr>");
        String checkedStandard = showStandard ? "checked=\"checked\"" : "";
        out.println("<tr>");
        out.println("<td>&nbsp;</td>");
        out.println("<td><input type=\"checkbox\" name=\"standard\"value=\"standard\" " + checkedStandard + " />Show standardized spelling</td>");
        out.println("</tr>");
        String checkedLemma = showLemma ? "checked=\"checked\"" : "";
        out.println("<tr>");
        out.println("<td>&nbsp;</td>");
        out.println("<td><input type=\"checkbox\" name=\"lemma\"value=\"lemma\" " + checkedLemma + " />Show lemma</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td colspan=\"2\">");
        out.println("<input type=\"submit\" name=\"tag\" value=\"Tag\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }

    public void outputTaggedWords(PrintWriter out, List<List<AdornedWord>> taggedSentences, boolean contWordNumbers, boolean showStandard, boolean showLemma, AdornerInfo adornerInfo) {
        if (taggedSentences == null) {
            return;
        }
        out.println("<hr noshade=\"noshade\" />");
        out.println("<table width=\"100%\">");
        out.println("<tr>");
        out.println("<th align=\"left\" class=\"width1pct\">");
        out.println("S#");
        out.println("</th>");
        out.println("<th align=\"left\" class=\"width1pct\">");
        out.println("W#");
        out.println("</th>");
        out.println("<th align=\"left\" class=\"width48pct\">");
        out.println("Word");
        out.println("</th>");
        out.println("<th align=\"left\" class=\"width48pct\">");
        out.println("Tag");
        out.println("</th>");
        if (showStandard) {
            out.println("<th align=\"left\" class=\"width48pct\">");
            out.println("Standard");
            out.println("</th>");
        }
        if (showLemma) {
            out.println("<th align=\"left\" class=\"width48pct\">");
            out.println("Lemma");
            out.println("</th>");
        }
        out.println("</tr>");
        String standardSpelling = "";
        int wordNumber = 0;
        for (int i = 0; i < taggedSentences.size(); ++i) {
            List<AdornedWord> taggedWords = taggedSentences.get(i);
            if (!contWordNumbers) {
                wordNumber = 0;
            }
            for (int j = 0; j < taggedWords.size(); ++j) {
                AdornedWord wordAndTag = taggedWords.get(j);
                out.println("<tr>");
                out.println("<td valign=\"top\" class=\"width1pct\">");
                out.println(i + 1 + "");
                out.println("</td>");
                out.println("<td valign=\"top\" class=\"width1pct\">");
                out.println(++wordNumber + "");
                out.println("</td>");
                out.println("<td valign=\"top\" class=\"width48pct\">");
                out.println(wordAndTag.getSpelling());
                out.println("</td>");
                out.println("<td valign=\"top\" class=\"width48pct\">");
                out.println(wordAndTag.getPartsOfSpeech());
                out.println("</td>");
                if (showStandard) {
                    standardSpelling = adornerInfo.standardizer.standardizeSpelling(wordAndTag.getSpelling(), wordAndTag.getPartsOfSpeech());
                    out.println("<td valign=\"top\" class=\"width48pct\">");
                    out.println(standardSpelling);
                    out.println("</td>");
                }
                if (showLemma) {
                    String lemma = adornerInfo.wordLexicon.getLemma(wordAndTag.getSpelling(), wordAndTag.getPartsOfSpeech());
                    if (lemma.equals("*") && lemmatizer != null) {
                        lemma = standardSpelling.length() > 0 ? lemmatizer.lemmatize(standardSpelling, adornerInfo.partOfSpeechTags.getLemmaWordClass(wordAndTag.getPartsOfSpeech())) : lemmatizer.lemmatize(wordAndTag.getSpelling(), adornerInfo.partOfSpeechTags.getLemmaWordClass(wordAndTag.getPartsOfSpeech()));
                    }
                    out.println("<td valign=\"top\" class=\"width48pct\">");
                    out.println(lemma);
                    out.println("</td>");
                }
                out.println("</tr>");
            }
            out.println("<tr>");
            out.println("<td colspan=\"4\">");
            out.println("<hr shade=\"noshade\">");
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }
}

