/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jlinkgrammar.Linkage;
import net.sf.jlinkgrammar.Sentence;

public class ParserServlet
extends BaseAdornerServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ParserServlet.initialize(config);
    }

    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result = null;
        boolean clear = request.getParameter("clear") != null;
        boolean parse = request.getParameter("parse") != null;
        boolean fromForm = clear || parse;
        HttpSession session = request.getSession(true);
        String parserResults = (String)session.getAttribute("parserresults");
        if (parserResults != null && !fromForm) {
            session.setAttribute("parserresults", null);
            result = new ServletResult(false, parserResults, "Parser Example", "/morphadorner/parser/example/", "parserresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String text = "";
            String parsedText = "";
            if (parse && (text = (text = request.getParameter("text")) == null ? "" : this.unTag(text)).length() > 0) {
                Sentence sentence = this.parse(text);
                if (sentence.sentence_num_linkages_found() < 1) {
                    parsedText = "No linkage was found.";
                } else {
                    Linkage link = this.getLinkage(sentence, 0);
                    parsedText = link.linkage_print_diagram() + "\n";
                    parsedText = parsedText + ParserServlet.fixOutput(link.linkage_print_links_and_domains());
                }
            }
            this.outputForm(out, text);
            this.outputParsedText(out, parsedText);
            result = new ServletResult(fromForm, out.getString(), "Parser Example", "/morphadorner/parser/example/", "parserresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String text) {
        out.println("<p>");
        out.println("Enter sentence to parse in the ");
        out.println("input field below.<br />");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/parser/example/Parser\" name=\"parser\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.print("<td colspan=\"2\"><textarea name=\"text\" rows=\"10\" cols=\"50\">");
        out.print(text);
        out.println("</textarea>");
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td colspan=\"2\">");
        out.println("<input type=\"submit\" name=\"parse\" value=\"Parse\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }

    public void outputParsedText(PrintWriter out, String parsedText) {
        if (parsedText == null) {
            return;
        }
        out.println("<hr noshade=\"noshade\" />");
        out.println("<table width=\"100%\">");
        out.println("<tr>");
        out.println("<th>");
        out.println("Parsed Text");
        out.println("</th>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>");
        out.println("<pre>");
        out.println(parsedText);
        out.println("</pre>");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
    }

    public Linkage getLinkage(Sentence sentence, int index) {
        return new Linkage(index, sentence, parseOptions);
    }

    public Sentence parse(String s2) {
        Sentence sentence = new Sentence(s2, dictionary, parseOptions);
        sentence.sentence_parse(parseOptions);
        return sentence;
    }

    protected static String fixOutput(String s2) {
        String token;
        int j;
        StringTokenizer tokenizer;
        String line;
        int i;
        int[] colWidths = new int[6];
        for (int i2 = 0; i2 < colWidths.length; ++i2) {
            colWidths[i2] = 0;
        }
        String[] lines = s2.split("\n");
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (line.equals("\n")) continue;
            tokenizer = new StringTokenizer(line);
            j = 0;
            if (line.charAt(0) == ' ') {
                ++j;
            }
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim();
                colWidths[j] = Math.max(colWidths[j], token.length());
                ++j;
            }
        }
        i = 0;
        while (i < colWidths.length) {
            int n = i++;
            colWidths[n] = colWidths[n] + 2;
        }
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            if (line.equals("\n")) continue;
            tokenizer = new StringTokenizer(line);
            j = 0;
            if (line.charAt(0) == ' ') {
                sb.append(StringUtils.dupl(" ", colWidths[j++]));
            }
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                sb.append(StringUtils.rpad(token, colWidths[j++]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

