/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameRecognizerServlet
extends BaseAdornerServlet {
    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        NameRecognizerServlet.initialize(config);
    }

    @Override
    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result = null;
        HttpSession session = request.getSession(true);
        boolean clear = request.getParameter("clear") != null;
        boolean extract = request.getParameter("extract") != null;
        boolean fromForm = clear || extract;
        String adornerName = request.getParameter("adornername");
        AdornerInfo adornerInfo = NameRecognizerServlet.getAdornerInfo(adornerName);
        String recognizerResults = (String)session.getAttribute("namerecognizerresults");
        if (recognizerResults != null && !fromForm) {
            session.setAttribute("namerecognizerresults", null);
            result = new ServletResult(false, recognizerResults, "Name Recognizer Example", "/morphadorner/namerecognizer/example/", "namerecognizerresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String text = "";
            Set<String>[] namesInText = null;
            if (extract && (text = (text = request.getParameter("text")) == null ? "" : this.unTag(text)).length() > 0) {
                namesInText = this.extractNames(out, adornerInfo, text);
            }
            this.outputForm(out, text, adornerName);
            this.outputNames(out, namesInText);
            result = new ServletResult(fromForm, out.getString(), "Name Recognizer Example", "/morphadorner/namerecognizer/example/", "namerecognizerresults");
        }
        return result;
    }

    protected Set<String>[] extractNames(PrintWriter out, AdornerInfo adornerInfo, String text) {
        return adornerInfo.nameRecognizer.findNames(text);
    }

    public void outputForm(PrintWriter out, String text, String adornerName) {
        out.println("<p>");
        out.println("Enter text from which to extract names in the ");
        out.println("input field below.<br />");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/namerecognizer/example/NameRecognizer\" name=\"recognizer\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.print("<td colspan=\"2\"><textarea name=\"text\" rows=\"10\" cols=\"50\">");
        out.print(text);
        out.println("</textarea>");
        out.println("</td>");
        out.println("</tr>");
        this.outputAdornerSelection(out, "Lexicon:", adornerName);
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td colspan=\"2\">");
        out.println("<input type=\"submit\" name=\"extract\" value=\"Extract Names\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }

    public void outputNameSet(PrintWriter out, Set<String> nameSet, String nameType) {
        if (nameSet == null) {
            return;
        }
        out.println("<hr noshade=\"noshade\" />");
        switch (nameSet.size()) {
            case 0: {
                out.println("<h3>No " + nameType + "s found.</h3>");
                return;
            }
            case 1: {
                out.println("<h3>1 " + nameType + " found.</h3>");
                break;
            }
            default: {
                out.println("<h3>" + nameSet.size() + " " + nameType + "s found.</h3>");
            }
        }
        out.println("<table width=\"100%\">");
        Object[] names = nameSet.toArray(new String[nameSet.size()]);
        Arrays.sort(names);
        for (int i = 0; i < names.length; ++i) {
            out.println("<tr>");
            out.println("<td valign=\"top\" class=\"width1pct\">");
            out.println(i + 1 + "");
            out.println("</td>");
            out.println("<td class=\"width99pct\">");
            out.println((String)names[i]);
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }

    public void outputNames(PrintWriter out, Set<String>[] nameSets) {
        if (nameSets == null) {
            return;
        }
        this.outputNameSet(out, nameSets[0], "proper name");
        this.outputNameSet(out, nameSets[1], "place name");
    }
}

