/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.KeyedSets;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.LexiconEntry;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexiconLookupServlet
extends BaseAdornerServlet {
    protected String notReadyMessage = "Lexicon lookup still initializing, please try again later.";

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LexiconLookupServlet.initialize(config);
    }

    @Override
    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result;
        boolean clear = request.getParameter("clear") != null;
        boolean lookup = request.getParameter("lookup") != null;
        boolean fromForm = clear || lookup;
        String adornerName = request.getParameter("adornername");
        AdornerInfo adornerInfo = LexiconLookupServlet.getAdornerInfo(adornerName);
        HttpSession session = request.getSession(true);
        String lexiconLookupResults = (String)session.getAttribute("lexiconlookupresults");
        if (lexiconLookupResults != null && !fromForm) {
            session.setAttribute("lemmatizerresults", null);
            result = new ServletResult(false, lexiconLookupResults, "Lexicon Lookup Example", "/morphadorner/lexiconlookup/example/", "lexiconlookupresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String spelling = "";
            LexiconEntry lexiconEntry = null;
            if (lookup && (spelling = (spelling = request.getParameter("spelling")) == null ? "" : spelling.trim()).length() > 0) {
                Lexicon lexicon = adornerInfo.wordLexicon;
                lexiconEntry = lexicon.getLexiconEntry(spelling);
            }
            this.outputForm(out, spelling, adornerName);
            this.outputLexiconEntry(out, spelling, adornerName, lexiconEntry, adornerInfo.lemmaToSpellings);
            result = new ServletResult(fromForm, out.getString(), "Lexicon Lookup Example", "/morphadorner/lexiconlookup/example/", "lexiconlookupresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String spelling, String adornerName) {
        out.println("<p>");
        out.println("Enter a spelling in the input box below. ");
        out.println("Press <strong>Lookup</strong> to see ");
        out.println("the associated information in the lexicon. ");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/lexiconlookup/example/LexiconLookup\" name=\"lookup\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.println("<td><strong>Spelling:</strong></td>");
        out.println("<td><input type=\"text\" name=\"spelling\"size = \"20\" value=\"" + spelling + "\" /></td>");
        out.println("</tr>");
        out.println("</td>");
        out.println("<td>&nbsp;</td>");
        out.println("</tr>");
        this.outputAdornerSelection(out, "Lexicon:", adornerName);
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td>");
        out.println("<input type=\"submit\" name=\"lookup\" value=\"Lookup\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }

    public void outputLexiconEntry(PrintWriter out, String spelling, String corpusName, LexiconEntry lexiconEntry, KeyedSets<String, String> lemmaToSpellings) {
        if (lexiconEntry == null && spelling.length() == 0) {
            return;
        }
        out.println("<hr noshade=\"noshade\" />");
        if (lexiconEntry == null) {
            out.println("<h3><em>" + spelling + "</em> does not appear in " + "the " + corpusName + " corpus.</h3>");
            return;
        }
        out.println("<h3><em>" + spelling + "</em> appears " + Formatters.formatIntegerWithCommas(lexiconEntry.entryCount) + " time" + (lexiconEntry.entryCount == 1 ? "" : "s") + " in the " + corpusName + " corpus.</h3>");
        out.println("<table width=\"100%\">");
        out.println("<tr>");
        out.println("<th align=\"left\" class=\"width1pct\">");
        out.println("Part of Speech");
        out.println("</th>");
        out.println("<th align=\"left\" class=\"width1pct\">");
        out.println("Lemma");
        out.println("</th>");
        out.println("<th align=\"left\" class=\"width1pct\">");
        out.println("Count");
        out.println("</th>");
        out.println("</tr>");
        Iterator<String> iterator = lexiconEntry.categoriesAndCounts.keySet().iterator();
        TreeSet<String> lemmata = new TreeSet<String>();
        while (iterator.hasNext()) {
            String posTag = iterator.next();
            String lemma = lexiconEntry.lemmata.get(posTag);
            lemmata.add(lemma);
            int count = lexiconEntry.categoriesAndCounts.get(posTag).intValue();
            out.println("<tr>");
            out.println("<td valign=\"top\" class=\"width1pct\">");
            out.println(posTag);
            out.println("</td>");
            out.println("<td valign=\"top\" class=\"width1pct\">");
            out.println(lemma);
            out.println("</td>");
            out.println("<td valign=\"top\" class=\"width1pct\">");
            out.println(Formatters.formatIntegerWithCommas(count));
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
        for (String theLemma : lemmata) {
            Set spellingsSet = (Set)lemmaToSpellings.get(theLemma);
            spellingsSet.remove(spelling);
            if (spellingsSet.size() <= 0) continue;
            out.println("<h4>Other spellings taking " + theLemma + " as the lemma.</h4>");
            StringBuffer sb = new StringBuffer();
            String[] spellings = spellingsSet.toArray(new String[spellingsSet.size()]);
            sb.append(spellings[0]);
            for (int i = 1; i < spellings.length; ++i) {
                sb.append(", ");
                sb.append(spellings[i]);
            }
            out.println("<blockquote>");
            out.println(sb);
            out.println("</blockquote>");
        }
    }
}

