/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.StringPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LemmatizerServlet
extends BaseAdornerServlet {
    protected String notReadyMessage = "Lemmatizer still initializing, please try again later.";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LemmatizerServlet.initialize(config);
    }

    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result;
        boolean clear = request.getParameter("clear") != null;
        boolean lemmatize = request.getParameter("lemmatize") != null;
        boolean fromForm = clear || lemmatize;
        String adornerName = request.getParameter("adornername");
        AdornerInfo adornerInfo = LemmatizerServlet.getAdornerInfo(adornerName);
        HttpSession session = request.getSession(true);
        String lemmatizerResults = (String)session.getAttribute("lemmatizerresults");
        if (lemmatizerResults != null && !fromForm) {
            session.setAttribute("lemmatizerresults", null);
            result = new ServletResult(false, lemmatizerResults, "Lemmatizer Example", "/morphadorner/lemmatizer/example/", "lemmatizerresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String spelling = "";
            String wordClass = "";
            String wordClass2 = "";
            String standardize = "";
            String lemma = "";
            String porterStem = "";
            String lancasterStem = "";
            if (lemmatize) {
                spelling = request.getParameter("spelling");
                spelling = spelling == null ? "" : spelling.trim();
                wordClass = request.getParameter("wordclass");
                wordClass = wordClass == null ? "" : wordClass.trim();
                wordClass2 = request.getParameter("wordclass2");
                wordClass2 = wordClass2 == null ? "" : wordClass2.trim();
                standardize = request.getParameter("standardize");
                if (spelling.length() > 0) {
                    if (standardize != null) {
                        spelling = adornerInfo.standardizer.standardizeSpelling(spelling, "");
                    }
                    lemma = wordClass.length() > 0 ? (wordClass2.length() > 0 ? lemmatizer.lemmatize(spelling, wordClass + "," + wordClass2) : lemmatizer.lemmatize(spelling, wordClass)) : lemmatizer.lemmatize(spelling);
                    porterStem = porterStemmer.stem(spelling);
                    lancasterStem = lancasterStemmer.stem(spelling);
                }
            }
            this.outputForm(out, spelling, lemma, wordClass, wordClass2, standardize, porterStem, lancasterStem, adornerName);
            result = new ServletResult(fromForm, out.getString(), "Lemmatizer Example", "/morphadorner/lemmatizer/example/", "lemmatizerresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String spelling, String lemma, String wordClass, String wordClass2, String standardize, String porterStem, String lancasterStem, String adornerName) {
        out.println("<p>");
        out.println("Enter a spelling and optionally a word class in the ");
        out.println("input boxes below. ");
        out.println("Press <strong>Lemmatize</strong> to see ");
        out.println("the lemmatized form. ");
        out.println("Check <strong>Standardize spelling</strong> to standardize nonstandard spellings before lemmatization.");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/lemmatizer/example/Lemmatizer\" name=\"spell\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.println("<td><strong>Spelling:</strong></td>");
        out.println("<td><input type=\"text\" name=\"spelling\"size = \"20\" value=\"" + spelling + "\" /></td>");
        out.println("</tr>");
        String checkedStandardize = standardize == null ? "" : "checked=\"checked\"";
        out.println("<tr>");
        out.println("<td>");
        out.println("<td><input type=\"checkbox\" name=\"standardize\"value=\"standardize\" " + checkedStandardize + " />Standardize spelling</td>");
        out.println("</td>");
        out.println("<td>&nbsp;</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><strong>Primary word class:</strong></td>");
        out.println("<td>");
        out.println("<select name=\"wordclass\">");
        this.outputSelect(out, "", wordClass.length() == 0);
        this.outputSelect(out, "adjective", wordClass.equals("adjective"));
        this.outputSelect(out, "adverb", wordClass.equals("adverb"));
        this.outputSelect(out, "compound", wordClass.equals("compound"));
        this.outputSelect(out, "conjunction", wordClass.equals("conjunction"));
        this.outputSelect(out, "infinitive-to", wordClass.equals("infinitive-to"));
        this.outputSelect(out, "noun", wordClass.equals("noun"));
        this.outputSelect(out, "noun-possessive", wordClass.equals("possessive-noun"));
        this.outputSelect(out, "preposition", wordClass.equals("preposition"));
        this.outputSelect(out, "pronoun", wordClass.equals("pronoun"));
        this.outputSelect(out, "pronoun-possessive", wordClass.equals("pronoun-possessive"));
        this.outputSelect(out, "pronoun-possessive-determiner", wordClass.equals("pronoun-possessive-determiner"));
        this.outputSelect(out, "verb", wordClass.equals("verb"));
        out.println("</select>");
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><strong>Secondary word class:</strong></td>");
        out.println("<td>");
        out.println("<select name=\"wordclass2\">");
        this.outputSelect(out, "", wordClass2.length() == 0);
        this.outputSelect(out, "adjective", wordClass2.equals("adjective"));
        this.outputSelect(out, "adverb", wordClass2.equals("adverb"));
        this.outputSelect(out, "compound", wordClass2.equals("compound"));
        this.outputSelect(out, "conjunction", wordClass2.equals("conjunction"));
        this.outputSelect(out, "infinitive-to", wordClass2.equals("infinitive-to"));
        this.outputSelect(out, "noun", wordClass2.equals("noun"));
        this.outputSelect(out, "noun-possessive", wordClass2.equals("possessive-noun"));
        this.outputSelect(out, "preposition", wordClass2.equals("preposition"));
        this.outputSelect(out, "pronoun", wordClass2.equals("pronoun"));
        this.outputSelect(out, "pronoun-possessive", wordClass2.equals("pronoun-possessive"));
        this.outputSelect(out, "pronoun-possessive-determiner", wordClass2.equals("pronoun-possessive-determiner"));
        this.outputSelect(out, "verb", wordClass2.equals("verb"));
        out.println("</select>");
        out.println("</td>");
        out.println("</tr>");
        this.outputAdornerSelection(out, "Lexicon:", adornerName);
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td>");
        out.println("<input type=\"submit\" name=\"lemmatize\" value=\"Lemmatize\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        this.outputSpacerRow(out, 2);
        out.println("<tr>");
        out.println("<td><strong>Lemma:</strong></td>");
        out.println("<td><label type=\"text\" name=\"lemma\"size = \"20\">" + lemma + "</label></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><strong>Porter stem:</strong></td>");
        out.println("<td><label type=\"text\" name=\"porter\"size = \"20\">" + porterStem + "</label></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><strong>Lancaster stem:</strong></td>");
        out.println("<td><label type=\"text\" name=\"lancaster\"size = \"20\">" + lancasterStem + "</label></td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }
}

