/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.BaseAdornerServlet;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.StringPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LanguageRecognizerServlet
extends BaseAdornerServlet {
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LanguageRecognizerServlet.initialize(config);
    }

    protected ServletResult handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult result = null;
        HttpSession session = request.getSession(true);
        boolean clear = request.getParameter("clear") != null;
        boolean recognize = request.getParameter("recognize") != null;
        boolean fromForm = clear || recognize;
        String recognizerResults = (String)session.getAttribute("languagerecognizerresults");
        if (recognizerResults != null && !fromForm) {
            session.setAttribute("languagerecognizerresults", null);
            result = new ServletResult(false, recognizerResults, "Language Recognizer Example", "/morphadorner/languagerecognizer/example/", "languagerecognizerresults");
        } else {
            StringPrintWriter out = new StringPrintWriter();
            String text = "";
            ScoredString[] languages = null;
            session.setAttribute("languageSuggestions", null);
            if (recognize) {
                text = request.getParameter("text");
                text = text == null ? "" : this.unTag(text);
                if (text.length() > 0) {
                    languages = languageRecognizer.recognizeLanguage(text);
                }
                session.setAttribute("languageSuggestions", languages);
            }
            this.outputForm(out, text);
            this.outputLanguages(out, languages);
            result = new ServletResult(fromForm, out.getString(), "Language Recognizer Example", "/morphadorner/languagerecognizer/example/", "languagerecognizerresults");
        }
        return result;
    }

    public void outputForm(PrintWriter out, String text) {
        out.println("<p>");
        out.println("Enter text for which to recognize the language in the ");
        out.println("input field below.<br />");
        out.println("</p>");
        out.println("<form method=\"post\" action=\"/morphadorner/languagerecognizer/example/LanguageRecognizer\" name=\"recognizer\">");
        out.println("<table cellpadding=\"0\" cellspacing=\"5\">");
        out.println("<tr>");
        out.print("<td><textarea name=\"text\" rows=\"10\" cols=\"50\">");
        out.print(text);
        out.println("</textarea>");
        out.println("</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>&nbsp;</td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td>");
        out.println("<input type=\"submit\" name=\"recognize\" value=\"Recognize\" />");
        out.println("<input type=\"submit\" name=\"clear\" value=\"Clear\" />");
        out.println("</td>");
        out.println("</tr>");
        out.println("</table>");
        out.println("</form>");
    }

    public void outputLanguages(PrintWriter out, ScoredString[] languages) {
        if (languages == null) {
            return;
        }
        if (languages.length < 1) {
            return;
        }
        out.println("<hr shade=\"noshade\" />");
        out.println("<h3>");
        switch (languages.length) {
            case 0: {
                out.println("<h3>No language identified.</h3>");
                return;
            }
            case 1: {
                out.println("1 language identified.</h3>");
                break;
            }
            default: {
                out.println(languages.length + " languages identified.");
            }
        }
        out.println("</h3>");
        out.println("<table cellpadding=\"2\">");
        out.println("<tr>");
        out.println("<th align=\"left\">Language</th>");
        out.println("<th align=\"left\">Score</th>");
        out.println("</tr>");
        for (int i = 0; i < languages.length; ++i) {
            ScoredString scoredString = languages[i];
            String language = scoredString.getString() + "";
            String score = Formatters.formatDouble(scoredString.getScore(), 4);
            out.println("<tr>");
            out.println("<td>" + language + "</td>");
            out.println("<td>" + score + "</td>");
            out.println("</tr>");
        }
        out.println("</table>");
    }
}

