/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.morphadorner.servlets.AdornerInfo;
import edu.northwestern.at.morphadorner.servlets.ServletResult;
import edu.northwestern.at.utils.SingleTagTaggedStrings;
import edu.northwestern.at.utils.StringPrintWriter;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.TextFile;
import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.corpuslinguistics.inflector.EnglishInflector;
import edu.northwestern.at.utils.corpuslinguistics.inflector.Inflector;
import edu.northwestern.at.utils.corpuslinguistics.languagerecognizer.DefaultLanguageRecognizer;
import edu.northwestern.at.utils.corpuslinguistics.languagerecognizer.LanguageRecognizer;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.DefaultLemmatizer;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.Lemmatizer;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.Names;
import edu.northwestern.at.utils.corpuslinguistics.spellingmapper.BritishToUSSpellingMapper;
import edu.northwestern.at.utils.corpuslinguistics.spellingmapper.SpellingMapper;
import edu.northwestern.at.utils.corpuslinguistics.stemmer.LancasterStemmer;
import edu.northwestern.at.utils.corpuslinguistics.stemmer.PorterStemmer;
import edu.northwestern.at.utils.corpuslinguistics.stemmer.Stemmer;
import edu.northwestern.at.utils.html.HTMLUtils;
import edu.northwestern.at.utils.servlets.XHttpServlet;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.ParseOptions;

public abstract class BaseAdornerServlet
extends XHttpServlet {
    protected boolean outputFullHTML = true;
    protected static String defaultDataDirectory = "/nupos";
    protected static String dataDirectory;
    protected static AdornerInfo ncfAdornerInfo;
    protected static String ncfWordLexiconFileName;
    protected static String ncfSuffixLexiconFileName;
    protected static String ncfSpellingPairsFileName;
    protected static String ncfTransitionMatrixFileName;
    protected static AdornerInfo emeAdornerInfo;
    protected static String emeWordLexiconFileName;
    protected static String emeSuffixLexiconFileName;
    protected static String emeTransitionMatrixFileName;
    protected static String emeSpellingPairsFileName;
    protected static String standardSpellingsFileName;
    protected static Lemmatizer lemmatizer;
    protected static Stemmer porterStemmer;
    protected static Stemmer lancasterStemmer;
    protected static Names names;
    protected static LanguageRecognizer languageRecognizer;
    protected static Inflector inflector;
    protected static SpellingMapper britishToUS;
    protected static String extraWordsFileName;
    protected static String latinWordsFileName;
    protected static TaggedStrings latinWords;
    protected static TaggedStrings extraWords;
    protected static Dictionary dictionary;
    protected static ParseOptions parseOptions;
    protected static String lgParserDataDirectory;
    protected static final int INITNOTSTARTED = 0;
    protected static final int INITINPROGRESS = 1;
    protected static final int INITDONE = 2;
    protected static final int INITFAILED = 3;
    protected static int initializationStatus;
    protected static final String servletNotReadyMessage = "Servlet not yet ready, please try again in a minute.";
    protected static final String servletNotReadyTitle = "Servlet not ready";

    protected static synchronized void doInitialization(ServletConfig config) {
        if (initializationStatus != 0) {
            return;
        }
        try {
            initializationStatus = 1;
            dataDirectory = defaultDataDirectory;
            if (config.getInitParameter("datadirectory") != null) {
                dataDirectory = config.getInitParameter("datadirectory").trim();
            }
            if (dataDirectory.length() == 0) {
                File tryDir = new File("data");
                if (tryDir.exists()) {
                    dataDirectory = tryDir.getAbsolutePath();
                    dataDirectory = new File(dataDirectory).getCanonicalPath();
                } else {
                    tryDir = new File("../data");
                    if (tryDir.exists()) {
                        dataDirectory = tryDir.getAbsolutePath();
                        dataDirectory = new File(dataDirectory).getCanonicalPath();
                    }
                }
            }
            ncfWordLexiconFileName = dataDirectory + ncfWordLexiconFileName;
            ncfSuffixLexiconFileName = dataDirectory + ncfSuffixLexiconFileName;
            ncfSpellingPairsFileName = dataDirectory + ncfSpellingPairsFileName;
            ncfTransitionMatrixFileName = dataDirectory + ncfTransitionMatrixFileName;
            emeWordLexiconFileName = dataDirectory + emeWordLexiconFileName;
            emeSuffixLexiconFileName = dataDirectory + emeSuffixLexiconFileName;
            emeSpellingPairsFileName = dataDirectory + emeSpellingPairsFileName;
            emeTransitionMatrixFileName = dataDirectory + emeTransitionMatrixFileName;
            standardSpellingsFileName = dataDirectory + standardSpellingsFileName;
            extraWordsFileName = dataDirectory + extraWordsFileName;
            latinWordsFileName = dataDirectory + latinWordsFileName;
            lgParserDataDirectory = dataDirectory + lgParserDataDirectory;
            if (latinWords == null) {
                latinWords = BaseAdornerServlet.getLatinWordsList();
            }
            if (extraWords == null) {
                extraWords = BaseAdornerServlet.getExtraWordsList();
            }
            TaggedStrings[] extraWordLists = new TaggedStrings[]{extraWords, latinWords};
            if (emeAdornerInfo == null) {
                emeAdornerInfo = new AdornerInfo(emeWordLexiconFileName, emeSuffixLexiconFileName, emeTransitionMatrixFileName, standardSpellingsFileName, emeSpellingPairsFileName, extraWordLists, names);
            }
            if (ncfAdornerInfo == null) {
                ncfAdornerInfo = new AdornerInfo(ncfWordLexiconFileName, ncfSuffixLexiconFileName, ncfTransitionMatrixFileName, standardSpellingsFileName, ncfSpellingPairsFileName, extraWordLists, names);
            }
            if (lemmatizer == null) {
                lemmatizer = new DefaultLemmatizer();
                lemmatizer.setDictionary(BaseAdornerServlet.ncfAdornerInfo.standardizer.getStandardSpellings());
            }
            if (parseOptions == null) {
                parseOptions = new ParseOptions();
                parseOptions.parse_options_set_short_length(10);
                parseOptions.parse_options_set_max_null_count(10);
                parseOptions.parse_options_set_linkage_limit(100);
            }
            if (dictionary == null) {
                dictionary = new Dictionary(parseOptions, lgParserDataDirectory + "/4.0.dict", "4.0.knowledge", "4.0.constituent-knowledge", "4.0.affix");
            }
            initializationStatus = 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            initializationStatus = 3;
        }
    }

    protected static synchronized void initialize(final ServletConfig config) {
        Thread runner = new Thread("Servlet Initializer"){

            public void run() {
                BaseAdornerServlet.doInitialization(config);
            }
        };
        runner.start();
    }

    public static synchronized TaggedStrings getLatinWordsList() {
        TextFile latinWordsFile = new TextFile(latinWordsFileName, "utf-8");
        SingleTagTaggedStrings latinWords = new SingleTagTaggedStrings(latinWordsFile.toArray(), "fw-la");
        latinWordsFile = null;
        return latinWords;
    }

    public static synchronized TaggedStrings getExtraWordsList() {
        UTF8Properties result = null;
        try {
            result = new UTF8Properties();
            result.load(new File(extraWordsFileName).toURI().toURL().openStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static AdornerInfo getAdornerInfo(String adornerName) {
        AdornerInfo result = adornerName != null && adornerName.equals("eme") ? emeAdornerInfo : ncfAdornerInfo;
        return result;
    }

    public static boolean isReady() {
        return initializationStatus == 2;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletResult results = !BaseAdornerServlet.isReady() ? this.outputNotReady(servletNotReadyMessage) : this.doHandleRequest(request, response);
        if (results.getFromForm()) {
            HttpSession session = request.getSession(true);
            session.setAttribute(results.getSessionAttributeName(), results.getResults());
            if (this.outputFullHTML) {
                this.outputResults(response, results.getResults(), results.getTitle());
            } else {
                response.sendRedirect(this.createRedirectURL(response, results.getRedirectionURL(), "", "", ""));
            }
        } else {
            this.outputResults(response, results.getResults(), results.getTitle());
        }
    }

    public void outputHeader(PrintWriter out, String title) {
        String docType = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"DTD/xhtml1-transitional.dtd\">";
        out.println(docType);
        out.println("<html>");
        out.println("<head>");
        out.println("<title>");
        if (title != null) {
            out.println(title);
        }
        out.println("</title>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
        out.println("<link type=\"text/css\" rel=\"stylesheet\" href=\"/morphadorner/styles/mstyle.css\" />");
        out.println("</head>");
        out.println("<body class=\"nomargin\">");
    }

    public ServletResult outputNotReady(String notReadyMessage) {
        StringPrintWriter out = new StringPrintWriter();
        out.println("<h2>" + notReadyMessage + "</h2>");
        ServletResult result = new ServletResult(false, out.getString(), servletNotReadyTitle, "", "");
        return result;
    }

    public void outputSpacerRow(PrintWriter out, int nColumns) {
        out.println("<tr>");
        for (int i = 0; i < nColumns; ++i) {
            out.println("<td>");
            out.println("&nbsp;");
            out.println("</td>");
        }
        out.println("</tr>");
    }

    public void outputFooter(PrintWriter out) {
        out.println("</body>");
        out.println("</html>");
    }

    public void outputSelect(PrintWriter out, String selectValue, boolean selected) {
        out.print("<option value=\"");
        out.print(selectValue);
        out.print("\"");
        if (selected) {
            out.print(" selected=\"selected\" ");
        }
        out.print("\">");
        out.print(selectValue);
        out.println("</option>");
    }

    public void outputAdornerSelection(PrintWriter out, String label, String adornerName) {
        out.println("<tr>");
        if (label != null && label.length() > 0) {
            out.println("<td valign=\"top\">");
            out.println("<strong>");
            out.print(label);
            out.println("</strong>");
            out.println("</td>");
        }
        out.println("<td>");
        String checkedEME = "";
        String checkedNCF = "checked=\"checked\"";
        if (adornerName != null && adornerName.equals("eme")) {
            checkedEME = "checked=\"checked\"";
            checkedNCF = "";
        }
        out.println("<input type=\"radio\" name=\"adornername\" value=\"eme\"" + checkedEME + ">Early Modern English</input><br />");
        out.println("<input type=\"radio\" name=\"adornername\" value=\"ncf\"" + checkedNCF + ">Nineteenth Century Fiction</input>");
        out.println("</td>");
        out.println("</tr>");
    }

    public void outputResults(HttpServletResponse response, String results, String title) throws IOException {
        PrintWriter out = response.getWriter();
        if (this.outputFullHTML) {
            this.outputHeader(out, title);
        }
        out.println(results);
        if (this.outputFullHTML) {
            this.outputFooter(out);
        }
        out.flush();
        out.close();
    }

    public String unTag(String text) {
        String result = text.trim();
        if (HTMLUtils.isHTMLTaggedText(result)) {
            result = HTMLUtils.stripHTMLTags(result);
        }
        result = result.replaceAll("\\s", " ");
        return result;
    }

    protected ServletResult doHandleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=utf-8");
        request.setCharacterEncoding("utf8");
        return this.handleRequest(request, response);
    }

    public static int getIntValue(String requestValue, int defaultValue) {
        int result = defaultValue;
        if (requestValue != null) {
            try {
                result = Integer.parseInt(requestValue);
            }
            catch (NumberFormatException e) {
                result = defaultValue;
            }
        }
        return result;
    }

    protected abstract ServletResult handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    static {
        ncfWordLexiconFileName = "/ncflexicon.lex";
        ncfSuffixLexiconFileName = "/ncfsuffixlexicon.lex";
        ncfSpellingPairsFileName = "/ncfmergedspellingpairs.tab";
        ncfTransitionMatrixFileName = "/ncftransmat.mat";
        emeWordLexiconFileName = "/emelexicon.lex";
        emeSuffixLexiconFileName = "/emesuffixlexicon.lex";
        emeTransitionMatrixFileName = "/emetransmat.mat";
        emeSpellingPairsFileName = "/ememergedspellingpairs.tab";
        standardSpellingsFileName = "/standardspellings.txt";
        porterStemmer = new PorterStemmer();
        lancasterStemmer = new LancasterStemmer();
        names = new Names();
        languageRecognizer = new DefaultLanguageRecognizer();
        inflector = new EnglishInflector();
        britishToUS = new BritishToUSSpellingMapper();
        extraWordsFileName = "/extrawords.txt";
        latinWordsFileName = "/latinwords.txt";
        lgParserDataDirectory = "/lgparser";
        initializationStatus = 0;
    }
}

