/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servlets;

import edu.northwestern.at.utils.KeyedSets;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.DefaultLexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.DefaultSuffixLexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.DefaultNameRecognizer;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.NameRecognizer;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.Names;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechRetagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.DefaultPartOfSpeechGuesser;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.PartOfSpeechGuesser;
import edu.northwestern.at.utils.corpuslinguistics.postagger.propernounretagger.ProperNounRetagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.transitionmatrix.TransitionMatrix;
import edu.northwestern.at.utils.corpuslinguistics.postagger.trigram.TrigramTagger;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.DefaultSentenceSplitter;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.SentenceSplitter;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.ExtendedSearchSpellingStandardizer;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.ExtendedSimpleSpellingStandardizer;
import java.io.File;

public class AdornerInfo {
    public SentenceSplitter extractor;
    public PartOfSpeechGuesser partOfSpeechGuesser;
    public Lexicon wordLexicon = new DefaultLexicon();
    public KeyedSets<String, String> lemmaToSpellings;
    public Lexicon suffixLexicon;
    public ExtendedSimpleSpellingStandardizer simpleStandardizer;
    public ExtendedSearchSpellingStandardizer standardizer;
    public PartOfSpeechTags partOfSpeechTags;
    public PartOfSpeechTagger tagger;
    public PartOfSpeechRetagger retagger;
    public TransitionMatrix transitionMatrix;
    public NameRecognizer nameRecognizer;

    public AdornerInfo(String wordLexiconFileName, String suffixLexiconFileName, String transitionMatrixFileName, String standardSpellingsFileName, String alternateSpellingsFileName, TaggedStrings[] extraWordLists, Names names) throws Exception {
        this.wordLexicon.loadLexicon(new File(wordLexiconFileName).toURI().toURL(), "utf-8");
        this.suffixLexicon = new DefaultSuffixLexicon();
        this.suffixLexicon.loadLexicon(new File(suffixLexiconFileName).toURI().toURL(), "utf-8");
        this.partOfSpeechTags = this.wordLexicon.getPartOfSpeechTags();
        this.partOfSpeechGuesser = new DefaultPartOfSpeechGuesser();
        this.partOfSpeechGuesser.setWordLexicon(this.wordLexicon);
        this.partOfSpeechGuesser.setSuffixLexicon(this.suffixLexicon);
        this.extractor = new DefaultSentenceSplitter();
        this.extractor.setPartOfSpeechGuesser(this.partOfSpeechGuesser);
        this.tagger = new TrigramTagger();
        this.retagger = new ProperNounRetagger();
        this.tagger.setRetagger(this.retagger);
        for (int i = 0; i < extraWordLists.length; ++i) {
            this.partOfSpeechGuesser.addAuxiliaryWordList(extraWordLists[i]);
        }
        this.tagger.setLexicon(this.wordLexicon);
        this.tagger.setPartOfSpeechGuesser(this.partOfSpeechGuesser);
        TransitionMatrix transitionMatrix = new TransitionMatrix();
        transitionMatrix.loadTransitionMatrix(new File(transitionMatrixFileName).toURI().toURL(), "utf-8", '\t');
        this.tagger.setTransitionMatrix(transitionMatrix);
        this.standardizer = new ExtendedSearchSpellingStandardizer();
        this.standardizer.loadStandardSpellings(new File(standardSpellingsFileName).toURI().toURL(), "utf-8");
        this.standardizer.addStandardSpellings(names.getFirstNames());
        this.standardizer.addStandardSpellings(names.getSurnames());
        this.standardizer.addStandardSpellings(names.getPlaceNames().keySet());
        this.standardizer.loadAlternativeSpellings(new File(alternateSpellingsFileName).toURI().toURL(), "utf-8", "\t");
        this.simpleStandardizer = new ExtendedSimpleSpellingStandardizer();
        this.simpleStandardizer.setMappedSpellings(this.standardizer.getMappedSpellings());
        this.simpleStandardizer.setStandardSpellings(this.standardizer.getStandardSpellings());
        this.nameRecognizer = new DefaultNameRecognizer();
        this.nameRecognizer.setPartOfSpeechTagger(this.tagger);
        String[] spellings = this.wordLexicon.getEntries();
        this.lemmaToSpellings = new KeyedSets();
        for (int i = 0; i < spellings.length; ++i) {
            String spelling = spellings[i];
            String[] lemmata = this.wordLexicon.getLemmata(spelling);
            for (int j = 0; j < lemmata.length; ++j) {
                this.lemmaToSpellings.add(lemmata[j], spelling);
            }
        }
    }
}

