/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servers.standardizerserver;

import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class StandardizerServerSettings {
    protected static ResourceBundle resourceBundle = null;
    protected static String programTitle;
    protected static String programVersion;
    protected static String programBanner;
    protected static String rmiServerURL;
    protected static String resourceName;

    public static void initializeSettings() {
        try {
            resourceBundle = ResourceBundle.getBundle(resourceName);
        }
        catch (MissingResourceException mre) {
            System.err.println(resourceName + ".properties not found");
            System.exit(0);
        }
        programTitle = StandardizerServerSettings.getString("programTitle", programTitle);
        programVersion = StandardizerServerSettings.getString("programVersion", programVersion);
        programBanner = StandardizerServerSettings.getString("programBanner", programBanner);
        ClassLoader loader = StandardizerServerSettings.class.getClassLoader();
        try {
            InputStream in = loader.getResourceAsStream("ss.properties");
            Properties properties = new Properties();
            properties.load(in);
            in.close();
            rmiServerURL = properties.getProperty("rmi-url");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getString(String resourceName, String defaultValue) {
        String result;
        try {
            result = resourceBundle.getString(resourceName);
        }
        catch (MissingResourceException e) {
            result = defaultValue;
        }
        result = result.replace('_', ' ');
        return result;
    }

    public static String getString(String resourceName) {
        String result;
        try {
            result = resourceBundle.getString(resourceName);
        }
        catch (MissingResourceException e) {
            result = "";
        }
        result = result.replace('_', ' ');
        return result;
    }

    public static String[] getStrings(String resourceName, String[] defaults) {
        String[] result;
        try {
            result = StandardizerServerSettings.tokenize(resourceBundle.getString(resourceName));
        }
        catch (MissingResourceException e) {
            result = defaults;
        }
        return result;
    }

    public static String getProgramTitle() {
        return programTitle;
    }

    public static String getProgramVersion() {
        return programVersion;
    }

    public static String getRmiServerURL() {
        return rmiServerURL;
    }

    public static String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] result = new String[v.size()];
        for (int i = 0; i < result.length; ++i) {
            String s2 = (String)v.elementAt(i);
            result[i] = s2.replace('_', ' ');
        }
        return result;
    }

    protected StandardizerServerSettings() {
    }

    static {
        resourceName = "edu.northwestern.at.standardizerserver.resources.ss";
    }
}

