/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servers.standardizerserver;

import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerConfig;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerLogger;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerSession;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerSettings;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.DefaultSpellingStandardizer;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.SimpleSpellingStandardizer;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.SpellingStandardizer;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class StandardizerServerSessionImpl
extends UnicastRemoteObject
implements StandardizerServerSession {
    protected static final long MAXIDLETIME = 0x6DDD00L;
    protected static Object lock = new Object();
    protected static long nextSessionId;
    protected static Map<Long, StandardizerServerSessionImpl> sessions;
    protected Long id;
    protected String host;
    protected Date loginDate = new Date();
    protected boolean active = true;
    protected long lastTickleTime = this.loginDate.getTime();
    protected static SpellingStandardizer simpleStandardizer;
    protected static SpellingStandardizer standardizer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StandardizerServerSessionImpl() throws RemoteException {
        super(StandardizerServerConfig.getRmiPort());
        Object object = lock;
        synchronized (object) {
            this.id = new Long(nextSessionId++);
            try {
                this.host = UnicastRemoteObject.getClientHost();
            }
            catch (ServerNotActiveException e) {
                StandardizerServerLogger.log(1, StandardizerServerSettings.getString("Getclienthost"), e);
            }
            sessions.put(this.id, this);
            StandardizerServerLogger.log(this, 3, StandardizerServerSettings.getString("Sessionbegin") + this.host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession() throws RemoteException {
        Object object = lock;
        synchronized (object) {
            this.active = false;
            sessions.remove(this.id);
            StandardizerServerLogger.log(this, 3, StandardizerServerSettings.getString("Sessionend") + this.host);
        }
    }

    public void tickle() throws RemoteException {
        this.lastTickleTime = System.currentTimeMillis();
    }

    public void logMessage(int level, String msg) throws RemoteException {
        StringTokenizer tok = new StringTokenizer(msg, "\n\r");
        StringBuffer buf = new StringBuffer();
        while (tok.hasMoreTokens()) {
            buf.append(tok.nextToken() + "\n");
        }
        int len = buf.length();
        if (len > 0) {
            buf.setLength(len - 1);
        }
        StandardizerServerLogger.log(this, level, buf.toString());
    }

    public String toString() {
        return this.id + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void timeOutIdleSessions() throws InterruptedException {
        while (true) {
            Thread.sleep(60000L);
            Object object = lock;
            synchronized (object) {
                List<StandardizerServerSessionImpl> sessionsCopy = ListFactory.createNewList(sessions.values());
                long curTime = System.currentTimeMillis();
                for (StandardizerServerSessionImpl session : sessionsCopy) {
                    long idleTime = curTime - session.lastTickleTime;
                    if (idleTime <= 0x6DDD00L) continue;
                    session.active = false;
                    sessions.remove(session.id);
                    StandardizerServerLogger.log(session, 3, StandardizerServerSettings.getString("Sessiontimedout"));
                }
            }
        }
    }

    static void initialize() throws Exception {
        StandardizerServerSessionImpl.initStandardizers();
        new Thread(new Runnable(){

            public void run() {
                try {
                    StandardizerServerSessionImpl.timeOutIdleSessions();
                }
                catch (InterruptedException e) {
                    StandardizerServerLogger.log(1, StandardizerServerSettings.getString("Idlesessiontimeoutthread"), e);
                }
            }
        }).start();
    }

    protected static void initStandardizers() throws Exception {
        simpleStandardizer = new SimpleSpellingStandardizer();
        standardizer = new DefaultSpellingStandardizer();
        standardizer.loadAlternativeSpellings(new File(StandardizerServerConfig.getMappedSpellingsFileName()).toURI().toURL(), "utf-8", "\t");
        StandardizerServerLogger.log(3, StandardizerServerSettings.getString("Mappedspellingsloaded"));
        simpleStandardizer.setMappedSpellings(standardizer.getMappedSpellings());
    }

    public String[] standardizeSpelling(String spelling) throws RemoteException {
        return standardizer.standardizeSpelling(spelling);
    }

    public String standardizeSpelling(String spelling, String pos) throws RemoteException {
        return standardizer.standardizeSpelling(spelling, pos);
    }

    public int getNumberOfAlternateSpellings() throws RemoteException {
        return standardizer.getNumberOfAlternateSpellings();
    }

    public int[] getNumberOfAlternateSpellingsByWordClass() throws RemoteException {
        return standardizer.getNumberOfAlternateSpellingsByWordClass();
    }

    public int getNumberOfStandardSpellings() throws RemoteException {
        return standardizer.getNumberOfStandardSpellings();
    }

    static {
        sessions = MapFactory.createNewMap();
    }
}

