/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servers.standardizerserver;

import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerConfig;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerSessionImpl;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class StandardizerServerLogger {
    public static final int FATAL = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    private static Logger logger = Logger.getLogger("edu.northwestern.at.standardizerserver");

    static void initialize(String message) throws FileNotFoundException, IOException {
        String logConfigFilePath = StandardizerServerConfig.getLogConfigFilePath();
        Properties properties = new Properties();
        properties.load(new FileInputStream(logConfigFilePath));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("log4j.appender") || !key.endsWith(".File")) continue;
            String val = properties.getProperty(key);
            val = StandardizerServerConfig.getPath() + File.separatorChar + val;
            properties.setProperty(key, val);
        }
        PropertyConfigurator.configure(properties);
        logger.info(message);
    }

    static void initialize() throws FileNotFoundException, IOException {
        StandardizerServerLogger.initialize(StandardizerServerSettings.getString("Serverstarted") + StandardizerServerSettings.getProgramVersion());
    }

    static void terminate() {
        logger.info(StandardizerServerSettings.getString("Serverstopped"));
    }

    static Priority mapLevel(int level) {
        switch (level) {
            case 0: {
                return Level.FATAL;
            }
            case 1: {
                return Level.ERROR;
            }
            case 2: {
                return Level.WARN;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.DEBUG;
            }
        }
        return Level.ERROR;
    }

    static void log(int level, String str) {
        logger.log(StandardizerServerLogger.mapLevel(level), str);
    }

    static void log(StandardizerServerSessionImpl session, int level, String str) {
        str = StandardizerServerSettings.getString("Session") + "=" + session + ", " + str;
        logger.log(StandardizerServerLogger.mapLevel(level), str);
    }

    static void log(int level, String str, Throwable t) {
        logger.log(StandardizerServerLogger.mapLevel(level), str, t);
    }

    static void log(StandardizerServerSessionImpl session, int level, String str, Throwable t) {
        str = StandardizerServerSettings.getString("Session") + "=" + session + ", " + str;
        logger.log(StandardizerServerLogger.mapLevel(level), str, t);
    }

    private StandardizerServerLogger() {
        throw new UnsupportedOperationException();
    }
}

