/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.servers.standardizerserver;

import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerBootstrap;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerBootstrapImpl;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerConfig;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerLogger;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerSessionImpl;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerSettings;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class StandardizerServer {
    private static void startup(String path) {
        try {
            StandardizerServerSettings.initializeSettings();
            StandardizerServerConfig.read(path);
            StandardizerServerLogger.initialize();
            StandardizerServerSessionImpl.initialize();
            StandardizerServerBootstrapImpl bootstrap = new StandardizerServerBootstrapImpl();
            Registry registry = LocateRegistry.createRegistry(StandardizerServerConfig.getRmiRegistryPort());
            registry.rebind("SpellingStandardizer", bootstrap);
            System.out.println(StandardizerServerSettings.getString("Standardizerserverstarted"));
        }
        catch (Exception e) {
            System.out.println(StandardizerServerSettings.getString("Standardizerserverstartupfailure"));
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void shutdown(String path) {
        try {
            StandardizerServerSettings.initializeSettings();
            StandardizerServerConfig.read(path);
            StandardizerServerLogger.initialize(StandardizerServerSettings.getString("Servershuttingdown"));
            String uri = "//localhost:" + StandardizerServerConfig.getRmiRegistryPort() + "/SpellingStandardizer";
            StandardizerServerBootstrap bootstrap = (StandardizerServerBootstrap)Naming.lookup(uri);
            bootstrap.shutdown(uri);
            System.out.println(StandardizerServerSettings.getString("Standardizerserverstopped"));
        }
        catch (NotBoundException e) {
            e.printStackTrace();
            System.out.println(StandardizerServerSettings.getString("Thestandardizerserverwasnotrunning"));
        }
        catch (Exception e) {
            StandardizerServerLogger.log(1, StandardizerServerSettings.getString("Shutdown"), e);
            StandardizerServerLogger.terminate();
        }
    }

    public static void main(String[] args) {
        if (args.length == 2 && args[0].equalsIgnoreCase("start")) {
            StandardizerServer.startup(args[1]);
        } else if (args.length == 2 && args[0].equalsIgnoreCase("stop")) {
            StandardizerServer.shutdown(args[1]);
        } else {
            System.out.println(StandardizerServerSettings.getString("ServerUsage"));
            System.exit(1);
        }
    }

    protected StandardizerServer() {
    }
}

