/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.examples;

import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.postagger.DefaultPartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.DefaultSentenceSplitter;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.DefaultWordTokenizer;
import java.util.List;

public class PosTagString {
    public static void main(String[] args) {
        try {
            PosTagString.adornText(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void adornText(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("No text to adorn.");
            System.exit(1);
        }
        String textToAdorn = args[0];
        DefaultPartOfSpeechTagger partOfSpeechTagger = new DefaultPartOfSpeechTagger();
        DefaultWordTokenizer wordTokenizer = new DefaultWordTokenizer();
        DefaultSentenceSplitter sentenceSplitter = new DefaultSentenceSplitter();
        sentenceSplitter.setPartOfSpeechGuesser(partOfSpeechTagger.getPartOfSpeechGuesser());
        List<List<String>> sentences = sentenceSplitter.extractSentences(textToAdorn, wordTokenizer);
        List<List<AdornedWord>> taggedSentences = partOfSpeechTagger.tagSentences(sentences);
        for (int i = 0; i < sentences.size(); ++i) {
            List<AdornedWord> sentence = taggedSentences.get(i);
            System.out.println("---------- Sentence " + (i + 1) + "----------");
            for (int j = 0; j < sentence.size(); ++j) {
                AdornedWord adornedWord = sentence.get(j);
                System.out.println(StringUtils.rpad(j + 1 + "", 3) + ": " + StringUtils.rpad(adornedWord.getSpelling(), 20) + adornedWord.getPartsOfSpeech());
            }
        }
    }
}

