/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.utils.QueueStack;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.xml.ExtendedXMLFilterImpl;
import java.util.Arrays;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class StripWordElementsFilter
extends ExtendedXMLFilterImpl {
    protected Set<String> elementsToStripSet;
    protected QueueStack<String> stripElementStack = new QueueStack();
    protected boolean processingWorC;

    public StripWordElementsFilter(XMLReader reader, String elementsToStrip) {
        super(reader);
        this.elementsToStripSet = SetFactory.createNewSet();
        this.elementsToStripSet.addAll(Arrays.asList(StringUtils.makeTokenArray(elementsToStrip)));
        this.processingWorC = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.elementsToStripSet.contains(localName)) {
            this.stripElementStack.push(localName);
        }
        this.processingWorC = false;
        if (this.stripElementStack.size() > 0) {
            if (qName.equals("w")) {
                this.processingWorC = true;
            } else if (qName.equals("c")) {
                this.processingWorC = true;
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        } else {
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stripElementStack.size() > 0) {
            if (this.processingWorC) {
                super.characters(ch, start, length);
            }
        } else {
            super.characters(ch, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.elementsToStripSet.contains(localName)) {
            this.stripElementStack.pop();
        }
        this.processingWorC = false;
        if (this.stripElementStack.size() > 0) {
            if (!qName.equals("w") && !qName.equals("c")) {
                super.endElement(uri, localName, qName);
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }
}

