/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.utils.Compare;

public class SentenceAndWordNumber
implements Comparable {
    protected String id;
    protected int ord;
    protected String part;
    protected boolean eos;
    protected int wordNumber;
    protected int sentenceNumber;

    public SentenceAndWordNumber(String id, int ord, String part, boolean eos) {
        this.id = id;
        this.ord = ord;
        this.part = part;
        this.eos = eos;
        this.sentenceNumber = -1;
        this.wordNumber = -1;
    }

    public void setSentenceAndWordNumber(int sentenceNumber, int wordNumber) {
        this.sentenceNumber = sentenceNumber;
        this.wordNumber = wordNumber;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int getOrd() {
        return this.ord;
    }

    public boolean isFirstPart() {
        return this.part.equals("N") || this.part.equals("I");
    }

    public boolean isMiddlePart() {
        return this.part.equals("N") || this.part.equals("M");
    }

    public boolean isLastPart() {
        return this.part.equals("N") || this.part.equals("F");
    }

    public int getSentenceNumber() {
        return this.sentenceNumber;
    }

    public int getWordNumber() {
        return this.wordNumber;
    }

    public boolean getEOS() {
        return this.eos;
    }

    public int compareTo(Object object) {
        int result = 0;
        result = object == null || !(object instanceof SentenceAndWordNumber) ? Integer.MIN_VALUE : Compare.compare(this.id, ((SentenceAndWordNumber)object).getID());
        return result;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "id=" + this.id + ", ord=" + this.ord + ", sn=" + this.sentenceNumber + ", wn=" + this.wordNumber + ", eos=" + this.eos;
    }
}

