/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.DefaultMorphAdornerXMLWriter;
import edu.northwestern.at.morphadorner.MorphAdornerXMLWriter;
import edu.northwestern.at.utils.ClassUtils;

public class MorphAdornerXMLWriterFactory {
    public MorphAdornerXMLWriter newMorphAdornerXMLWriter() {
        String className = System.getProperty("morphadornerxmlwriter.class");
        if (className == null) {
            className = "DefaultMorphAdornerXMLWriter";
        }
        return this.newMorphAdornerXMLWriter(className);
    }

    public MorphAdornerXMLWriter newMorphAdornerXMLWriter(String className) {
        MorphAdornerXMLWriter xmlWriter = null;
        try {
            xmlWriter = (MorphAdornerXMLWriter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                xmlWriter = (MorphAdornerXMLWriter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create XML writer of class " + fixedClassName + ", using default.");
                xmlWriter = new DefaultMorphAdornerXMLWriter();
            }
        }
        return xmlWriter;
    }
}

