/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.MorphAdornerLogger;
import edu.northwestern.at.morphadorner.WordAttributeNames;
import edu.northwestern.at.morphadorner.xgtagger.XGMisc;
import edu.northwestern.at.morphadorner.xgtagger.XGOptions;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.PatternReplacer;
import edu.northwestern.at.utils.URLUtils;
import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.UTF8PropertyUtils;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphAdornerSettings {
    protected static ResourceBundle resourceBundle = null;
    protected static String resourceName = "edu.northwestern.at.morphadorner.resources.ma";
    public static String programTitle;
    public static String programVersion;
    public static String programBanner;
    public static UTF8Properties properties;
    public static XGOptions xgOptions;
    public static boolean debug;
    protected static boolean initialized;
    public static String outputDirectoryName;
    protected static String wordLexiconURLString;
    public static URL wordLexiconURL;
    protected static String suffixLexiconURLString;
    public static URL suffixLexiconURL;
    protected static String contextRulesURLString;
    public static URL contextRulesURL;
    protected static String lexicalRulesURLString;
    public static URL lexicalRulesURL;
    protected static String spellingsURLString;
    public static URL spellingsURL;
    protected static String[] alternateSpellingsURLStrings;
    public static URL[] alternateSpellingsURLs;
    protected static String[] alternateSpellingsByWordClassURLStrings;
    public static URL[] alternateSpellingsByWordClassURLs;
    protected static String transitionMatrixURLString;
    public static URL transitionMatrixURL;
    protected static String defaultPropertiesURLString;
    protected static String propertiesURLString;
    public static URL propertiesURL;
    public static String[] fileNames;
    public static boolean outputSentenceNumber;
    public static String outputSentenceNumberAttribute;
    public static String outputWordOrdinalAttribute;
    public static boolean outputWordOrdinal;
    public static boolean outputWordNumber;
    public static String outputWordNumberAttribute;
    public static boolean outputRunningWordNumbers;
    public static boolean outputSpelling;
    public static String outputSpellingAttribute;
    public static boolean outputOriginalToken;
    public static String outputOriginalTokenAttribute;
    public static boolean outputPartOfSpeech;
    public static String outputPartOfSpeechAttribute;
    public static boolean outputLemma;
    public static String outputLemmaAttribute;
    public static boolean outputStandardSpelling;
    public static String outputStandardSpellingAttribute;
    public static boolean outputKWIC;
    public static String outputLeftKWICAttribute;
    public static String outputRightKWICAttribute;
    public static int outputKWICWidth;
    public static boolean outputEOSFlag;
    public static String outputEOSFlagAttribute;
    public static String xmlDoctypeName;
    public static String xmlDoctypeSystem;
    public static boolean useXMLHandler;
    public static boolean ignoreLexiconEntriesForLemmatization;
    public static boolean tryStandardSpellings;
    public static boolean useLatinWordList;
    public static boolean outputWhitespaceElements;
    public static boolean outputNonredundantAttributesOnly;
    public static boolean outputNonredundantTokenAttribute;
    public static boolean outputSentenceBoundaryMilestones;
    public static boolean allowLowerCaseProperNouns;
    public static boolean fixGapTags;
    public static boolean fixOrigTags;
    public static boolean fixSplitWords;
    public static List<PatternReplacer> fixSplitWordsPatternReplacers;
    public static int pseudoPageSize;
    public static boolean outputPseudoPageBoundaryMilestones;
    public static String pseudoPageContainerDivTypes;
    public static boolean closeSentenceAtEndOfHardTag;
    public static boolean closeSentenceAtEndOfJumpTag;
    public static String xmlSchema;
    public static String disallowWordElementsIn;
    public static XMLIDType xmlIDType;
    public static int xmlIDSpacing;
    public static List<String> xmlWordAttributes;
    public static String abbreviationsURL;
    public static boolean adornExistingXMLFiles;
    protected static final String STR_ID = "xml.id.attribute";
    protected static final String STR_ID_TYPE = "xml.id.type";
    protected static final String STR_ID_SPACING = "xml.id.spacing";
    protected static final String STR_LOG = "xml.log";
    protected static final String STR_WORD_PATH = "xml.word_path";
    protected static final String STR_TAGS_PATH = "xml.tags_path";
    protected static final String STR_FIELD_DELIMITERS = "xml.field_delimiters";
    protected static final String STR_WORD_DELIMITERS = "xml.word_delimiters";
    protected static final String STR_SURROUND_MARKER = "xml.surround_marker";
    protected static final String STR_WORD_FIELD = "xml.word_field";
    protected static final String STR_OUTPUT_FILE = "xml.output_file";
    protected static final String STR_ENTITIES_NOT_FILES = "xml.entities_not_files";
    protected static final String STR_ENTITIES_TREAT_ALL = "xml.entities_treat_all";
    protected static final String STR_ENTITIES_MERGE = "xml.entities_merge";
    protected static final String STR_RELATIVE_URI_BASE = "xml.relative_uri_base";
    protected static final String STR_REPEAT_ATTRIBUTES = "xml.repeat_attributes";
    protected static final String STR_JUMP_TAGS = "xml.jump_tags";
    protected static final String STR_SOFT_TAGS = "xml.soft_tags";
    protected static final String STR_WORD_TAG_NAME = "xml.word_tag_name";
    protected static final String STR_SPECIAL_SEPARATOR = "xml.special_separator";
    protected static final String STR_IGNORE_TAG_CASE = "xml.ignore_tag_case";
    protected static final String STR_DOCTYPE_NAME = "xml.doctype.name";
    protected static final String STR_DOCTYPE_SYSTEM = "xml.doctype.system";
    protected static final String STR_OUTPUT_WHITESPACE_ELEMENTS = "xml.output_whitespace_elements";
    protected static final String STR_OUTPUT_NONREDUNDANT_ATTRIBUTES_ONLY = "xml.output_nonredundant_attributes_only";
    protected static final String STR_OUTPUT_NONREDUNDANT_TOKEN_ATTRIBUTE = "xml.output_nonredundant_token_attribute";
    protected static final String STR_OUTPUT_SENTENCE_BOUNDARY_MILESTONES = "xml.output_sentence_boundary_milestones";
    protected static final String STR_FIX_GAP_TAGS = "xml.fix_gap_tags";
    protected static final String STR_FIX_ORIG_TAGS = "xml.fix_orig_tags";
    protected static final String STR_FIX_SPLIT_WORDS = "xml.fix_split_words";
    protected static final String STR_PSEUDO_PAGE_SIZE = "xml.pseudo_page_size";
    protected static final String STR_OUTPUT_PSEUDO_PAGE_BOUNDARY_MILESTONES = "xml.output_pseudo_page_boundary_milestones";
    protected static final String STR_PSEUDO_PAGE_CONTAINER_DIV_TYPES = "xml.pseudo_page_container_div_types";
    protected static final String STR_CLOSE_SENTENCE_AT_END_OF_HARD_TAG = "xml.close_sentence_at_end_of_hard_tag";
    protected static final String STR_CLOSE_SENTENCE_AT_END_OF_JUMP_TAG = "xml.close_sentence_at_end_of_jump_tag";
    protected static final String STR_XMLSCHEMA = "xml.xml_schema";
    protected static final String STR_WORD_LEXICON = "lexicon.word_lexicon";
    protected static final String STR_SUFFIX_LEXICON = "lexicon.suffix_lexicon";
    protected static final String STR_CONTEXT_RULES = "partofspeechtagger.context_rules";
    protected static final String STR_LEXICAL_RULES = "partofspeechtagger.lexical_rules";
    protected static final String STR_STANDARD_SPELLINGS = "spelling.standard_spellings";
    protected static final String STR_SPELLING_PAIRS = "spelling.spelling_pairs";
    protected static final String STR_SPELLING_PAIRS_BY_WORD_CLASS = "spelling.spelling_pairs_by_word_class";
    protected static final String STR_TRANSITION_MATRIX = "partofspeechtagger.transition_matrix";
    protected static final String STR_DISALLOW_WORD_ELEMENTS_IN = "xml.disallow_word_elements_in";
    protected static final String STR_ADORN_EXISTING_XML_FILES = "xml.adorn_existing_xml_files";

    public static void initializeSettings(String[] args) {
        try {
            resourceBundle = ResourceBundle.getBundle(resourceName);
        }
        catch (MissingResourceException mre) {
            System.err.println(resourceName + ".properties not found");
            System.exit(0);
        }
        programTitle = MorphAdornerSettings.getString("programTitle");
        programVersion = MorphAdornerSettings.getString("programVersion");
        programBanner = MorphAdornerSettings.getString("programBanner");
    }

    public static String getString(String resourceName, String defaultValue) {
        String result;
        try {
            result = resourceBundle.getString(resourceName);
        }
        catch (MissingResourceException e) {
            result = defaultValue;
        }
        result = result.replace('_', ' ');
        return result;
    }

    public static String getString(String resourceName) {
        String result;
        try {
            result = resourceBundle.getString(resourceName);
        }
        catch (MissingResourceException e) {
            result = "";
        }
        result = result.replace('_', ' ');
        return result;
    }

    public static String[] getStrings(String resourceName, String[] defaults) {
        String[] result;
        try {
            result = MorphAdornerSettings.splitStrings(resourceBundle.getString(resourceName));
        }
        catch (MissingResourceException e) {
            result = defaults;
        }
        return result;
    }

    public static String[] splitStrings(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] result = new String[v.size()];
        for (int i = 0; i < result.length; ++i) {
            String s2 = (String)v.elementAt(i);
            result[i] = s2.replace('_', ' ');
        }
        return result;
    }

    protected static void getCommandLineParameters(String[] args) {
        if (args.length == 0) {
            MorphAdornerSettings.help();
        }
        try {
            int i;
            CmdLineParser parser2 = new CmdLineParser();
            CmdLineParser.Option a = parser2.addStringOption('a', "alternatespellings");
            CmdLineParser.Option h2 = parser2.addBooleanOption('h', "help");
            CmdLineParser.Option l = parser2.addStringOption('l', "lexicon");
            CmdLineParser.Option o = parser2.addStringOption('o', "outputdirectory");
            CmdLineParser.Option p = parser2.addStringOption('p', "properties");
            CmdLineParser.Option r = parser2.addStringOption('r', "contextrules");
            CmdLineParser.Option s2 = parser2.addStringOption('s', "standardspellings");
            CmdLineParser.Option t = parser2.addStringOption('t', "transitionmatrix");
            CmdLineParser.Option u = parser2.addStringOption('u', "suffixlexicon");
            CmdLineParser.Option w = parser2.addStringOption('w', "alternatespellingsbywordclass");
            CmdLineParser.Option x = parser2.addStringOption('x', "lexicalrules");
            try {
                parser2.parse(args);
            }
            catch (CmdLineParser.OptionException e) {
                System.err.println(e.getMessage());
                MorphAdornerSettings.help();
                System.exit(1);
            }
            if ((Boolean)parser2.getOptionValue(h2) != null) {
                MorphAdornerSettings.help();
                System.exit(0);
            }
            Vector strings = parser2.getOptionValues(a);
            alternateSpellingsURLStrings = new String[strings.size()];
            for (i = 0; i < strings.size(); ++i) {
                MorphAdornerSettings.alternateSpellingsURLStrings[i] = (String)strings.get(i);
            }
            strings = parser2.getOptionValues(w);
            alternateSpellingsByWordClassURLStrings = new String[strings.size()];
            for (i = 0; i < strings.size(); ++i) {
                MorphAdornerSettings.alternateSpellingsByWordClassURLStrings[i] = (String)strings.get(i);
            }
            wordLexiconURLString = (String)parser2.getOptionValue(l);
            outputDirectoryName = (String)parser2.getOptionValue(o);
            propertiesURLString = (String)parser2.getOptionValue(p);
            contextRulesURLString = (String)parser2.getOptionValue(r);
            spellingsURLString = (String)parser2.getOptionValue(s2);
            transitionMatrixURLString = (String)parser2.getOptionValue(t);
            suffixLexiconURLString = (String)parser2.getOptionValue(u);
            lexicalRulesURLString = (String)parser2.getOptionValue(x);
            fileNames = parser2.getRemainingArgs();
            fileNames = FileNameUtils.expandFileNameWildcards(fileNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getSettings(String[] args) throws Exception {
        MorphAdornerSettings.getCommandLineParameters(args);
        MorphAdornerSettings.loadProperties();
        MorphAdornerSettings.getOptions();
        MorphAdornerSettings.rectifyOptions();
        MorphAdornerSettings.setXGOptions();
    }

    public static void loadProperties() {
        UTF8Properties defaultProperties = null;
        try {
            propertiesURL = URLUtils.getURLFromFileNameOrURL(defaultPropertiesURLString);
            defaultProperties = UTF8PropertyUtils.loadUTF8Properties(propertiesURL);
        }
        catch (Exception e) {
            System.out.println("Unable to load default properties from " + defaultPropertiesURLString);
        }
        try {
            propertiesURL = URLUtils.getURLFromFileNameOrURL(propertiesURLString);
            properties = UTF8PropertyUtils.loadUTF8Properties(propertiesURL, defaultProperties);
        }
        catch (Exception e) {
            System.out.println("Unable to load configuration properties from " + defaultPropertiesURLString);
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            String propertyValue = properties.getProperty(propertyName);
            System.setProperty(propertyName, propertyValue);
        }
    }

    protected static void help() {
        System.out.println("java edu.northwestern.at.morphadorner.MorphAdorner [parameters ...] filetotag1 filetotag2 filetotag3 ...");
        System.exit(1);
    }

    public static void getOptions() throws Exception {
        outputSentenceNumber = MorphAdornerSettings.getBooleanProperty("adorner.output.sentence_number", outputSentenceNumber);
        outputSentenceNumberAttribute = MorphAdornerSettings.getStringProperty("adorner.output.sentence_number_attribute", outputSentenceNumberAttribute);
        outputWordOrdinalAttribute = MorphAdornerSettings.getStringProperty("adorner.output.word_ordinal_attribute", outputWordOrdinalAttribute);
        outputWordOrdinal = MorphAdornerSettings.getBooleanProperty("adorner.output.word_ordinal", outputWordOrdinal);
        outputWordNumber = MorphAdornerSettings.getBooleanProperty("adorner.output.word_number", outputWordNumber);
        outputWordNumberAttribute = MorphAdornerSettings.getStringProperty("adorner.output.word_number_attribute", outputWordNumberAttribute);
        outputRunningWordNumbers = MorphAdornerSettings.getBooleanProperty("adorner.output.running_word_numbers", outputRunningWordNumbers);
        outputSpelling = MorphAdornerSettings.getBooleanProperty("adorner.output.spelling", outputSpelling);
        outputSpellingAttribute = MorphAdornerSettings.getStringProperty("adorner.output.spelling_attribute", outputSpellingAttribute);
        outputOriginalToken = MorphAdornerSettings.getBooleanProperty("adorner.output.original_token", outputOriginalToken);
        outputOriginalTokenAttribute = MorphAdornerSettings.getStringProperty("adorner.output.original_token_attribute", outputOriginalTokenAttribute);
        outputPartOfSpeech = MorphAdornerSettings.getBooleanProperty("adorner.output.part_of_speech", outputPartOfSpeech);
        outputPartOfSpeechAttribute = MorphAdornerSettings.getStringProperty("adorner.output.part_of_speech_attribute", outputPartOfSpeechAttribute);
        outputLemma = MorphAdornerSettings.getBooleanProperty("adorner.output.lemma", outputLemma);
        outputLemmaAttribute = MorphAdornerSettings.getStringProperty("adorner.output.lemma_attribute", outputLemmaAttribute);
        outputStandardSpelling = MorphAdornerSettings.getBooleanProperty("adorner.output.standard_spelling", outputStandardSpelling);
        outputStandardSpellingAttribute = MorphAdornerSettings.getStringProperty("adorner.output.standard_spelling_attribute", outputStandardSpellingAttribute);
        outputKWIC = MorphAdornerSettings.getBooleanProperty("adorner.output.kwic", outputKWIC);
        outputKWIC = MorphAdornerSettings.getBooleanProperty("adorner.output.kwic", outputKWIC);
        outputLeftKWICAttribute = MorphAdornerSettings.getStringProperty("adorner.output.kwic_left_attribute", outputLeftKWICAttribute);
        outputRightKWICAttribute = MorphAdornerSettings.getStringProperty("adorner.output.kwic_right_attribute", outputRightKWICAttribute);
        outputKWICWidth = MorphAdornerSettings.getIntegerProperty("adorner.output.kwic.width", outputKWICWidth);
        outputEOSFlag = MorphAdornerSettings.getBooleanProperty("adorner.output.end_of_sentence_flag", outputEOSFlag);
        outputEOSFlagAttribute = MorphAdornerSettings.getStringProperty("adorner.output.end_of_sentence_flag_attribute", outputEOSFlagAttribute);
        useXMLHandler = MorphAdornerSettings.getBooleanProperty("adorner.handle_xml", useXMLHandler);
        ignoreLexiconEntriesForLemmatization = MorphAdornerSettings.getBooleanProperty("adorner.lemmatization.ignorelexiconentries", ignoreLexiconEntriesForLemmatization);
        tryStandardSpellings = MorphAdornerSettings.getBooleanProperty("partofspeechguesser.try_standard_spellings", tryStandardSpellings);
        useLatinWordList = MorphAdornerSettings.getBooleanProperty("wordlists.use_latin_word_list", useLatinWordList);
        abbreviationsURL = MorphAdornerSettings.getStringProperty("abbreviations.abbreviations_url", "");
        allowLowerCaseProperNouns = MorphAdornerSettings.getBooleanProperty("adorner.postagger.allow_lower_case_proper_nouns", allowLowerCaseProperNouns);
        xmlDoctypeName = MorphAdornerSettings.getStringProperty(STR_DOCTYPE_NAME, "");
        xmlDoctypeSystem = MorphAdornerSettings.getStringProperty(STR_DOCTYPE_SYSTEM, "");
        outputNonredundantAttributesOnly = MorphAdornerSettings.getBooleanProperty(STR_OUTPUT_NONREDUNDANT_ATTRIBUTES_ONLY, outputNonredundantAttributesOnly);
        outputNonredundantTokenAttribute = MorphAdornerSettings.getBooleanProperty(STR_OUTPUT_NONREDUNDANT_TOKEN_ATTRIBUTE, outputNonredundantTokenAttribute);
        outputSentenceBoundaryMilestones = MorphAdornerSettings.getBooleanProperty(STR_OUTPUT_SENTENCE_BOUNDARY_MILESTONES, outputSentenceBoundaryMilestones);
        adornExistingXMLFiles = MorphAdornerSettings.getBooleanProperty(STR_ADORN_EXISTING_XML_FILES, adornExistingXMLFiles);
        fixGapTags = MorphAdornerSettings.getBooleanProperty(STR_FIX_GAP_TAGS, fixGapTags);
        fixOrigTags = MorphAdornerSettings.getBooleanProperty(STR_FIX_ORIG_TAGS, fixOrigTags);
        if (fixSplitWords = MorphAdornerSettings.getBooleanProperty(STR_FIX_SPLIT_WORDS, fixSplitWords)) {
            int i = 1;
            while (true) {
                String matchString = MorphAdornerSettings.getStringProperty("xml.fix_split_words.match" + i, "");
                String replaceString = MorphAdornerSettings.getStringProperty("xml.fix_split_words.replace" + i, "");
                if (matchString.length() <= 0) break;
                PatternReplacer patternReplacer = new PatternReplacer(matchString, replaceString);
                if (fixSplitWordsPatternReplacers == null) {
                    fixSplitWordsPatternReplacers = ListFactory.createNewList();
                }
                fixSplitWordsPatternReplacers.add(patternReplacer);
                ++i;
            }
        }
        pseudoPageSize = MorphAdornerSettings.getIntegerProperty(STR_PSEUDO_PAGE_SIZE, pseudoPageSize);
        outputPseudoPageBoundaryMilestones = MorphAdornerSettings.getBooleanProperty(STR_OUTPUT_PSEUDO_PAGE_BOUNDARY_MILESTONES, outputPseudoPageBoundaryMilestones);
        pseudoPageContainerDivTypes = MorphAdornerSettings.getStringProperty(STR_PSEUDO_PAGE_CONTAINER_DIV_TYPES, pseudoPageContainerDivTypes);
        closeSentenceAtEndOfHardTag = MorphAdornerSettings.getBooleanProperty(STR_CLOSE_SENTENCE_AT_END_OF_HARD_TAG, closeSentenceAtEndOfHardTag);
        closeSentenceAtEndOfJumpTag = MorphAdornerSettings.getBooleanProperty(STR_CLOSE_SENTENCE_AT_END_OF_JUMP_TAG, closeSentenceAtEndOfJumpTag);
        xmlSchema = MorphAdornerSettings.getStringProperty(STR_XMLSCHEMA, xmlSchema);
        disallowWordElementsIn = MorphAdornerSettings.getStringProperty(STR_DISALLOW_WORD_ELEMENTS_IN, disallowWordElementsIn);
        String idType = MorphAdornerSettings.getStringProperty(STR_ID_TYPE, "reading_context_order");
        if (idType.equals("reading_context_order")) {
            xmlIDType = XMLIDType.READING_CONTEXT_ORDER;
        } else if (idType.equals("word_within_page_block")) {
            xmlIDType = XMLIDType.WORD_WITHIN_PAGE_BLOCK;
        }
        xmlIDSpacing = MorphAdornerSettings.getIntegerProperty(STR_ID_SPACING, xmlIDSpacing);
        xmlIDSpacing = Math.max(1, xmlIDSpacing);
        if (wordLexiconURLString == null) {
            wordLexiconURLString = MorphAdornerSettings.getStringProperty(STR_WORD_LEXICON, "");
        }
        if (suffixLexiconURLString == null) {
            suffixLexiconURLString = MorphAdornerSettings.getStringProperty(STR_SUFFIX_LEXICON, "");
        }
        if (contextRulesURLString == null) {
            contextRulesURLString = MorphAdornerSettings.getStringProperty(STR_CONTEXT_RULES, "");
        }
        if (lexicalRulesURLString == null) {
            lexicalRulesURLString = MorphAdornerSettings.getStringProperty(STR_LEXICAL_RULES, "");
        }
        if (spellingsURLString == null) {
            spellingsURLString = MorphAdornerSettings.getStringProperty(STR_STANDARD_SPELLINGS, "");
        }
        if (transitionMatrixURLString == null) {
            transitionMatrixURLString = MorphAdornerSettings.getStringProperty(STR_TRANSITION_MATRIX, "");
        }
    }

    public static void rectifyOptions() throws Exception {
        int i;
        wordLexiconURL = wordLexiconURLString == null ? null : new File(wordLexiconURLString).toURI().toURL();
        suffixLexiconURL = suffixLexiconURLString == null ? null : new File(suffixLexiconURLString).toURI().toURL();
        contextRulesURL = contextRulesURLString == null ? null : new File(contextRulesURLString).toURI().toURL();
        lexicalRulesURL = lexicalRulesURLString == null ? null : new File(lexicalRulesURLString).toURI().toURL();
        spellingsURL = spellingsURLString == null ? null : new File(spellingsURLString).toURI().toURL();
        alternateSpellingsURLs = null;
        if (alternateSpellingsURLStrings != null) {
            alternateSpellingsURLs = new URL[alternateSpellingsURLStrings.length];
            for (i = 0; i < alternateSpellingsURLStrings.length; ++i) {
                MorphAdornerSettings.alternateSpellingsURLs[i] = new File(alternateSpellingsURLStrings[i]).toURI().toURL();
            }
        }
        alternateSpellingsByWordClassURLs = null;
        if (alternateSpellingsByWordClassURLStrings != null) {
            alternateSpellingsByWordClassURLs = new URL[alternateSpellingsByWordClassURLStrings.length];
            for (i = 0; i < alternateSpellingsByWordClassURLStrings.length; ++i) {
                MorphAdornerSettings.alternateSpellingsByWordClassURLs[i] = new File(alternateSpellingsByWordClassURLStrings[i]).toURI().toURL();
            }
        }
        transitionMatrixURL = transitionMatrixURLString == null ? null : new File(transitionMatrixURLString).toURI().toURL();
    }

    public static int setXGOptions() throws IOException {
        xgOptions.setWordTagName(MorphAdornerSettings.getStringProperty(STR_WORD_TAG_NAME, ""));
        if (xgOptions.getWordTagName().length() == 0) {
            MorphAdornerLogger.logError("You must specify a name for tags that will be added with xml.word_tag_name in configuration file.");
            return -1;
        }
        int word_field = MorphAdornerSettings.getIntegerProperty(STR_WORD_FIELD, 1);
        if (word_field <= 0) {
            MorphAdornerLogger.logError("Please specify a valid (integer) word field with property xml.word_field in the configuration file.");
            return -1;
        }
        xgOptions.setWordField(word_field);
        xgOptions.repeatAttributes(MorphAdornerSettings.getBooleanProperty(STR_REPEAT_ATTRIBUTES, false));
        String str = MorphAdornerSettings.getStringProperty(STR_RELATIVE_URI_BASE, "");
        if (str.length() != 0) {
            File file = XGMisc.getFile(str);
            if (!file.isDirectory()) {
                MorphAdornerLogger.logError("Base for relative URIs " + str + " must be an existing directory.");
                return -1;
            }
            xgOptions.setRelativeURIBase(file.getPath());
        }
        xgOptions.setIgnoreTagCase(MorphAdornerSettings.getBooleanProperty(STR_IGNORE_TAG_CASE, true));
        xgOptions.setJumpTags(MorphAdornerSettings.getStringProperty(STR_JUMP_TAGS, ""));
        xgOptions.setSoftTags(MorphAdornerSettings.getStringProperty(STR_SOFT_TAGS, ""));
        outputWhitespaceElements = MorphAdornerSettings.getBooleanProperty(STR_OUTPUT_WHITESPACE_ELEMENTS, true);
        MorphAdornerSettings.setDelimiters();
        MorphAdornerSettings.setIDs();
        MorphAdornerSettings.setPaths();
        MorphAdornerSettings.setLogFileNames();
        return MorphAdornerSettings.entityReferenceHandling();
    }

    protected static int entityReferenceHandling() {
        xgOptions.setEntityMerging(MorphAdornerSettings.getBooleanProperty(STR_ENTITIES_MERGE, false));
        xgOptions.setEntityTreatAll(MorphAdornerSettings.getBooleanProperty(STR_ENTITIES_TREAT_ALL, false));
        xgOptions.setEntityIgnoreFiles(MorphAdornerSettings.getBooleanProperty(STR_ENTITIES_NOT_FILES, false));
        return 0;
    }

    protected static int setDelimiters() {
        String s2 = MorphAdornerSettings.getStringProperty(STR_FIELD_DELIMITERS, "\t");
        if (s2.length() > 0) {
            xgOptions.setFieldDelimiters(s2);
        }
        if ((s2 = MorphAdornerSettings.getStringProperty(STR_WORD_DELIMITERS, "\r\n")).length() > 0) {
            xgOptions.setWordDelimiters(s2);
        }
        if ((s2 = MorphAdornerSettings.getStringProperty(STR_SPECIAL_SEPARATOR, "/sep/")).length() > 0) {
            xgOptions.setSpecialSeparator(s2);
        }
        if ((s2 = MorphAdornerSettings.getStringProperty(STR_SURROUND_MARKER, " \ue500 ")).length() > 0) {
            xgOptions.setSurroundMarker(s2);
        }
        return 0;
    }

    protected static int setPaths() throws IOException {
        String strProperty = MorphAdornerSettings.getBooleanStringProperty(STR_WORD_PATH, "false");
        if (!strProperty.equals("false")) {
            xgOptions.setWritePath(1);
            if (strProperty.equals("true")) {
                xgOptions.setWordPathArgumentName("p");
            } else {
                xgOptions.setWordPathArgumentName(strProperty);
            }
        }
        if (!(strProperty = MorphAdornerSettings.getBooleanStringProperty(STR_TAGS_PATH, "false")).equals("false")) {
            xgOptions.setWritePath(2);
            if (strProperty.equals("true")) {
                xgOptions.setTagsPathArgumentName("p");
            } else {
                xgOptions.setTagsPathArgumentName(strProperty);
            }
        }
        return 0;
    }

    protected static int setIDs() throws IOException {
        String strProperty = MorphAdornerSettings.getBooleanStringProperty(STR_ID, "false");
        if (strProperty.equals("false")) {
            xgOptions.setWriteIds(false);
        } else {
            xgOptions.setWriteIds(true);
            if (strProperty.equals("true")) {
                strProperty = "id";
            }
            xgOptions.setIdArgumentName(strProperty);
        }
        return 0;
    }

    protected static int setLogFileNames() throws IOException {
        String strProperty = MorphAdornerSettings.getBooleanStringProperty(STR_LOG, "");
        if (strProperty.equals("false")) {
            xgOptions.setWriteLog(false);
        } else if (strProperty.equals("true")) {
            xgOptions.setWriteLog(true);
        }
        return 0;
    }

    public static String stripQuotes(String strText) {
        String result = strText;
        if (strText != null && strText.charAt(0) == '\"' && strText.charAt(strText.length() - 1) == '\"') {
            result = strText.substring(1, strText.length() - 1);
        }
        return result;
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        boolean result = defaultValue;
        String s2 = MorphAdornerSettings.stripQuotes(System.getProperty(name));
        if (s2 != null) {
            result = s2.equalsIgnoreCase("1") || s2.equalsIgnoreCase("true") || s2.equalsIgnoreCase("yes") || s2.equalsIgnoreCase("y");
        }
        return result;
    }

    public static int getIntegerProperty(String name, int defaultValue) {
        int result = defaultValue;
        String s2 = MorphAdornerSettings.stripQuotes(System.getProperty(name));
        if (s2 != null) {
            try {
                result = Integer.parseInt(s2);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getBooleanStringProperty(String name, String defaultValue) {
        String result = defaultValue;
        String s2 = MorphAdornerSettings.stripQuotes(System.getProperty(name));
        result = s2 != null ? (s2.equalsIgnoreCase("1") || s2.equalsIgnoreCase("true") || s2.equalsIgnoreCase("yes") || s2.equalsIgnoreCase("y") ? "true" : (s2.length() == 0 || s2.equalsIgnoreCase("0") || s2.equalsIgnoreCase("false") || s2.equalsIgnoreCase("no") || s2.equalsIgnoreCase("n") ? "false" : s2)) : "false";
        return result;
    }

    public static String getStringProperty(String name, String defaultValue) {
        String result = defaultValue;
        String s2 = MorphAdornerSettings.stripQuotes(System.getProperty(name));
        result = s2 != null ? s2 : "";
        return result;
    }

    public static void setXMLWordAttributes(boolean outputOriginalToken, boolean outputLemma, boolean outputStandardSpelling) {
        xmlWordAttributes = ListFactory.createNewList();
        if (outputSentenceNumber) {
            xmlWordAttributes.add(outputSentenceNumberAttribute);
        }
        if (outputWordNumber) {
            xmlWordAttributes.add(outputWordNumberAttribute);
        }
        if (outputOriginalToken) {
            xmlWordAttributes.add(outputOriginalTokenAttribute);
            xgOptions.setWordField(xmlWordAttributes.size());
        }
        if (outputSpelling) {
            xmlWordAttributes.add(outputSpellingAttribute);
        }
        if (outputPartOfSpeech) {
            xmlWordAttributes.add(outputPartOfSpeechAttribute);
        }
        if (outputStandardSpelling) {
            xmlWordAttributes.add(outputStandardSpellingAttribute);
        }
        if (outputLemma) {
            xmlWordAttributes.add(outputLemmaAttribute);
        }
        if (outputEOSFlag) {
            xmlWordAttributes.add(outputEOSFlagAttribute);
        }
        if (outputKWIC) {
            xmlWordAttributes.add(outputLeftKWICAttribute);
            xmlWordAttributes.add(outputRightKWICAttribute);
        }
    }

    public static String getXMLWordAttribute(int attrIndex) {
        String result = "";
        if (attrIndex >= 0 && attrIndex < xmlWordAttributes.size() && (result = xmlWordAttributes.get(attrIndex)) == null) {
            result = "";
        }
        return result;
    }

    public static List<String> getXMLWordAttributes() {
        return xmlWordAttributes;
    }

    protected MorphAdornerSettings() {
    }

    static {
        xgOptions = new XGOptions();
        debug = false;
        initialized = false;
        outputDirectoryName = "adorned/";
        wordLexiconURLString = null;
        wordLexiconURL = null;
        suffixLexiconURLString = null;
        suffixLexiconURL = null;
        contextRulesURLString = null;
        contextRulesURL = null;
        lexicalRulesURLString = null;
        lexicalRulesURL = null;
        spellingsURLString = null;
        spellingsURL = null;
        alternateSpellingsURLStrings = null;
        alternateSpellingsURLs = null;
        alternateSpellingsByWordClassURLStrings = null;
        alternateSpellingsByWordClassURLs = null;
        transitionMatrixURLString = null;
        transitionMatrixURL = null;
        defaultPropertiesURLString = "morphadorner.properties";
        propertiesURLString = null;
        propertiesURL = null;
        fileNames = null;
        outputSentenceNumber = false;
        outputSentenceNumberAttribute = WordAttributeNames.sn;
        outputWordOrdinalAttribute = WordAttributeNames.ord;
        outputWordOrdinal = false;
        outputWordNumber = false;
        outputWordNumberAttribute = WordAttributeNames.wn;
        outputRunningWordNumbers = false;
        outputSpelling = true;
        outputSpellingAttribute = WordAttributeNames.spe;
        outputOriginalToken = true;
        outputOriginalTokenAttribute = WordAttributeNames.tok;
        outputPartOfSpeech = true;
        outputPartOfSpeechAttribute = WordAttributeNames.pos;
        outputLemma = true;
        outputLemmaAttribute = WordAttributeNames.lem;
        outputStandardSpelling = true;
        outputStandardSpellingAttribute = WordAttributeNames.reg;
        outputKWIC = false;
        outputLeftKWICAttribute = WordAttributeNames.kl;
        outputRightKWICAttribute = WordAttributeNames.kr;
        outputKWICWidth = 80;
        outputEOSFlag = true;
        outputEOSFlagAttribute = WordAttributeNames.eos;
        xmlDoctypeName = "";
        xmlDoctypeSystem = "";
        useXMLHandler = false;
        ignoreLexiconEntriesForLemmatization = false;
        tryStandardSpellings = true;
        useLatinWordList = true;
        outputWhitespaceElements = true;
        outputNonredundantAttributesOnly = false;
        outputNonredundantTokenAttribute = false;
        outputSentenceBoundaryMilestones = false;
        allowLowerCaseProperNouns = false;
        fixGapTags = true;
        fixOrigTags = true;
        fixSplitWords = false;
        fixSplitWordsPatternReplacers = null;
        pseudoPageSize = 300;
        outputPseudoPageBoundaryMilestones = false;
        pseudoPageContainerDivTypes = "volume chapter sermon";
        closeSentenceAtEndOfHardTag = false;
        closeSentenceAtEndOfJumpTag = true;
        xmlSchema = "http://ariadne.northwestern.edu/monk/dtds/TEIAnalytics.rng";
        disallowWordElementsIn = "figdesc";
        xmlIDType = XMLIDType.READING_CONTEXT_ORDER;
        xmlIDSpacing = 10;
        xmlWordAttributes = ListFactory.createNewList();
        abbreviationsURL = "";
        adornExistingXMLFiles = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XMLIDType {
        READING_CONTEXT_ORDER,
        WORD_WITHIN_PAGE_BLOCK;

    }
}

