/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.AddWordAttributesFilter;
import edu.northwestern.at.morphadorner.MorphAdornerLogger;
import edu.northwestern.at.morphadorner.MorphAdornerSettings;
import edu.northwestern.at.morphadorner.MorphAdornerXMLWriter;
import edu.northwestern.at.morphadorner.MorphAdornerXMLWriterFactory;
import edu.northwestern.at.morphadorner.PseudoPageAdderFilter;
import edu.northwestern.at.morphadorner.StripWordAttributesFilter;
import edu.northwestern.at.morphadorner.WordAttributePatterns;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWordFilter;
import edu.northwestern.at.morphadorner.tools.FilterAdornedFile;
import edu.northwestern.at.morphadorner.xgtagger.XGParser;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.IsCloseableObject;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.RomanNumeralUtils;
import edu.northwestern.at.utils.SingleTagTaggedStrings;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.TaggedStringsSet;
import edu.northwestern.at.utils.TextFile;
import edu.northwestern.at.utils.URLUtils;
import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.inputter.TextInputter;
import edu.northwestern.at.utils.corpuslinguistics.inputter.TextInputterFactory;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.Lemmatizer;
import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.LemmatizerFactory;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.LexiconFactory;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.UsesLexicon;
import edu.northwestern.at.utils.corpuslinguistics.namerecognizer.Names;
import edu.northwestern.at.utils.corpuslinguistics.namestandardizer.NameStandardizer;
import edu.northwestern.at.utils.corpuslinguistics.namestandardizer.NameStandardizerFactory;
import edu.northwestern.at.utils.corpuslinguistics.outputter.AdornedWordOutputter;
import edu.northwestern.at.utils.corpuslinguistics.outputter.AdornedWordOutputterFactory;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTagsFactory;
import edu.northwestern.at.utils.corpuslinguistics.postagger.InvalidRuleException;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechRetagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechRetaggerFactory;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTaggerFactory;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.PartOfSpeechGuesser;
import edu.northwestern.at.utils.corpuslinguistics.postagger.guesser.PartOfSpeechGuesserFactory;
import edu.northwestern.at.utils.corpuslinguistics.postagger.noopretagger.NoopRetagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.transitionmatrix.TransitionMatrix;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.SentenceSplitter;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.SentenceSplitterFactory;
import edu.northwestern.at.utils.corpuslinguistics.spellingmapper.SpellingMapper;
import edu.northwestern.at.utils.corpuslinguistics.spellingmapper.SpellingMapperFactory;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.SpellingStandardizer;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.SpellingStandardizerFactory;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.Abbreviations;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.PennTreebankTokenizer;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.WordTokenizer;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.WordTokenizerFactory;
import edu.northwestern.at.utils.logger.UsesLogger;
import edu.northwestern.at.utils.xml.DOMUtils;
import edu.northwestern.at.utils.xml.ExtendedXMLFilterImpl;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphAdorner {
    protected static int defaultKWICWidth = 80;
    protected static String latinWordsFileName = "resources/latinwords.txt";
    protected static String extraWordsFileName = "resources/extrawords.txt";
    protected static TaggedStrings extraWords = null;
    protected static Pattern underlineCapCapPattern = Pattern.compile("^_([ABCDEFGHIJKLMNOPQRSTUVWXYZ])([ABCDEFGHIJKLMNOPQRSTUVWXYZ])");
    protected static final Matcher underlineCapCapMatcher = underlineCapCapPattern.matcher("");
    protected static WordTokenizer spellingTokenizer = new PennTreebankTokenizer();
    protected static PartOfSpeechTags partOfSpeechTags;
    protected static PartOfSpeechTagger tagger;
    protected static PartOfSpeechRetagger retagger;
    protected static Lexicon wordLexicon;
    protected static PartOfSpeechGuesser partOfSpeechGuesser;
    protected static Lexicon suffixLexicon;
    protected static TransitionMatrix transitionMatrix;
    protected static SpellingStandardizer spellingStandardizer;
    protected static SpellingMapper spellingMapper;
    protected static NameStandardizer nameStandardizer;
    protected static Lemmatizer lemmatizer;
    protected static SentenceSplitterFactory sentenceSplitterFactory;
    protected static AdornedWordOutputterFactory outputterFactory;
    protected static WordTokenizerFactory wordTokenizerFactory;
    protected static TextInputterFactory inputterFactory;
    protected static Names names;
    protected static String tagSeparator;
    protected static String lemmaSeparator;
    protected static Runtime runTime;

    protected static void logMemoryUsage(String title) {
        long freeMem = runTime.freeMemory();
        long totalMem = runTime.totalMemory();
        MorphAdornerLogger.println("Memory_used", new Object[]{title, Formatters.formatLongWithCommas(freeMem), Formatters.formatLongWithCommas(totalMem)});
    }

    protected static Lexicon loadWordLexicon() throws IOException {
        long startTime = System.currentTimeMillis();
        LexiconFactory lexiconFactory = new LexiconFactory();
        Lexicon wordLexicon = lexiconFactory.newLexicon();
        if (MorphAdornerSettings.wordLexiconURL != null) {
            wordLexicon.loadLexicon(MorphAdornerSettings.wordLexiconURL, "utf-8");
        }
        MorphAdornerLogger.println("Loaded_word_lexicon", new Object[]{Formatters.formatIntegerWithCommas(wordLexicon.getLexiconSize()), MorphAdorner.durationString(startTime)});
        ((UsesLogger)((Object)wordLexicon)).setLogger(MorphAdornerLogger.getLogger());
        return wordLexicon;
    }

    protected static Lexicon loadSuffixLexicon() throws IOException {
        long startTime = System.currentTimeMillis();
        LexiconFactory lexiconFactory = new LexiconFactory();
        Lexicon suffixLexicon = lexiconFactory.newLexicon();
        if (MorphAdornerSettings.suffixLexiconURL != null) {
            suffixLexicon.loadLexicon(MorphAdornerSettings.suffixLexiconURL, "utf-8");
        }
        MorphAdornerLogger.println("Loaded_suffix_lexicon", new Object[]{Formatters.formatIntegerWithCommas(suffixLexicon.getLexiconSize()), MorphAdorner.durationString(startTime)});
        ((UsesLogger)((Object)suffixLexicon)).setLogger(MorphAdornerLogger.getLogger());
        return suffixLexicon;
    }

    protected static TransitionMatrix loadTransitionMatrix(PartOfSpeechTagger tagger) throws IOException {
        TransitionMatrix transitionMatrix = new TransitionMatrix();
        if (MorphAdornerSettings.transitionMatrixURL != null && tagger.usesTransitionProbabilities()) {
            long startTime = System.currentTimeMillis();
            transitionMatrix.loadTransitionMatrix(MorphAdornerSettings.transitionMatrixURL, "utf-8", '\t');
            tagger.setTransitionMatrix(transitionMatrix);
            MorphAdornerLogger.println("Loaded_transition_matrix", new Object[]{MorphAdorner.durationString(startTime)});
            transitionMatrix.setLogger(MorphAdornerLogger.getLogger());
        }
        return transitionMatrix;
    }

    protected static void loadTaggerRules(PartOfSpeechTagger tagger) throws InvalidRuleException, IOException {
        if (MorphAdornerSettings.contextRulesURL != null && tagger.usesContextRules()) {
            String[] contextRules = new TextFile(MorphAdornerSettings.contextRulesURL, "utf-8").toArray();
            tagger.setContextRules(contextRules);
        }
        if (MorphAdornerSettings.lexicalRulesURL != null && tagger.usesLexicalRules()) {
            String[] lexicalRules = new TextFile(MorphAdornerSettings.lexicalRulesURL, "utf-8").toArray();
            tagger.setLexicalRules(lexicalRules);
        }
    }

    protected static SpellingStandardizer createSpellingStandardizer(Lexicon wordLexicon) throws IOException {
        SpellingStandardizerFactory spellingStandardizerFactory = new SpellingStandardizerFactory();
        SpellingStandardizer spellingStandardizer = spellingStandardizerFactory.newSpellingStandardizer();
        if (spellingStandardizer != null) {
            int i;
            long startTime = System.currentTimeMillis();
            if (spellingStandardizer instanceof UsesLexicon) {
                ((UsesLexicon)((Object)spellingStandardizer)).setLexicon(wordLexicon);
            }
            int numberOfStandardSpellings = 0;
            if (MorphAdornerSettings.spellingsURL != null) {
                spellingStandardizer.loadStandardSpellings(MorphAdornerSettings.spellingsURL, "utf-8");
                numberOfStandardSpellings = spellingStandardizer.getNumberOfStandardSpellings();
                MorphAdornerLogger.println("Loaded_standard_spellings", new Object[]{Formatters.formatIntegerWithCommas(numberOfStandardSpellings), MorphAdorner.durationString(startTime)});
            }
            spellingStandardizer.addStandardSpellings(names.getFirstNames());
            spellingStandardizer.addStandardSpellings(names.getSurnames());
            spellingStandardizer.addStandardSpellings(names.getPlaceNames().keySet());
            if (MorphAdornerSettings.alternateSpellingsURLs != null) {
                int altSpellingsCount = 0;
                for (i = 0; i < MorphAdornerSettings.alternateSpellingsURLs.length; ++i) {
                    startTime = System.currentTimeMillis();
                    spellingStandardizer.loadAlternativeSpellings(MorphAdornerSettings.alternateSpellingsURLs[i], "utf-8", "\t");
                    MorphAdornerLogger.println("Loaded_alternate_spellings", new Object[]{Formatters.formatIntegerWithCommas(spellingStandardizer.getNumberOfAlternateSpellings() - altSpellingsCount), MorphAdorner.durationString(startTime)});
                    altSpellingsCount = spellingStandardizer.getNumberOfAlternateSpellings();
                }
            }
            if (MorphAdornerSettings.alternateSpellingsByWordClassURLs != null) {
                int[] altCountsCum = new int[]{0, 0};
                for (i = 0; i < MorphAdornerSettings.alternateSpellingsByWordClassURLs.length; ++i) {
                    startTime = System.currentTimeMillis();
                    spellingStandardizer.loadAlternativeSpellingsByWordClass(MorphAdornerSettings.alternateSpellingsByWordClassURLs[i], "utf-8");
                    int[] altCounts = spellingStandardizer.getNumberOfAlternateSpellingsByWordClass();
                    MorphAdornerLogger.println("Loaded_alternate_spellings_by_word_class", new Object[]{Formatters.formatIntegerWithCommas(altCounts[1] - altCountsCum[1]), Formatters.formatIntegerWithCommas(altCounts[0] - altCountsCum[0]), MorphAdorner.durationString(startTime)});
                    altCountsCum[0] = altCounts[0];
                    altCountsCum[1] = altCounts[1];
                }
            }
            if (nameStandardizer instanceof UsesLogger) {
                ((UsesLogger)((Object)spellingStandardizer)).setLogger(MorphAdornerLogger.getLogger());
            }
        }
        return spellingStandardizer;
    }

    protected static SpellingMapper createSpellingMapper() throws IOException {
        SpellingMapperFactory spellingMapperFactory = new SpellingMapperFactory();
        return spellingMapperFactory.newSpellingMapper();
    }

    protected static NameStandardizer createNameStandardizer(Lexicon wordLexicon) throws IOException {
        NameStandardizerFactory nameStandardizerFactory = new NameStandardizerFactory();
        NameStandardizer nameStandardizer = nameStandardizerFactory.newNameStandardizer();
        if (nameStandardizer != null) {
            if (wordLexicon != null) {
                long startTime = System.currentTimeMillis();
                nameStandardizer.loadNamesFromLexicon(wordLexicon);
                int numberOfNames = nameStandardizer.getNumberOfNames();
                MorphAdornerLogger.println("Loaded_names", new Object[]{Formatters.formatIntegerWithCommas(numberOfNames), MorphAdorner.durationString(startTime)});
            }
            if (nameStandardizer instanceof UsesLogger) {
                ((UsesLogger)((Object)nameStandardizer)).setLogger(MorphAdornerLogger.getLogger());
            }
        }
        return nameStandardizer;
    }

    protected static void initializeAdornment() {
        try {
            sentenceSplitterFactory = new SentenceSplitterFactory();
            outputterFactory = new AdornedWordOutputterFactory();
            wordTokenizerFactory = new WordTokenizerFactory();
            inputterFactory = new TextInputterFactory();
            PartOfSpeechTagsFactory partOfSpeechTagsFactory = new PartOfSpeechTagsFactory();
            partOfSpeechTags = partOfSpeechTagsFactory.newPartOfSpeechTags();
            tagSeparator = partOfSpeechTags.getTagSeparator();
            PartOfSpeechTaggerFactory taggerFactory = new PartOfSpeechTaggerFactory();
            tagger = taggerFactory.newPartOfSpeechTagger();
            PartOfSpeechRetaggerFactory retaggerFactory = new PartOfSpeechRetaggerFactory();
            retagger = retaggerFactory.newPartOfSpeechRetagger();
            ((UsesLogger)((Object)tagger)).setLogger(MorphAdornerLogger.getLogger());
            ((UsesLogger)((Object)retagger)).setLogger(MorphAdornerLogger.getLogger());
            tagger.setRetagger(retagger);
            MorphAdornerLogger.println("Using", new Object[]{tagger.toString()});
            MorphAdornerLogger.println("Using", new Object[]{retagger.toString()});
            wordLexicon = MorphAdorner.loadWordLexicon();
            wordLexicon.setPartOfSpeechTags(partOfSpeechTags);
            partOfSpeechGuesser = new PartOfSpeechGuesserFactory().newPartOfSpeechGuesser();
            boolean checkPossessives = MorphAdornerSettings.getBooleanProperty("partofspeechguesser.check_possessives", false);
            partOfSpeechGuesser.setCheckPossessives(checkPossessives);
            tagger.setPartOfSpeechGuesser(partOfSpeechGuesser);
            partOfSpeechGuesser.setWordLexicon(wordLexicon);
            ((UsesLogger)((Object)partOfSpeechGuesser)).setLogger(MorphAdornerLogger.getLogger());
            suffixLexicon = MorphAdorner.loadSuffixLexicon();
            partOfSpeechGuesser.setSuffixLexicon(suffixLexicon);
            extraWords = MorphAdorner.getExtraWordsList(extraWordsFileName, partOfSpeechTags.getSingularProperNounTag(), "Loaded_extra_words");
            partOfSpeechGuesser.addAuxiliaryWordList(extraWords);
            partOfSpeechGuesser.addAuxiliaryWordList(new TaggedStringsSet(names.getPlaceNames().keySet(), partOfSpeechTags.getSingularProperNounTag()));
            partOfSpeechGuesser.addAuxiliaryWordList(new TaggedStringsSet(names.getFirstNames(), partOfSpeechTags.getSingularProperNounTag()));
            partOfSpeechGuesser.addAuxiliaryWordList(new TaggedStringsSet(names.getSurnames(), partOfSpeechTags.getSingularProperNounTag()));
            if (MorphAdornerSettings.useLatinWordList) {
                partOfSpeechGuesser.addAuxiliaryWordList(MorphAdorner.getWordList(latinWordsFileName, partOfSpeechTags.getForeignWordTag("latin"), "Loaded_latin_words"));
            }
            if (MorphAdornerSettings.abbreviationsURL.length() > 0) {
                MorphAdorner.loadAbbreviations(URLUtils.getURLFromFileNameOrURL(MorphAdornerSettings.abbreviationsURL).toString(), "Loaded_abbreviations");
            }
            tagger.setLexicon(wordLexicon);
            MorphAdorner.loadTaggerRules(tagger);
            transitionMatrix = MorphAdorner.loadTransitionMatrix(tagger);
            spellingStandardizer = MorphAdorner.createSpellingStandardizer(wordLexicon);
            spellingMapper = MorphAdorner.createSpellingMapper();
            nameStandardizer = MorphAdorner.createNameStandardizer(wordLexicon);
            if (spellingStandardizer != null) {
                partOfSpeechGuesser.setSpellingStandardizer(spellingStandardizer);
            }
            LemmatizerFactory lemmatizerFactory = new LemmatizerFactory();
            lemmatizer = lemmatizerFactory.newLemmatizer();
            lemmaSeparator = lemmatizer.getLemmaSeparator();
            lemmatizer.setLexicon(wordLexicon);
            lemmatizer.setDictionary(spellingStandardizer.getStandardSpellings());
            ((UsesLogger)((Object)lemmatizer)).setLogger(MorphAdornerLogger.getLogger());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void processInputFiles() {
        long processStartTime = System.currentTimeMillis();
        switch (MorphAdornerSettings.fileNames.length) {
            case 0: {
                MorphAdornerLogger.println("No_files_to_process");
                break;
            }
            case 1: {
                MorphAdornerLogger.println("One_file_to_process");
                break;
            }
            default: {
                MorphAdornerLogger.println("Number_of_files_to_process", new Object[]{Formatters.formatIntegerWithCommas(MorphAdornerSettings.fileNames.length)});
            }
        }
        boolean useXMLHandler = MorphAdornerSettings.getBooleanProperty("adorner.handle_xml", false);
        MorphAdorner.logMemoryUsage("Before processing input texts: ");
        for (int i = 0; i < MorphAdornerSettings.fileNames.length; ++i) {
            String inputFileName = MorphAdornerSettings.fileNames[i];
            MorphAdornerLogger.println("Processing_file", new Object[]{inputFileName});
            try {
                if (useXMLHandler) {
                    if (MorphAdorner.isAdorned(inputFileName, 500)) {
                        MorphAdorner.readorn(inputFileName);
                        continue;
                    }
                    MorphAdorner.adornXML(inputFileName);
                    continue;
                }
                MorphAdorner.adornFile(inputFileName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (MorphAdornerSettings.fileNames.length > 0) {
            MorphAdornerLogger.println("All_files_adorned", new Object[]{MorphAdorner.durationString(processStartTime)});
        }
    }

    public static void adornXML(String inputFileName) throws Exception {
        if (!MorphAdornerSettings.adornExistingXMLFiles && MorphAdorner.doesOutputFileNameExist(inputFileName)) {
            MorphAdornerLogger.println("Skipping_file_which_is_already_adorned", new Object[]{inputFileName});
            return;
        }
        TextInputter inputter = inputterFactory.newTextInputter();
        inputter.enableGapFixer(MorphAdornerSettings.fixGapTags);
        inputter.enableOrigFixer(MorphAdornerSettings.fixOrigTags);
        inputter.enableSplitWordsFixer(MorphAdornerSettings.fixSplitWords, MorphAdornerSettings.fixSplitWordsPatternReplacers);
        URL inputFileURL = URLUtils.getURLFromFileNameOrURL(inputFileName);
        inputter.loadText(inputFileURL, "utf-8", MorphAdornerSettings.xmlSchema);
        int nSegments = inputter.getSegmentCount();
        String sSegments = Formatters.formatIntegerWithCommas(nSegments);
        MorphAdornerLogger.println("Input_file_split", new Object[]{inputFileName, sSegments});
        int runningWordID = 0;
        Map<Integer, Integer> splitWords = MapFactory.createNewMap();
        int totalWords = 0;
        int totalPageBreaks = 0;
        for (int j = 0; j < nSegments; ++j) {
            String segmentName = inputter.getSegmentName(j);
            if (!segmentName.startsWith("text") || segmentName.equals("text")) continue;
            MorphAdornerLogger.println("Processing_segment", new Object[]{segmentName, Formatters.formatIntegerWithCommas(j + 1), sSegments});
            String segmentText = inputter.getSegmentText(segmentName);
            Document document = XGParser.textToDOM(MorphAdornerSettings.xgOptions, segmentText);
            MorphAdorner.fixEmptySoftTags(document);
            MorphAdorner.fixSupTags(document);
            totalPageBreaks += MorphAdorner.countPageBreaks(document);
            Object[] o = XGParser.extractText(MorphAdornerSettings.xgOptions, document);
            XGParser xgParser = (XGParser)o[1];
            xgParser.setRunningWordID(runningWordID);
            AdornedWordOutputter outputter = MorphAdorner.adornText((String)o[0], null);
            MorphAdornerLogger.println("Inserting_adornments_into_xml");
            long startTime = System.currentTimeMillis();
            Map<Integer, Integer> segmentSplitWords = XGParser.mergeAdornments(MorphAdornerSettings.xgOptions, (XGParser)o[1], document, segmentName, outputter, inputter);
            for (int wid : segmentSplitWords.keySet()) {
                if (segmentSplitWords.get(wid) <= 1) continue;
                splitWords.put(wid, segmentSplitWords.get(wid));
            }
            MorphAdornerLogger.println("Inserted_adornments_into_xml", new Object[]{MorphAdorner.durationString(startTime)});
            runningWordID = xgParser.getRunningWordID();
            totalWords += xgParser.getNumberOfAdornedWords();
            xgParser = null;
            document = null;
            outputter = null;
            o[0] = null;
            o[1] = null;
            o = null;
        }
        String outputFileName = MorphAdorner.getOutputFileName(inputFileName);
        long startTime = System.currentTimeMillis();
        MorphAdornerLogger.println("Merging_adorned");
        File file = File.createTempFile("mad", null);
        file.deleteOnExit();
        String tempFileName = file.getAbsolutePath();
        MorphAdorner.mergeXML(inputter, tempFileName);
        MorphAdornerLogger.println("Writing_merged", new Object[]{outputFileName});
        MorphAdornerXMLWriterFactory xmlWriterFactory = new MorphAdornerXMLWriterFactory();
        MorphAdornerXMLWriter xmlWriter = xmlWriterFactory.newMorphAdornerXMLWriter();
        xmlWriter.writeXML(tempFileName, outputFileName, runningWordID, partOfSpeechTags, splitWords, totalWords, totalPageBreaks);
        try {
            file.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
        MorphAdornerLogger.println("Adorned_XML_written", new Object[]{outputFileName, MorphAdorner.durationString(startTime)});
        ((IsCloseableObject)((Object)inputter)).close();
        inputter = null;
        splitWords = null;
        xmlWriter = null;
        MorphAdorner.logMemoryUsage("After completing " + inputFileName + ": ");
    }

    public static String getOutputFileName(String inputFileName) throws IOException {
        String result = FileNameUtils.stripPathName(inputFileName);
        if (!FileUtils.createPathForFile(result = new File(MorphAdornerSettings.outputDirectoryName, result).getPath())) {
            throw new IOException(MorphAdornerSettings.getString("Unable_to_create_output_directory"));
        }
        result = FileNameUtils.createVersionedFileName(result);
        return result;
    }

    public static boolean doesOutputFileNameExist(String inputFileName) {
        String outputFileName = FileNameUtils.stripPathName(inputFileName);
        return new File(MorphAdornerSettings.outputDirectoryName, outputFileName).exists();
    }

    public static AdornedWordOutputter adornFile(String fileName) throws IOException {
        MorphAdornerLogger.println("Tagging", new Object[]{fileName});
        URL fileURL = URLUtils.getURLFromFileNameOrURL(fileName);
        if (fileURL == null) {
            MorphAdornerLogger.println("Bad_file_name_or_URL", new Object[]{fileName});
            return null;
        }
        String fileText = "";
        long startTime = System.currentTimeMillis();
        try {
            TextInputter inputter = inputterFactory.newTextInputter();
            inputter.enableGapFixer(MorphAdornerSettings.fixGapTags);
            inputter.enableOrigFixer(MorphAdornerSettings.fixOrigTags);
            inputter.loadText(fileURL, "utf-8", MorphAdornerSettings.xmlSchema);
            fileText = inputter.getSegmentText(0);
            ((IsCloseableObject)((Object)inputter)).close();
        }
        catch (Exception e) {
            MorphAdornerLogger.println("Unable_to_read_text", new Object[]{fileName});
            return null;
        }
        MorphAdornerLogger.println("Loaded_text", new Object[]{fileName, MorphAdorner.durationString(startTime)});
        return MorphAdorner.adornText(fileText, fileURL);
    }

    public static AdornedWordOutputter adornText(String textToAdorn, URL outputURL) throws IOException {
        long startTime = System.currentTimeMillis();
        SentenceSplitter sentenceSplitter = sentenceSplitterFactory.newSentenceSplitter();
        ((UsesLogger)((Object)sentenceSplitter)).setLogger(MorphAdornerLogger.getLogger());
        sentenceSplitter.setPartOfSpeechGuesser(partOfSpeechGuesser);
        List<List<String>> sentences = sentenceSplitter.extractSentences(textToAdorn, wordTokenizerFactory.newWordTokenizer());
        int[] wordAndSentenceCounts = MorphAdorner.getWordAndSentenceCounts(sentences);
        int wordsToTag = wordAndSentenceCounts[1];
        MorphAdornerLogger.println("Extracted_words", new Object[]{Formatters.formatIntegerWithCommas(wordsToTag), Formatters.formatIntegerWithCommas(wordAndSentenceCounts[0]), MorphAdorner.durationString(startTime)});
        if (partOfSpeechGuesser != null) {
            partOfSpeechGuesser.setTryStandardSpellings(MorphAdornerSettings.tryStandardSpellings);
        }
        boolean doOutputLemma = MorphAdornerSettings.outputLemma && lemmatizer != null;
        boolean doOutputStandardSpelling = MorphAdornerSettings.outputStandardSpelling && spellingStandardizer != null;
        boolean doOutputOriginalToken = MorphAdornerSettings.outputOriginalToken || MorphAdornerSettings.useXMLHandler;
        MorphAdornerSettings.setXMLWordAttributes(doOutputOriginalToken, doOutputLemma, doOutputStandardSpelling);
        startTime = System.currentTimeMillis();
        List<List<AdornedWord>> result = tagger.tagSentences(sentences);
        double elapsed = System.currentTimeMillis() - startTime;
        int taggingRate = (int)((double)wordsToTag / elapsed * 1000.0);
        MorphAdornerLogger.println("Tagging_complete", new Object[]{MorphAdorner.durationString(startTime), Formatters.formatIntegerWithCommas(taggingRate)});
        MorphAdornerLogger.println("Generating_other_adornments");
        startTime = System.currentTimeMillis();
        AdornedWordOutputter outputter = outputterFactory.newAdornedWordOutputter();
        outputter.setWordAttributeNames(MorphAdornerSettings.getXMLWordAttributes());
        if (outputURL != null) {
            outputter.createOutputFile(MorphAdorner.getOutputFileName(URLUtils.getFileNameFromURL(outputURL, MorphAdornerSettings.outputDirectoryName)), "utf-8", '\t');
        } else {
            File file = File.createTempFile("mad", null);
            file.deleteOnExit();
            String tempFileName = file.getAbsolutePath();
            outputter.createOutputFile(tempFileName, "utf-8", '\t');
        }
        int sentenceNumber = 0;
        int wordNumber = 0;
        String lemma = "";
        String correctedSpelling = "";
        String standardizedSpelling = "";
        String sSentenceNumber = "";
        String sWordNumber = "";
        String eosFlag = "";
        String originalToken = "";
        String partOfSpeechTag = "";
        String xmlSurroundMarker = MorphAdornerSettings.xgOptions.getSurroundMarker().trim();
        String undeterminedPosTag = partOfSpeechTags.getUndeterminedTag();
        List<String> outputAdornments = ListFactory.createNewList();
        for (List<AdornedWord> sentenceFromTagger : result) {
            sSentenceNumber = ++sentenceNumber + "";
            int sentenceSizeM1 = sentenceFromTagger.size() - 1;
            if (!MorphAdornerSettings.outputRunningWordNumbers) {
                wordNumber = 0;
            }
            for (int j = 0; j < sentenceFromTagger.size(); ++j) {
                outputAdornments.clear();
                if (MorphAdornerSettings.outputSentenceNumber) {
                    outputAdornments.add(sSentenceNumber);
                }
                ++wordNumber;
                if (MorphAdornerSettings.outputWordNumber) {
                    sWordNumber = wordNumber + "";
                    outputAdornments.add(sWordNumber);
                }
                AdornedWord adornedWord = sentenceFromTagger.get(j);
                originalToken = adornedWord.getToken();
                if (MorphAdornerSettings.outputOriginalToken) {
                    outputAdornments.add(originalToken);
                }
                correctedSpelling = adornedWord.getSpelling();
                standardizedSpelling = adornedWord.getStandardSpelling();
                if (MorphAdornerSettings.outputSpelling) {
                    outputAdornments.add(correctedSpelling);
                }
                partOfSpeechTag = adornedWord.getPartsOfSpeech();
                if (doOutputStandardSpelling) {
                    standardizedSpelling = MorphAdorner.getStandardizedSpelling(spellingStandardizer, nameStandardizer, correctedSpelling, standardizedSpelling, partOfSpeechTag);
                    if (spellingMapper != null) {
                        standardizedSpelling = spellingMapper.mapSpelling(standardizedSpelling);
                    }
                }
                if (doOutputLemma) {
                    lemma = !MorphAdornerSettings.ignoreLexiconEntriesForLemmatization ? wordLexicon.getLemma(correctedSpelling, partOfSpeechTag) : "*";
                    if (lemma.equals("*") && lemmatizer != null) {
                        lemma = standardizedSpelling.length() > 0 ? MorphAdorner.getLemma(lemmatizer, standardizedSpelling, partOfSpeechTag) : MorphAdorner.getLemma(lemmatizer, correctedSpelling, partOfSpeechTag);
                    }
                    if (lemma.indexOf(lemmaSeparator) < 0 && !partOfSpeechTags.isProperNounTag(partOfSpeechTag)) {
                        lemma = lemma.toLowerCase();
                    }
                }
                if (lemmatizer != null) {
                    if (partOfSpeechTags.countTags(partOfSpeechTag) != lemmatizer.countLemmata(lemma)) {
                        partOfSpeechTag = undeterminedPosTag;
                    }
                    if (partOfSpeechTag.equals(undeterminedPosTag) || lemma.length() == 0) {
                        lemma = correctedSpelling.toLowerCase();
                        standardizedSpelling = correctedSpelling;
                        partOfSpeechTag = undeterminedPosTag;
                    }
                }
                if (MorphAdornerSettings.outputPartOfSpeech) {
                    outputAdornments.add(partOfSpeechTag);
                }
                if (doOutputStandardSpelling) {
                    outputAdornments.add(standardizedSpelling);
                }
                if (doOutputLemma) {
                    outputAdornments.add(lemma);
                }
                if (MorphAdornerSettings.outputEOSFlag) {
                    if (MorphAdornerSettings.useXMLHandler) {
                        eosFlag = "0";
                        if (j < sentenceSizeM1) {
                            AdornedWord nextAdornedWord = sentenceFromTagger.get(j + 1);
                            if (nextAdornedWord.getToken().equals(xmlSurroundMarker) && (originalToken.endsWith(".") || originalToken.endsWith("!") || originalToken.endsWith("?") || originalToken.endsWith("'") || originalToken.endsWith("\"") || originalToken.endsWith("\u2019") || originalToken.endsWith("\u201d") || originalToken.endsWith("}") || originalToken.endsWith("]") || originalToken.endsWith(")"))) {
                                eosFlag = "1";
                            }
                        } else {
                            eosFlag = "1";
                        }
                    } else {
                        eosFlag = j >= sentenceSizeM1 ? "1" : "0";
                    }
                    outputAdornments.add(eosFlag);
                }
                if (MorphAdornerSettings.outputKWIC) {
                    String[] kwics = MorphAdorner.getKWIC(sentenceFromTagger, j, MorphAdornerSettings.outputKWICWidth);
                    outputAdornments.add(kwics[0]);
                    outputAdornments.add(kwics[2]);
                }
                outputter.outputWordAndAdornments(outputAdornments);
            }
        }
        outputter.close();
        if (outputURL != null) {
            MorphAdornerLogger.println("Adornments_written_to", new Object[]{MorphAdorner.getOutputFileName(URLUtils.getFileNameFromURL(outputURL, MorphAdornerSettings.outputDirectoryName)), MorphAdorner.durationString(startTime)});
        } else {
            MorphAdornerLogger.println("Adornments_generated", new Object[]{MorphAdorner.durationString(startTime)});
        }
        sentences.clear();
        result.clear();
        sentences = null;
        result = null;
        return outputter;
    }

    public static void readorn(String inputFileName) throws SAXException, IOException, FileNotFoundException {
        AddWordAttributesFilter addFilter;
        MorphAdornerLogger.println("Loading_previously_adorned");
        long startTime = System.currentTimeMillis();
        ExtendedAdornedWordFilter wordInfoFilter = new ExtendedAdornedWordFilter(XMLReaderFactory.createXMLReader());
        StripWordAttributesFilter stripFilter = new StripWordAttributesFilter(wordInfoFilter);
        File file = File.createTempFile("mad", null);
        file.deleteOnExit();
        String tempFileName = file.getAbsolutePath();
        new FilterAdornedFile(inputFileName, tempFileName, stripFilter);
        List sentences = wordInfoFilter.getSentences();
        MorphAdornerLogger.println("Loaded_existing_words", new Object[]{Formatters.formatIntegerWithCommas(wordInfoFilter.getNumberOfWords()), Formatters.formatIntegerWithCommas(sentences.size()), MorphAdorner.durationString(startTime)});
        PartOfSpeechRetagger savedRetagger = null;
        if (retagger.canAddOrDeleteWords()) {
            savedRetagger = retagger;
            tagger.setRetagger(new NoopRetagger());
            MorphAdornerLogger.println("Disabling_retagger", new Object[]{retagger.toString()});
        }
        startTime = System.currentTimeMillis();
        tagger.tagAdornedWordSentences(sentences);
        if (savedRetagger != null) {
            tagger.setRetagger(savedRetagger);
        }
        double elapsed = System.currentTimeMillis() - startTime;
        int taggingRate = (int)((double)wordInfoFilter.getNumberOfWords() / elapsed * 1000.0);
        MorphAdornerLogger.println("Tagging_complete", new Object[]{MorphAdorner.durationString(startTime), Formatters.formatIntegerWithCommas(taggingRate)});
        MorphAdornerLogger.println("Generating_other_adornments");
        startTime = System.currentTimeMillis();
        String lemma = "";
        String correctedSpelling = "";
        String standardizedSpelling = "";
        String originalToken = "";
        String partOfSpeechTag = "";
        for (int i = 0; i < sentences.size(); ++i) {
            List sentence = sentences.get(i);
            for (int j = 0; j < sentence.size(); ++j) {
                AdornedWord adornedWord = (AdornedWord)sentence.get(j);
                originalToken = adornedWord.getToken();
                correctedSpelling = adornedWord.getSpelling();
                standardizedSpelling = adornedWord.getStandardSpelling();
                partOfSpeechTag = adornedWord.getPartsOfSpeech();
                standardizedSpelling = MorphAdorner.getStandardizedSpelling(spellingStandardizer, nameStandardizer, correctedSpelling, standardizedSpelling, partOfSpeechTag);
                if (spellingMapper != null) {
                    standardizedSpelling = spellingMapper.mapSpelling(standardizedSpelling);
                }
                if ((lemma = !MorphAdornerSettings.ignoreLexiconEntriesForLemmatization ? wordLexicon.getLemma(correctedSpelling, partOfSpeechTag) : "*").equals("*") && lemmatizer != null) {
                    lemma = standardizedSpelling.length() > 0 ? MorphAdorner.getLemma(lemmatizer, standardizedSpelling, partOfSpeechTag) : MorphAdorner.getLemma(lemmatizer, correctedSpelling, partOfSpeechTag);
                }
                if (lemma.indexOf(lemmaSeparator) >= 0 || partOfSpeechTags.isProperNounTag(partOfSpeechTag)) continue;
                lemma = lemma.toLowerCase();
            }
        }
        MorphAdornerLogger.println("Adornments_generated", new Object[]{MorphAdorner.durationString(startTime)});
        ExtendedXMLFilterImpl filter = addFilter = new AddWordAttributesFilter(XMLReaderFactory.createXMLReader(), wordInfoFilter);
        if (MorphAdornerSettings.outputPseudoPageBoundaryMilestones) {
            PseudoPageAdderFilter pseudoPageFilter = new PseudoPageAdderFilter(addFilter, MorphAdornerSettings.pseudoPageSize, MorphAdornerSettings.pseudoPageContainerDivTypes);
            filter = pseudoPageFilter;
        }
        String outputFileName = MorphAdorner.getOutputFileName(inputFileName);
        MorphAdornerLogger.println("Writing_merged", new Object[]{outputFileName});
        startTime = System.currentTimeMillis();
        new FilterAdornedFile(tempFileName, outputFileName, filter);
        MorphAdornerLogger.println("Adorned_XML_written", new Object[]{outputFileName, MorphAdorner.durationString(startTime)});
        try {
            file.delete();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected static boolean isAdorned(String xmlFileName, int maxLinesToCheck) {
        boolean result = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(new FileInputStream(xmlFileName), "utf-8"));
            int linesRead = 0;
            String line = bufferedReader.readLine();
            while (line != null && !result && linesRead < maxLinesToCheck) {
                ++linesRead;
                int wPos = line.indexOf("<w ");
                if (wPos >= 0) {
                    String[] groupValues = WordAttributePatterns.wReplacer.matchGroups(line);
                    try {
                        String id;
                        String[] idValues = WordAttributePatterns.idReplacer.matchGroups(groupValues[2]);
                        if (idValues != null && (id = idValues[2]) != null && id.length() > 0) {
                            result = true;
                            break;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void loadAbbreviations(String abbreviationsURL, String loadedMessage) {
        long startTime = System.currentTimeMillis();
        int currentCount = Abbreviations.getAbbreviationsCount();
        Abbreviations.loadAbbreviations(abbreviationsURL);
        int added = Abbreviations.getAbbreviationsCount() - currentCount;
        MorphAdornerLogger.println(loadedMessage, new Object[]{Formatters.formatIntegerWithCommas(added), MorphAdorner.durationString(startTime)});
    }

    public static TaggedStrings getWordList(String wordFileName, String posTag, String loadedMessage) {
        long startTime = System.currentTimeMillis();
        TextFile wordFile = new TextFile(MorphAdorner.class.getResourceAsStream(wordFileName), "utf-8");
        SingleTagTaggedStrings words = new SingleTagTaggedStrings(wordFile.toArray(), posTag);
        wordFile = null;
        MorphAdornerLogger.println(loadedMessage, new Object[]{Formatters.formatIntegerWithCommas(words.getStringCount()), MorphAdorner.durationString(startTime)});
        return words;
    }

    public static TaggedStrings getExtraWordsList(String wordFileName, String posTag, String loadedMessage) {
        long startTime = System.currentTimeMillis();
        UTF8Properties words = null;
        try {
            words = new UTF8Properties();
            words.load(MorphAdorner.class.getResourceAsStream(wordFileName), posTag);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (words.size() > 0) {
            MorphAdornerLogger.println(loadedMessage, new Object[]{Formatters.formatIntegerWithCommas(words.getStringCount()), MorphAdorner.durationString(startTime)});
        }
        return words;
    }

    public static String[] getKWIC(List<AdornedWord> sentence, int wordIndex, int KWICWidth) {
        int i;
        AdornedWord adornedWord;
        String[] results = new String[3];
        StringBuffer KWICBuffer = new StringBuffer();
        AdornedWord KWICWord = sentence.get(wordIndex);
        int l = 0;
        int maxWidth = (KWICWidth - 4 - KWICWord.getToken().length()) / 2;
        for (i = wordIndex - 1; l < maxWidth && i >= 0; l += adornedWord.getToken().length() + 1, --i) {
            adornedWord = sentence.get(i);
            if (KWICBuffer.length() > 0) {
                KWICBuffer.insert(0, " ");
            }
            KWICBuffer.insert(0, adornedWord.getToken());
        }
        results[0] = KWICBuffer.toString();
        results[1] = KWICWord.getToken();
        KWICBuffer.setLength(0);
        int nWords = sentence.size();
        for (i = wordIndex + 1; KWICBuffer.length() < maxWidth && i < nWords; ++i) {
            AdornedWord adornedWord2 = sentence.get(i);
            KWICBuffer.append(adornedWord2.getToken());
            KWICBuffer.append(" ");
        }
        results[2] = KWICBuffer.toString();
        return results;
    }

    protected static int getWordCount(List sentences) {
        int result = 0;
        for (int i = 0; i < sentences.size(); ++i) {
            result += ((List)sentences.get(i)).size();
        }
        return result;
    }

    protected static int[] getWordAndSentenceCounts(List sentences) {
        int[] result = new int[]{0, 0};
        for (int i = 0; i < sentences.size(); ++i) {
            String word;
            List sentence = (List)sentences.get(i);
            int wordCount = sentence.size();
            boolean done = false;
            while (!done && (word = (String)sentence.get(wordCount - 1)).equals("\ue500")) {
                done = --wordCount < 1;
            }
            if (wordCount > 0) {
                result[0] = result[0] + 1;
            }
            result[1] = result[1] + wordCount;
        }
        return result;
    }

    public static String durationString(long startTime) {
        StringBuffer result = new StringBuffer();
        long duration = (System.currentTimeMillis() - startTime + 999L) / 1000L;
        String durationString = Formatters.formatLongWithCommas(duration);
        if (duration < 1L) {
            durationString = "< 1";
        }
        String secondString = duration > 1L ? "seconds" : "second";
        result.append(durationString);
        result.append(" ");
        result.append(MorphAdornerSettings.getString(secondString));
        result.append(".");
        return result.toString();
    }

    protected static void mergeXML(TextInputter inputter, String xmlFileName) {
        try {
            String entryText;
            String entryName;
            FileOutputStream outputStream = new FileOutputStream(new File(xmlFileName), false);
            BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedStream, "utf-8");
            SortedArrayList<String> entryNames = new SortedArrayList<String>();
            int nEntries = inputter.getSegmentCount();
            for (int i = 0; i < nEntries; ++i) {
                entryNames.add(inputter.getSegmentName(i));
            }
            String endText = "";
            for (int i = 0; i < entryNames.size(); ++i) {
                entryName = ((String)entryNames.get(i)).toString();
                entryText = inputter.getSegmentText(entryName);
                if (entryName.equals("head")) {
                    int iPos = StringUtils.indexOfIgnoreCase(entryText, "</eebo");
                    if (iPos < 0) {
                        iPos = entryText.indexOf("</TEI");
                    }
                    if (iPos >= 0) {
                        endText = entryText.substring(iPos);
                        entryText = entryText.substring(0, iPos);
                    }
                } else if (entryName.equals("text")) {
                    entryText = entryText.trim();
                    endText = (entryText = StringUtils.replaceAll(entryText, "/>", ">")).startsWith("<group") ? "</group>" + endText : (entryText.startsWith("<GROUP") ? "</GROUP>" + endText : (entryText.startsWith("<text") ? "</text>" + endText : "</TEXT>" + endText));
                    if (entryText.endsWith("</text>") || entryText.endsWith("</TEXT>")) {
                        entryText = entryText.substring(0, entryText.length() - 7);
                    }
                }
                while (entryText.endsWith(" >")) {
                    entryText = entryText.substring(0, entryText.length() - 2) + ">";
                }
                writer.write(entryText, 0, entryText.length());
            }
            endText = StringUtils.replaceAll(endText, " >", ">");
            writer.write(endText, 0, endText.length());
            writer.close();
            bufferedStream.close();
            outputStream.close();
            writer = null;
            bufferedStream = null;
            outputStream = null;
            entryNames = null;
            endText = null;
            entryName = null;
            entryText = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.gc();
    }

    public static String fixSpelling(String spelling) {
        String result = spelling;
        if (!result.equals("|")) {
            result = StringUtils.replaceAll(result, "|", "");
        }
        if (!result.equals("{")) {
            result = StringUtils.replaceAll(result, "{", "");
        }
        if (!result.equals("}")) {
            result = StringUtils.replaceAll(result, "}", "");
        }
        if (!result.equals("+")) {
            result = StringUtils.replaceAll(result, "+", "");
        }
        if (result.length() > 1 && result.charAt(0) == '_') {
            underlineCapCapMatcher.reset(result);
            if (underlineCapCapMatcher.find()) {
                String char1 = result.charAt(1) + "";
                String char2 = Character.toLowerCase(result.charAt(2)) + "";
                String rest = "";
                if (result.length() > 3) {
                    rest = result.substring(3);
                }
                result = char1 + char2 + rest;
            }
        }
        return result;
    }

    protected static String getLemma(Lemmatizer lemmatizer, String spelling, String partOfSpeech) {
        String result;
        block11: {
            String lemmaClass;
            block10: {
                result = spelling;
                lemmaClass = partOfSpeechTags.getLemmaWordClass(partOfSpeech);
                if (!lemmatizer.cantLemmatize(spelling) && !lemmaClass.equals("none")) break block10;
                if (!partOfSpeechTags.isNumberTag(partOfSpeech) || !RomanNumeralUtils.isLooseRomanNumeral(result)) break block11;
                if (result.charAt(0) == '.') {
                    result = result.substring(1);
                }
                if (result.charAt(result.length() - 1) != '.') break block11;
                result = result.substring(0, result.length() - 1);
                break block11;
            }
            boolean isCompoundTag = partOfSpeechTags.isCompoundTag(partOfSpeech);
            if (isCompoundTag && lemmatizer.isCompoundLemma(result = lemmatizer.lemmatize(spelling, "compound"))) {
                return result;
            }
            List<String> wordList = spellingTokenizer.extractWords(spelling);
            if (!isCompoundTag || wordList.size() == 1) {
                if (lemmaClass.length() == 0) {
                    result = lemmatizer.lemmatize(spelling, "compound");
                    if (result.equals(spelling)) {
                        result = lemmatizer.lemmatize(spelling);
                    }
                } else {
                    result = lemmatizer.lemmatize(spelling, lemmaClass);
                }
            } else {
                result = "";
                String lemmaPiece = "";
                String[] posTags = partOfSpeechTags.splitTag(partOfSpeech);
                if (posTags.length == wordList.size()) {
                    for (int i = 0; i < wordList.size(); ++i) {
                        String wordPiece = wordList.get(i);
                        if (i > 0) {
                            result = result + lemmaSeparator;
                        }
                        lemmaClass = partOfSpeechTags.getLemmaWordClass(posTags[i]);
                        lemmaPiece = lemmatizer.lemmatize(wordPiece, lemmaClass);
                        result = result + lemmaPiece;
                    }
                }
            }
        }
        return result;
    }

    protected static String getStandardizedSpelling(SpellingStandardizer standardizer, NameStandardizer nameStandardizer, String correctedSpelling, String standardizedSpelling, String partOfSpeech) {
        String spelling = correctedSpelling;
        String result = correctedSpelling;
        if (partOfSpeechTags.isProperNounTag(partOfSpeech)) {
            result = nameStandardizer.standardizeProperName(spelling);
        } else if (!(partOfSpeechTags.isNounTag(partOfSpeech) && CharUtils.hasInternalCaps(spelling) || partOfSpeechTags.isForeignWordTag(partOfSpeech))) {
            if (partOfSpeechTags.isNumberTag(partOfSpeech)) {
                if (RomanNumeralUtils.isLooseRomanNumeral(result)) {
                    if (result.charAt(0) == '.') {
                        result = result.substring(1);
                    }
                    if (result.charAt(result.length() - 1) == '.') {
                        result = result.substring(0, result.length() - 1);
                    }
                }
            } else {
                result = standardizer.standardizeSpelling(spelling, partOfSpeechTags.getMajorWordClass(partOfSpeech));
                if (result.equalsIgnoreCase(spelling)) {
                    result = spelling;
                }
            }
        }
        return result;
    }

    public static void fixEmptySoftTags(Document document) {
        List<Node> nodes = DOMUtils.getDescendants(document);
        for (Node node : nodes) {
            String text;
            if (!MorphAdornerSettings.xgOptions.isSoftTag(node.getNodeName()) || (text = DOMUtils.getText(node)).length() != 0) continue;
            DOMUtils.setText(node, " ");
        }
    }

    public static void fixSupTags(Document document) {
        List<Node> supNodes = DOMUtils.getDescendants(document, "sup");
        for (Node supNode : supNodes) {
            String loSupText;
            Node sibling;
            String supText = DOMUtils.getText(supNode);
            if (supText.startsWith("^") || (sibling = supNode.getPreviousSibling()) == null) continue;
            String siblingText = sibling.getTextContent();
            if (siblingText.endsWith(" y")) {
                loSupText = supText.toLowerCase();
                if (!loSupText.equals("e") && !loSupText.equals("t") && !loSupText.equals("c") && !loSupText.equals("en") && !loSupText.equals("ere") && !loSupText.equals("f") && !loSupText.equals("i") && !loSupText.equals("m") && !loSupText.equals("n") && !loSupText.equals("o") && !loSupText.equals("u")) continue;
                supText = "\ue503" + supText;
                DOMUtils.setText(supNode, supText);
                continue;
            }
            if (!siblingText.endsWith(" w") || !(loSupText = supText.toLowerCase()).equals("ch") && !loSupText.equals("t")) continue;
            supText = "\ue503" + supText;
            DOMUtils.setText(supNode, supText);
        }
    }

    public static int countPageBreaks(Document document) {
        List<Node> pbNodes = DOMUtils.getDescendants(document, "pb");
        return pbNodes.size();
    }

    public static void main(String[] args) {
        if (!MorphAdornerSettings.initialized) {
            MorphAdornerSettings.initializeSettings(args);
            try {
                MorphAdornerLogger.initialize("morphadornerlog.config", "/morphadorner/log");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                MorphAdornerSettings.getSettings(args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MorphAdornerLogger.println("programBanner");
            MorphAdornerLogger.println("Initializing_please_wait");
            MorphAdorner.initializeAdornment();
            MorphAdornerSettings.initialized = true;
        }
        if (MorphAdornerSettings.fileNames.length > 0) {
            MorphAdorner.processInputFiles();
        } else {
            MorphAdornerLogger.println("No_files_found_to_process");
        }
        MorphAdornerLogger.terminate();
    }

    protected MorphAdorner() {
    }

    static {
        names = new Names();
        tagSeparator = "|";
        lemmaSeparator = "|";
        runTime = Runtime.getRuntime();
    }
}

