/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import com.megginson.sax.XMLWriter;
import edu.northwestern.at.morphadorner.IDFixerFilter;
import edu.northwestern.at.morphadorner.MorphAdorner;
import edu.northwestern.at.morphadorner.MorphAdornerLogger;
import edu.northwestern.at.morphadorner.MorphAdornerSettings;
import edu.northwestern.at.morphadorner.MorphAdornerXMLWriter;
import edu.northwestern.at.morphadorner.SentenceAndWordNumber;
import edu.northwestern.at.morphadorner.SentenceNumberAdder;
import edu.northwestern.at.morphadorner.StripWordElementsFilter;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.SortedArrayList;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.utils.xml.IndentingXMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMorphAdornerXMLWriter
implements MorphAdornerXMLWriter {
    protected SortedArrayList<SentenceAndWordNumber> sortedWords = new SortedArrayList();
    protected XMLWriter writer;

    @Override
    public void writeXML(String inFile, String outFile, int maxID, PartOfSpeechTags posTags, Map<Integer, Integer> splitWords, int totalWords, int totalPageBreaks) throws IOException, SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        StripWordElementsFilter stripFilter = new StripWordElementsFilter(reader, MorphAdornerSettings.disallowWordElementsIn);
        IDFixerFilter idFilter = new IDFixerFilter(stripFilter, posTags, outFile, maxID, this.sortedWords, splitWords, totalWords, totalPageBreaks);
        boolean twoStep = MorphAdornerSettings.outputSentenceBoundaryMilestones || MorphAdornerSettings.outputSentenceNumber || MorphAdornerSettings.outputWordNumber;
        String tempFileName = "";
        if (twoStep) {
            File tempFile = File.createTempFile("mad", null);
            tempFile.deleteOnExit();
            tempFileName = tempFile.getAbsolutePath();
            MorphAdornerLogger.println("Using_two_step_output");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(twoStep ? tempFileName : outFile)), "utf-8");
        this.writer = new IndentingXMLWriter(idFilter, outputStreamWriter);
        ((IndentingXMLWriter)this.writer).setIndentStep(2);
        this.writer.setOutputCharsAsIs(true);
        this.writer.setDoctype(MorphAdornerSettings.xmlDoctypeName, MorphAdornerSettings.xmlDoctypeSystem);
        idFilter.setWriter(this.writer);
        long startTime = System.currentTimeMillis();
        this.writer.parse(inFile);
        if (twoStep) {
            MorphAdornerLogger.println("First_output_step_completed", MorphAdorner.durationString(startTime));
        }
        try {
            outputStreamWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (twoStep) {
            startTime = System.currentTimeMillis();
            this.getWordAndSentenceNumbers();
            new SentenceNumberAdder(tempFileName, outFile, this.sortedWords);
            FileUtils.deleteFile(tempFileName);
            MorphAdornerLogger.println("Second_output_step_completed", MorphAdorner.durationString(startTime));
        }
    }

    protected void getWordAndSentenceNumbers() {
        int sentenceNumber = 0;
        int wordNumber = 0;
        int runningWordNumber = 0;
        for (int i = 0; i < this.sortedWords.size(); ++i) {
            SentenceAndWordNumber swn = (SentenceAndWordNumber)this.sortedWords.get(i);
            if (swn.isFirstPart()) {
                if (wordNumber == 0) {
                    ++sentenceNumber;
                }
                ++wordNumber;
                ++runningWordNumber;
            }
            swn.setSentenceAndWordNumber(sentenceNumber, MorphAdornerSettings.outputRunningWordNumbers ? runningWordNumber : wordNumber);
            if (!swn.getEOS()) continue;
            wordNumber = 0;
        }
    }
}

