/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner;

import edu.northwestern.at.morphadorner.MorphAdornerSettings;
import edu.northwestern.at.morphadorner.WordAttributeNames;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWord;
import edu.northwestern.at.morphadorner.tools.ExtendedAdornedWordFilter;
import edu.northwestern.at.utils.xml.ExtendedXMLFilterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class AddWordAttributesFilter
extends ExtendedXMLFilterImpl {
    protected ExtendedAdornedWordFilter wordInfoFilter;
    protected boolean outputNonredundantAttributesOnly = false;
    protected boolean outputNonredundantTokenAttribute = false;
    protected boolean outputWhitespace = true;
    protected boolean outputWordNumber = false;
    protected boolean outputSentenceNumber = false;
    protected boolean outputWordOrdinal = false;

    public AddWordAttributesFilter(XMLReader reader, ExtendedAdornedWordFilter wordInfoFilter) {
        super(reader);
        this.wordInfoFilter = wordInfoFilter;
        this.outputNonredundantAttributesOnly = MorphAdornerSettings.outputNonredundantAttributesOnly;
        this.outputNonredundantTokenAttribute = MorphAdornerSettings.outputNonredundantTokenAttribute;
        this.outputWhitespace = MorphAdornerSettings.outputWhitespaceElements;
        this.outputSentenceNumber = MorphAdornerSettings.outputSentenceNumber;
        this.outputWordNumber = MorphAdornerSettings.outputWordNumber;
        this.outputWordOrdinal = MorphAdornerSettings.outputWordOrdinal;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        AttributesImpl newAtts = new AttributesImpl(atts);
        String teiform = newAtts.getValue("TEIform");
        if (teiform != null && teiform.length() > 0) {
            this.removeAttribute(newAtts, "TEIform");
        }
        if (qName.equals("w")) {
            String id = newAtts.getValue(WordAttributeNames.id);
            ExtendedAdornedWord wordInfo = this.wordInfoFilter.getExtendedAdornedWord(id);
            String tok = wordInfo.getToken();
            String spe = wordInfo.getSpelling();
            String pos = wordInfo.getPartsOfSpeech();
            boolean eos = wordInfo.getEOS();
            String lem = wordInfo.getLemmata();
            String reg = wordInfo.getStandardSpelling();
            int ord = wordInfo.getOrd();
            String part = wordInfo.getPart();
            String wordText = wordInfo.getWordText();
            this.setAttributeValue(newAtts, WordAttributeNames.id, id);
            this.setAttributeValue(newAtts, WordAttributeNames.eos, eos);
            this.setAttributeValue(newAtts, WordAttributeNames.lem, lem);
            if (this.outputWordOrdinal) {
                this.setAttributeValue(newAtts, WordAttributeNames.ord, ord);
            } else {
                this.removeAttribute(newAtts, WordAttributeNames.ord);
            }
            this.setAttributeValue(newAtts, WordAttributeNames.part, part);
            this.setAttributeValue(newAtts, WordAttributeNames.pos, pos);
            this.setAttributeValue(newAtts, WordAttributeNames.reg, reg);
            if (this.outputSentenceNumber) {
                this.setAttributeValue(newAtts, WordAttributeNames.sn, wordInfo.getSentenceNumber());
            } else {
                this.removeAttribute(newAtts, WordAttributeNames.sn);
            }
            this.setAttributeValue(newAtts, WordAttributeNames.spe, spe);
            this.setAttributeValue(newAtts, WordAttributeNames.tok, tok);
            if (this.outputWordNumber) {
                this.setAttributeValue(newAtts, WordAttributeNames.wn, wordInfo.getWordNumber());
            } else {
                this.removeAttribute(newAtts, WordAttributeNames.sn);
            }
            if (this.outputNonredundantAttributesOnly) {
                if (!eos) {
                    this.removeAttribute(newAtts, WordAttributeNames.eos);
                }
                if (spe.equals(tok)) {
                    this.removeAttribute(newAtts, WordAttributeNames.spe);
                }
                if (lem.equals(spe)) {
                    this.removeAttribute(newAtts, WordAttributeNames.lem);
                }
                if (pos.equals(spe)) {
                    this.removeAttribute(newAtts, WordAttributeNames.pos);
                }
                if (reg.equals(spe)) {
                    this.removeAttribute(newAtts, WordAttributeNames.reg);
                }
                if (part != null && part.equals("N")) {
                    this.removeAttribute(newAtts, WordAttributeNames.part);
                }
                if (tok.equals(wordText)) {
                    this.removeAttribute(newAtts, WordAttributeNames.tok);
                }
            } else if (this.outputNonredundantTokenAttribute && tok.equals(wordText)) {
                this.removeAttribute(newAtts, WordAttributeNames.tok);
            }
            super.startElement(uri, localName, qName, newAtts);
        } else if (qName.equals("c")) {
            this.removeAttribute(newAtts, WordAttributeNames.part);
            if (this.outputWhitespace) {
                super.startElement(uri, localName, qName, newAtts);
            }
        } else {
            super.startElement(uri, localName, qName, newAtts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("c")) {
            if (this.outputWhitespace) {
                super.endElement(uri, localName, qName);
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }
}

