/*
 * Decompiled with CFR 0.152.
 */
package de.spieleck.util;

import java.util.Comparator;

public class PriorityQueue {
    protected int size;
    protected Object[] heap;
    protected Comparator myComp;

    public PriorityQueue(int initialSize, Comparator comp) {
        this.myComp = comp;
        this.initialize(initialSize);
    }

    protected boolean lessThan(Object a, Object b) {
        return this.myComp.compare(a, b) < 0;
    }

    public void setComparator(Comparator comp) {
        this.myComp = comp;
        this.resort();
    }

    protected final void initialize(int initialSize) {
        this.size = 0;
        int heapSize = initialSize;
        this.heap = new Object[heapSize];
    }

    public final void put(Object element) {
        ++this.size;
        if (this.size >= this.heap.length) {
            Object[] newHeap = new Object[2 * this.heap.length];
            for (int i = 1; i < this.size; ++i) {
                newHeap[i] = this.heap[i];
                this.heap[i] = null;
            }
            this.heap = newHeap;
        }
        this.heap[this.size] = element;
        this.upHeap();
    }

    public final void setTop(Object element) {
        this.heap[1] = element;
        this.adjustTop();
    }

    public final Object top() {
        if (this.size > 0) {
            return this.heap[1];
        }
        return null;
    }

    public final Object pop() {
        if (this.size > 0) {
            Object result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
            this.downHeap(1);
            return result;
        }
        return null;
    }

    public final void adjustTop() {
        this.downHeap(1);
    }

    public final int getSize() {
        return this.size;
    }

    public final int getCapacity() {
        return this.heap.length;
    }

    public final void clear() {
        for (int i = 1; i < this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    public void resort() {
        for (int i = this.size / 2; i > 1; --i) {
            this.downHeap(i);
        }
    }

    protected final void upHeap() {
        int i = this.size;
        Object node = this.heap[i];
        for (int j = i >>> 1; j > 0 && this.lessThan(node, this.heap[j]); j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = node;
    }

    protected final void downHeap(int top) {
        int i = top;
        Object node = this.heap[i];
        int j = i << 1;
        int k = j + 1;
        if (k <= this.size && this.lessThan(this.heap[k], this.heap[j])) {
            j = k;
        }
        while (j <= this.size && this.lessThan(this.heap[j], node)) {
            this.heap[i] = this.heap[j];
            i = j;
            k = (j = i << 1) + 1;
            if (k > this.size || !this.lessThan(this.heap[k], this.heap[j])) continue;
            j = k;
        }
        this.heap[i] = node;
    }
}

