/*
 * Decompiled with CFR 0.152.
 */
package de.spieleck.util;

import java.util.Enumeration;
import java.util.Iterator;

public class IntMap {
    public static final int NULL = Integer.MIN_VALUE;
    protected Object[] keys;
    protected int nullValue;
    protected int[] values;
    protected int size;
    protected int mask;
    protected int limit;

    public IntMap() {
        this(16);
    }

    public IntMap(int size) {
        this(size, Integer.MIN_VALUE);
    }

    public IntMap(int size, int nullValue) {
        if (size < 8) {
            size = 8;
        }
        int z = 0;
        while (size > 1) {
            ++z;
            size /= 2;
        }
        size = 2 << z;
        this.keys = new Object[size];
        this.values = new int[size];
        this.mask = this.keys.length - 1;
        this.limit = 3 * this.keys.length / 4;
        size = 0;
        this.nullValue = nullValue;
    }

    public int getNullValue() {
        return this.nullValue;
    }

    protected int firstIndex(Object key) {
        return key.hashCode() & this.mask;
    }

    protected int nextIndex(int index) {
        return index + 5 & this.mask;
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.keys[i] = null;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int getElement(Object key) {
        return this.get(key);
    }

    public int get(Object key) {
        if (key == null) {
            return this.nullValue;
        }
        int i = this.firstIndex(key);
        while (this.keys[i] != null) {
            if (this.keys[i] == key || key.equals(this.keys[i])) {
                return this.values[i];
            }
            i = this.nextIndex(i);
        }
        return this.nullValue;
    }

    public int inc(Object key) {
        return this.add(key, 1);
    }

    public int dec(Object key) {
        return this.add(key, -1);
    }

    public int add(Object key, int off) {
        if (key == null) {
            return this.nullValue;
        }
        int i = this.firstIndex(key);
        while (this.keys[i] != null) {
            if (this.keys[i] == key || key.equals(this.keys[i])) {
                int n = i;
                this.values[n] = this.values[n] + off;
                return this.values[i];
            }
            i = this.nextIndex(i);
        }
        return this.nullValue;
    }

    protected void grow() {
        int newSize = 2 * this.keys.length;
        Object[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.keys = new Object[newSize];
        this.values = new int[newSize];
        this.mask = newSize - 1;
        this.size = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == null) continue;
            this.internalPut(oldKeys[i], oldValues[i]);
        }
        this.limit = 3 * newSize / 4;
    }

    public int putElement(Object key, int value) {
        return this.put(key, value);
    }

    public int put(Object key, int value) {
        if (key == null) {
            return this.nullValue;
        }
        if (this.size >= this.limit) {
            this.grow();
        }
        return this.internalPut(key, value);
    }

    protected int internalPut(Object key, int value) {
        int i = this.firstIndex(key);
        while (true) {
            Object testKey;
            if ((testKey = this.keys[i]) == null) {
                this.keys[i] = key;
                this.values[i] = value;
                ++this.size;
                return this.nullValue;
            }
            if (key == testKey || testKey.equals(key)) {
                int old = this.values[i];
                this.values[i] = value;
                return old;
            }
            i = this.nextIndex(i);
        }
    }

    public int remove(Object key) {
        if (key == null || this.size == 0) {
            return this.nullValue;
        }
        int i = this.firstIndex(key);
        while (this.keys[i] != null) {
            Object testKey = this.keys[i];
            if (key == testKey || key.equals(testKey)) {
                int value = this.values[i];
                do {
                    int r;
                    this.keys[i] = null;
                    int j = i;
                    while (this.keys[i = this.nextIndex(i)] != null && (i <= (r = this.firstIndex(this.keys[i])) && r < j || r < j && j < i || j < i && i <= r)) {
                    }
                    this.keys[j] = this.keys[i];
                    this.values[j] = this.values[i];
                } while (this.keys[i] != null);
                --this.size;
                return value;
            }
            i = this.nextIndex(i);
        }
        return this.nullValue;
    }

    public Enumeration keys() {
        return new IntMapEnumeration();
    }

    public Iterator iterator() {
        return new IntMapIterator();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("IntMap[");
        boolean isFirst = true;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            if (!isFirst) {
                sbuf.append(", ");
            }
            isFirst = false;
            sbuf.append(this.keys[i]);
            sbuf.append(":");
            sbuf.append(this.values[i]);
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    private class IntMapIterator
    implements Iterator {
        protected int index = 0;

        private IntMapIterator() {
        }

        public boolean hasNext() {
            while (this.index < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.index] != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object next() {
            while (this.index < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.index] != null) {
                    return IntMap.this.keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("IntMapIterator.remove()");
        }
    }

    private class IntMapEnumeration
    implements Enumeration {
        protected int index = 0;

        private IntMapEnumeration() {
        }

        public boolean hasMoreElements() {
            while (this.index < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.index] != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object nextElement() {
            while (this.index < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.index] != null) {
                    return IntMap.this.keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }
    }
}

