/*
 * Decompiled with CFR 0.152.
 */
package de.spieleck.app.cngram;

import de.spieleck.app.cngram.NGramMetric;
import de.spieleck.app.cngram.NGramProfileImpl;
import de.spieleck.app.cngram.NGramProfiles;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.text.DecimalFormat;

public class RunNGram {
    public static final int CREATE = 1;
    public static final int SIMILARITY = 2;
    public static final int SCORE = 3;
    public static final int LANG = 4;
    public static final int TEST = 5;
    public static final int LANG2 = 6;
    public static final int LANG2B = 7;
    public static final int CHECK = 8;
    public static final int PROFILES = 9;
    public static final DecimalFormat DF = new DecimalFormat("0.000");
    public static final DecimalFormat DFE = new DecimalFormat("0.0E0");

    private static void usage(PrintStream out) {
        out.println("Usage: RunNGram commandset");
        out.println("          [-create profilename(out) textfile [encoding]]");
        out.println("   or     [-similarity metricName textfile1 textfile2 [encoding]]");
        out.println("   or     [-score metricName profile-name textfile [encoding]]");
        out.println("   or     [-lang metricName textfile [encoding]]");
        out.println("   or     [-test ]");
        out.println("   or     [-lang2 textfile [encoding]]");
        out.println("   or     [-lang2b textfile [encoding]]");
        out.println("   or     [-check textlistFile]");
        out.println("   or     [-profiles metricName profile1 profile2]");
        System.exit(42);
    }

    public static void main(String[] args) throws Exception {
        int command = 0;
        if (args.length == 0) {
            RunNGram.usage(System.out);
        }
        block6: for (int i = 0; i < args.length; ++i) {
            String profilename = "";
            String profilename2 = "";
            String textfile = "";
            String filename2 = "";
            String metricName = null;
            NGramMetric metric = null;
            String encoding = "";
            if ("-c".equals(args[i]) || "-create".equals(args[i])) {
                command = 1;
                profilename = args[++i];
                textfile = args[++i];
            } else if ("-i".equals(args[i]) || "-similarity".equals(args[i])) {
                command = 2;
                metricName = args[++i];
                metric = (NGramMetric)Class.forName(metricName).newInstance();
                textfile = args[++i];
                filename2 = args[++i];
            } else if ("-s".equals(args[i]) || args[i].equals("-score")) {
                command = 3;
                metricName = args[++i];
                metric = (NGramMetric)Class.forName(metricName).newInstance();
                profilename = args[++i];
                textfile = args[++i];
            } else if ("-p".equals(args[i]) || "-profiles".equals(args[i])) {
                command = 9;
                metricName = args[++i];
                metric = (NGramMetric)Class.forName(metricName).newInstance();
                profilename = args[++i];
                profilename2 = args[++i];
            } else if ("-l".equals(args[i]) || "-lang".equals(args[i])) {
                command = 4;
                metricName = args[++i];
                metric = (NGramMetric)Class.forName(metricName).newInstance();
                textfile = args[++i];
            } else if ("-l2".equals(args[i]) || "-lang2".equals(args[i])) {
                command = 6;
                textfile = args[++i];
            } else if ("-l2b".equals(args[i]) || "-lang2b".equals(args[i])) {
                command = 7;
                textfile = args[++i];
            } else if ("-x".equals(args[i]) || "-check".equals(args[i])) {
                command = 8;
                textfile = args[++i];
            } else if ("-t".equals(args[i]) || "-test".equals(args[i])) {
                command = 5;
            } else {
                RunNGram.usage(System.err);
            }
            encoding = i + 1 < args.length && args[i].charAt(0) != '-' ? args[++i] : "iso-8859-1";
            if (command == 5) {
                NGramProfiles npi = new NGramProfiles();
                npi.info();
                continue;
            }
            if (command == 6 || command == 7) {
                long t1 = System.currentTimeMillis();
                NGramProfiles nps = new NGramProfiles();
                NGramProfiles.Ranker ranker = nps.getRanker();
                ranker.account(RunNGram.createReader(textfile, encoding));
                NGramProfiles.RankResult res = ranker.getRankResult();
                long t2 = System.currentTimeMillis();
                RunNGram.printRankResult("speed", res, t2 - t1);
                if (command != 7) continue;
                t1 = t2;
                ranker.reset();
                ranker.account(RunNGram.createReader(textfile, encoding));
                res = ranker.getRankResult();
                t2 = System.currentTimeMillis();
                RunNGram.printRankResult("speed", res, t2 - t1);
                continue;
            }
            if (command == 8) {
                String line;
                NGramProfiles npi = new NGramProfiles();
                NGramProfiles.Ranker ranker = npi.getRanker();
                File fi = new File(textfile);
                BufferedReader br = new BufferedReader(new FileReader(fi));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).charAt(0) == '#') continue;
                    String[] ss = line.split(";");
                    long t1 = System.currentTimeMillis();
                    ranker.reset();
                    ranker.account(RunNGram.createReader(ss[0], ss[1]));
                    long t2 = System.currentTimeMillis();
                    NGramProfiles.RankResult res = ranker.getRankResult();
                    RunNGram.printRankResult(ss[0], res, t2 - t1);
                }
                continue;
            }
            if (command == 9) {
                File f2 = new File(profilename);
                FileInputStream fis = new FileInputStream(f2);
                NGramProfileImpl comp1 = new NGramProfileImpl(profilename);
                comp1.load(fis);
                File f3 = new File(profilename2);
                fis = new FileInputStream(f3);
                NGramProfileImpl comp2 = new NGramProfileImpl(profilename2);
                comp2.load(fis);
                System.out.println("diff(" + profilename + ":" + profilename2 + ")=" + DFE.format(metric.diff(comp1, comp2)));
                continue;
            }
            long t1 = System.currentTimeMillis();
            NGramProfileImpl newProf = RunNGram.create(textfile, encoding);
            long t2 = System.currentTimeMillis();
            switch (command) {
                case 1: {
                    String fname = profilename + "." + "ngp";
                    File f = new File(fname);
                    FileOutputStream fos = new FileOutputStream(f);
                    newProf.save(fos);
                    System.out.println("new profile '" + fname + "' was created.");
                    continue block6;
                }
                case 2: {
                    NGramProfileImpl newProf2 = RunNGram.create(filename2, encoding);
                    System.out.println("Difference is " + DFE.format(metric.diff(newProf, newProf2)));
                    continue block6;
                }
                case 3: {
                    File f2 = new File(profilename + "." + "ngp");
                    FileInputStream fis = new FileInputStream(f2);
                    NGramProfileImpl compare = new NGramProfileImpl(profilename);
                    compare.load(fis);
                    System.out.println("Score (" + profilename + ") is " + DFE.format(metric.diff(compare, newProf)));
                    continue block6;
                }
                case 4: {
                    NGramProfiles nps = new NGramProfiles();
                    long dt1 = t2 - t1;
                    t1 = System.currentTimeMillis();
                    NGramProfiles.RankResult res = nps.rank(metric, newProf);
                    t2 = System.currentTimeMillis();
                    int ppos = metricName.lastIndexOf(".");
                    RunNGram.printRankResult(metricName.substring(ppos + 1) + "(" + dt1 + ")", res, t2 - t1);
                }
            }
        }
    }

    public static Reader createReader(String textfile, String encoding) throws IOException {
        return new UnicodeReader(new BufferedInputStream(new FileInputStream(textfile)), encoding);
    }

    public static void printRankResult(String msg, NGramProfiles.RankResult res, long dt) {
        System.out.println(msg + ": " + res.getName(0) + ":" + DF.format(res.getScore(0)) + " " + res.getName(1) + ":" + DF.format(res.getScore(1)) + " " + res.getName(2) + ":" + DF.format(res.getScore(2)) + " .. " + res.getName(-1) + ":" + DF.format(res.getScore(-1)) + " |" + DFE.format(res.getScore(1) / res.getScore(0)) + " |" + DFE.format(res.getScore(-1) / res.getScore(0)) + " dt=" + dt);
    }

    public static NGramProfileImpl create(String textfile, String encoding) throws IOException {
        File f = new File(textfile);
        FileInputStream fis = new FileInputStream(f);
        NGramProfileImpl prof = NGramProfileImpl.createProfile(textfile, fis, encoding);
        fis.close();
        return prof;
    }
}

