/*
 * Decompiled with CFR 0.152.
 */
package de.spieleck.app.cngram;

import de.spieleck.app.cngram.CosMetric;
import de.spieleck.app.cngram.NGram;
import de.spieleck.app.cngram.NGramMetric;
import de.spieleck.app.cngram.NGramProfile;
import de.spieleck.app.cngram.NGramProfileImpl;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NGramProfiles {
    public static final String NOLANGNAME = "--";
    public static final char END_CHAR = '\u0000';
    public static final DecimalFormat DF = new DecimalFormat("+0.00;-0.00");
    public static final double LOWSTATSAFETY = 0.5;
    private List profiles = null;
    private HashSet allNGrams = new HashSet(10000);
    private int firstNGrams;
    private int maxLen = -1;
    private Trie myTrie = null;
    private float[][] vals;
    private int mode;
    protected static final String langProfilesResourcePath = "resources/";

    public NGramProfiles() throws IOException {
        this(1);
    }

    public NGramProfiles(int mode) throws IOException {
        InputStream ip = this.getClass().getResourceAsStream("resources/profiles.lst");
        BufferedReader br = new BufferedReader(new UnicodeReader(ip));
        this.mode = mode;
        this.init(br);
    }

    public NGramProfiles(BufferedReader br) throws IOException {
        this.init(br);
    }

    public NGramProfiles(List langs) throws IOException {
        this.mode = 1;
        this.profiles = new ArrayList();
        this.firstNGrams = 0;
        for (int i = 0; i < langs.size(); ++i) {
            String line = langs.get(i).toString();
            if (line.charAt(0) == '#') continue;
            InputStream is = this.getClass().getResourceAsStream(langProfilesResourcePath + line + "." + "ngp");
            NGramProfileImpl np = new NGramProfileImpl(line);
            np.load(is);
            this.profiles.add(np);
            Iterator iter = np.getSorted();
            while (iter.hasNext()) {
                NGram ng = (NGram)iter.next();
                if (ng.length() > this.maxLen) {
                    this.maxLen = ng.length();
                }
                ++this.firstNGrams;
                this.allNGrams.add(ng);
            }
        }
        this.myTrie = null;
    }

    protected void init(BufferedReader br) throws IOException {
        String line;
        this.profiles = new ArrayList();
        this.firstNGrams = 0;
        while ((line = br.readLine()) != null) {
            if (line.charAt(0) == '#') continue;
            InputStream is = this.getClass().getResourceAsStream(langProfilesResourcePath + line + "." + "ngp");
            NGramProfileImpl np = new NGramProfileImpl(line);
            np.load(is);
            this.profiles.add(np);
            Iterator iter = np.getSorted();
            while (iter.hasNext()) {
                NGram ng = (NGram)iter.next();
                if (ng.length() > this.maxLen) {
                    this.maxLen = ng.length();
                }
                ++this.firstNGrams;
                this.allNGrams.add(ng);
            }
        }
        this.myTrie = null;
    }

    public void info() {
        System.err.println("#profiles=" + this.profiles.size() + ", firstNGrams=" + this.firstNGrams + ", secondNGrams=" + this.allNGrams.size() + ", maxLen=" + this.maxLen + ", mode=" + this.mode);
        CosMetric cm = new CosMetric();
        for (NGramProfile p1 : this.profiles) {
            System.out.print("# " + p1.getName());
            for (NGramProfile p2 : this.profiles) {
                System.out.print(" ");
                System.out.print(DF.format(1.0 - cm.diff(p1, p2)));
            }
            System.out.println();
        }
        Ranker r = this.getRanker();
        NGramProfiles.check(r, "Das ist cool men!");
        NGramProfiles.check(r, "Les Ordinateurs sont appeles a jouer un role");
        NGramProfiles.check(r, "Sein oder Nichtsein, das ist hier die Frage!");
        NGramProfiles.check(r, "Zu Ihren Aufgaben z\u00e4hlen u. a. die Einf\u00fchrung und Erprobung neuer Technologien, die Erarbeitung von Rationalisierungsl\u00f6sungen f\u00fcr die Fertigung sowie die Erarbeitung und Durchf\u00fchrung von Technologieversuchen bei der Mustererstellung mit Hinblick auf die Serienfertigung. Desweiteren sind Sie f\u00fcr die Betreuung und Durchf\u00fchrung von Entwicklungsprojekten sowie die Erarbeitung und konstruktive Auslegung von Werkzeugen, Vorrichtungen und Automatisierungseinrichtungen zust\u00e4ndig. Sie sind Ansprechpartner f\u00fcr die Zusammenarbeit und Betreuung von externen Lieferanten bei der Konstruktion und der Herstellung von Maschinen und Vorrichtungen. Sie leiten qualit\u00e4tsverbessernde Ma\u00dfnahmen im Prozess und in der Fertigung ein und sind f\u00fcr die kostenbewusste und zukunftsweisende Planung des Bereiches verantwortlich. Zudem f\u00fchren Sie Ihre Mitarbeiter zielgerichtet entsprechend der INA-F\u00fchrungsleitlinien.");
        NGramProfiles.check(r, "Sein oder Nichtsein, das ist hier die Frage! To be or not to be, that is the question!");
        NGramProfiles.check(r, "Sein oder Nichtsein, das ist hier die Frage! To be or not to be, that is the question! Sein oder Nichtsein, das ist hier die Frage! To be or not to be, that is the question!");
        NGramProfiles.check(r, "Marcel Andre Casasola Merkle");
        NGramProfiles.check(r, "question");
        NGramProfiles.check(r, "methodist");
    }

    public static void check(Ranker r, CharSequence seq) {
        System.out.println("## \"" + seq + "\": ");
        r.reset();
        long t1 = System.currentTimeMillis();
        r.account(seq);
        long t2 = System.currentTimeMillis();
        RankResult rs = r.getRankResult();
        double sum = 0.0;
        for (int i = 0; i < rs.getLength(); ++i) {
            if (!(rs.getScore(i) > 0.0)) continue;
            System.out.println("  " + rs.getName(i) + " " + DF.format(rs.getScore(i)) + " " + (i + 1));
            sum += rs.getScore(i);
        }
        System.out.println("#===== took=" + (t2 - t1) + "ms: " + DF.format(1.0 * (double)(t2 - t1) / (double)seq.length()) + "ms/ch. other=" + DF.format(1.0 - sum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ranker getRanker() {
        int[] otherCount = new int[this.maxLen + 1];
        if (this.myTrie == null) {
            List list = this.profiles;
            synchronized (list) {
                if (this.myTrie == null) {
                    Object[] ngs = new String[this.allNGrams.size()];
                    Iterator it = this.allNGrams.iterator();
                    int j = 0;
                    while (it.hasNext()) {
                        NGram ng = (NGram)it.next();
                        ngs[j++] = NGramProfiles.reverse(ng);
                    }
                    Arrays.sort(ngs);
                    String[] ng1 = new String[this.allNGrams.size()];
                    for (int i = 0; i < ngs.length; ++i) {
                        ng1[i] = NGramProfiles.reverse((CharSequence)ngs[i]);
                    }
                    this.myTrie = NGramProfiles.createTrie((String[])ngs, 0, 0, ngs.length);
                    this.vals = new float[ngs.length][this.profiles.size()];
                    int[] lengthes = new int[ngs.length];
                    for (int k = 0; k < this.profiles.size(); ++k) {
                        int ngl;
                        NGram ng;
                        int i;
                        NGramProfile ngp = (NGramProfile)this.profiles.get(k);
                        double[] norm = new double[this.maxLen + 1];
                        int[] count = new int[this.maxLen + 1];
                        for (i = 0; i < ngs.length; ++i) {
                            ng = ngp.get(ng1[i]);
                            if (ng == null || !((double)ng.getCount() > 0.5)) continue;
                            lengthes[i] = ngl = ng.length();
                            double raw1 = (double)ng.getCount() - 0.5;
                            int n = ngl;
                            count[n] = count[n] + 1;
                            int n2 = ngl;
                            norm[n2] = norm[n2] + raw1;
                            this.vals[i][k] = (float)raw1;
                        }
                        i = 1;
                        while (i <= this.maxLen) {
                            int n = i;
                            norm[n] = norm[n] * ((1.0 + (double)count[i]) / (double)count[i]);
                            int n3 = i++;
                            norm[n3] = norm[n3] + 1.0;
                        }
                        for (i = 0; i < ngs.length; ++i) {
                            ng = ngp.get(ng1[i]);
                            if (ng == null || ng.getCount() <= 0) continue;
                            ngl = ng.length();
                            double trans = (double)this.vals[i][k] / norm[ngl];
                            this.vals[i][k] = (float)trans;
                        }
                    }
                    for (int i = 0; i < ngs.length; ++i) {
                        double sum = 0.0;
                        for (int k = 0; k < this.profiles.size(); ++k) {
                            double h2 = this.vals[i][k];
                            sum += h2;
                        }
                        double av = sum / (double)this.profiles.size();
                        double n = this.modeTrans(av, ng1[i].length()) / av / 100.0 * -Math.log(av);
                        for (int k = 0; k < this.profiles.size(); ++k) {
                            this.vals[i][k] = (float)(((double)this.vals[i][k] - av) * n);
                        }
                    }
                }
            }
        }
        return new Ranker(){
            private double[] score;
            private double[] rscore;
            private boolean flushed;
            {
                this.score = new double[NGramProfiles.this.profiles.size() + 1];
                this.rscore = new double[NGramProfiles.this.profiles.size() + 1];
                this.flushed = false;
                this.reset();
            }

            public RankResult getRankResult() {
                int i;
                this.flush();
                double[] pscore = new double[NGramProfiles.this.profiles.size()];
                double sum = 0.0;
                for (i = 0; i <= NGramProfiles.this.profiles.size(); ++i) {
                    sum += this.rscore[i];
                }
                for (i = 0; i < NGramProfiles.this.profiles.size(); ++i) {
                    pscore[i] = this.rscore[i] / sum;
                }
                return new SimpleRankResult(pscore, true);
            }

            public void reset() {
                for (int i = 0; i < this.score.length; ++i) {
                    this.score[i] = 0.0;
                    this.rscore[i] = 0.0;
                }
                this.score[this.score.length - 1] = 0.0;
                this.rscore[this.score.length - 1] = 0.5;
            }

            public void flush() {
                if (!this.flushed) {
                    this.flushed = true;
                    double maxValue = -1.0;
                    for (int i = 0; i < this.score.length; ++i) {
                        maxValue = Math.max(maxValue, this.score[i]);
                    }
                    double limit = maxValue / 2.0;
                    double f = 1.0 / (maxValue - limit);
                    int i = 0;
                    while (i < this.score.length) {
                        double delta = this.score[i] - limit;
                        if (delta > 0.0) {
                            int n = i;
                            this.rscore[n] = this.rscore[n] + delta * f;
                        }
                        int n = i++;
                        this.score[n] = this.score[n] / 2.0;
                    }
                }
            }

            public void account(CharSequence seq, int pos) {
                Trie currentNode = NGramProfiles.this.myTrie;
                int p2 = pos;
                while (currentNode != null) {
                    int ch;
                    if (p2 == -1) {
                        ch = 32;
                    } else {
                        ch = Character.toLowerCase(seq.charAt(p2));
                        if (NGramProfiles.isSeparator((char)ch)) {
                            ch = 32;
                        }
                    }
                    Trie t2 = currentNode.subtree((char)ch);
                    if (t2 == null) break;
                    if (t2.id >= 0) {
                        this.flushed = false;
                        for (int i = 0; i < NGramProfiles.this.profiles.size(); ++i) {
                            int n = i;
                            this.score[n] = this.score[n] + (double)NGramProfiles.this.vals[t2.id][i];
                        }
                    }
                    if (p2-- == -1) break;
                    currentNode = t2.center;
                }
                char startChar = seq.charAt(pos);
                boolean startSep = NGramProfiles.isSeparator(startChar);
                double max = 0.0;
                for (int i = 0; i < this.score.length; ++i) {
                    max = Math.max(max, this.score[i]);
                }
                if (startSep && max > 1.0) {
                    this.flush();
                }
            }

            public void account(CharSequence seq) {
                for (int i = 0; i < seq.length(); ++i) {
                    this.account(seq, i);
                }
            }

            public void account(Reader reader) throws IOException {
                String line;
                BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
                while ((line = br.readLine()) != null) {
                    this.account(line);
                }
            }
        };
    }

    public double modeTrans(double x, int l) {
        switch (this.mode) {
            case 1: 
            case 10: {
                if (l == 1) {
                    return x;
                }
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x / f, f);
            }
            case 9: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 8: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 7: {
                double f = 1.0 / (double)(l + 1);
                return Math.pow(x, f) / f;
            }
            case 6: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f) / Math.sqrt(f);
            }
            case 5: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f) / f;
            }
            case 3: {
                double f = 1.0 / (double)l;
                return Math.pow(x, f);
            }
            case 2: {
                double f = 1.0 / (double)l;
                return Math.pow(x / f, f);
            }
            case 4: {
                double f = 1.0 / (double)l;
                return Math.pow(x * f, f);
            }
        }
        return x;
    }

    public String getProfileName(int i) {
        if (i < 0 || i >= this.profiles.size()) {
            return NOLANGNAME;
        }
        return ((NGramProfile)this.profiles.get(i)).getName();
    }

    public static boolean isSeparator(char ch) {
        return ch <= ' ' || Character.isWhitespace(ch) || Character.isDigit(ch) || ".!?:,;".indexOf(ch) >= 0;
    }

    public static String reverse(CharSequence seq) {
        StringBuilder sb = new StringBuilder(seq.length());
        for (int i = 0; i < seq.length(); ++i) {
            sb.insert(0, seq.charAt(i));
        }
        return sb.toString();
    }

    private static void printTrie(String indent, int w, Trie trie, String seq) {
        if (--w <= 0) {
            return;
        }
        if (trie == null) {
            return;
        }
        if (trie.split == '\u0000') {
            System.out.println(indent + "<" + trie.split + ">[" + seq + "]");
        } else {
            System.out.println(indent + "<" + trie.split + ">");
            NGramProfiles.printTrie(indent + " c", w, trie.center, trie.split + seq);
            NGramProfiles.printTrie(indent + "l", w, trie.left, seq);
            NGramProfiles.printTrie(indent + "r", w, trie.right, seq);
        }
    }

    private static Trie createTrie(String[] array, int pos, int start, int end) {
        int goLeft;
        int goRight;
        if (start >= end) {
            return null;
        }
        int mid = (start + end) / 2;
        Trie nt = new Trie();
        nt.split = array[mid].charAt(pos);
        for (goRight = mid; goRight < end && NGramProfiles.charAt(array[goRight], pos) == nt.split; ++goRight) {
        }
        for (goLeft = mid; goLeft > start && NGramProfiles.charAt(array[goLeft - 1], pos) == nt.split; --goLeft) {
        }
        int goLeft2 = goLeft;
        if (array[goLeft].length() == pos + 1) {
            nt.id = goLeft;
            ++goLeft2;
        }
        nt.center = NGramProfiles.createTrie(array, pos + 1, goLeft2, goRight);
        nt.left = NGramProfiles.createTrie(array, pos, start, goLeft);
        nt.right = NGramProfiles.createTrie(array, pos, goRight, end);
        return nt;
    }

    public static final char charAt(CharSequence cs, int pos) {
        if (pos < cs.length()) {
            return cs.charAt(pos);
        }
        return '\u0000';
    }

    public static char sc(char c) {
        return c == '\u0000' ? (char)'?' : (char)c;
    }

    public RankResult rank(NGramMetric metric, NGramProfile profile) {
        Iterator it = this.profiles.iterator();
        Object res = null;
        double[] scores = new double[this.profiles.size()];
        for (int i = 0; i < this.profiles.size(); ++i) {
            scores[i] = metric.diff(profile, (NGramProfile)this.profiles.get(i));
        }
        return new SimpleRankResult(scores, false);
    }

    public int getProfileCount() {
        return this.profiles.size();
    }

    public Set getAllNGrams() {
        return this.allNGrams;
    }

    public static interface Ranker {
        public RankResult getRankResult();

        public void reset();

        public void flush();

        public void account(CharSequence var1, int var2);

        public void account(CharSequence var1);

        public void account(Reader var1) throws IOException;
    }

    public static interface RankResult {
        public NGramProfiles getProfiles();

        public int getLength();

        public double getScore(int var1);

        public String getName(int var1);
    }

    private class SimpleRankResult
    implements RankResult {
        private double[] scores;
        private NGramProfile[] profs;
        private double remain;

        public SimpleRankResult(double[] scorex, boolean inverse) {
            this.scores = new double[scorex.length];
            System.arraycopy(scorex, 0, this.scores, 0, scorex.length);
            this.profs = new NGramProfile[this.scores.length];
            this.remain = 1.0;
            for (int i = 0; i < this.scores.length; ++i) {
                NGramProfile prof = (NGramProfile)NGramProfiles.this.profiles.get(i);
                double m3 = this.scores[i];
                this.remain -= m3;
                int j = i;
                while (--j >= 0 && inverse ^ m3 < this.scores[j]) {
                    this.scores[j + 1] = this.scores[j];
                    this.profs[j + 1] = this.profs[j];
                }
                this.scores[j + 1] = m3;
                this.profs[j + 1] = prof;
            }
        }

        public NGramProfiles getProfiles() {
            return NGramProfiles.this;
        }

        public double getScore(int pos) {
            if (pos == this.getLength()) {
                return this.remain;
            }
            if (pos < 0) {
                pos += this.getLength();
            }
            return this.scores[pos];
        }

        public String getName(int pos) {
            if (pos == this.getLength()) {
                return NGramProfiles.NOLANGNAME;
            }
            if (pos < 0) {
                pos += this.getLength();
            }
            return this.profs[pos].getName();
        }

        public int getLength() {
            return this.profs.length;
        }
    }

    private static final class Trie {
        static int count = 0;
        char split;
        Trie left;
        Trie right;
        Trie center;
        int id = -1;

        public Trie() {
            ++count;
        }

        public Trie subtree(char c) {
            Trie current = this;
            do {
                if (c != current.split) continue;
                return current;
            } while ((current = c > current.split ? current.right : current.left) != null);
            return null;
        }
    }
}

