/*
 * Decompiled with CFR 0.152.
 */
package de.spieleck.app.cngram;

import de.spieleck.app.cngram.NGram;
import de.spieleck.app.cngram.NGramImpl;
import de.spieleck.app.cngram.NGramProfile;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class NGramProfileImpl
implements NGramProfile {
    public static final char SEPARATOR = '_';
    public static final int DEFAULT_MIN_NGRAM_LENGTH = 1;
    public static final int DEFAULT_MAX_NGRAM_LENGTH = 5;
    private String name;
    private volatile NGram[] sorted = null;
    private volatile NGram[] ordered = null;
    private int minNGramLength;
    private int maxNGramLength;
    private int normalization = 0;
    private HashMap ngrams = new HashMap();
    private Set restricted = null;

    public NGramProfileImpl(String name) {
        this(name, 1, 5);
    }

    public NGramProfileImpl(String name, int minlen, int maxlen) {
        this.maxNGramLength = maxlen;
        this.minNGramLength = minlen;
        this.setName(name);
    }

    public void setRestricted(Set restricted) {
        this.restricted = restricted;
    }

    public void analyze(CharSequence text) {
        StringBuffer word = new StringBuffer(30).append('_');
        for (int i = 0; i < text.length(); ++i) {
            char c = Character.toLowerCase(text.charAt(i));
            if (Character.isLetter(c)) {
                word.append(c);
                continue;
            }
            this.addAnalyze(word);
            word.setLength(1);
        }
        this.addAnalyze(word);
    }

    private void addAnalyze(StringBuffer word) {
        if (word.length() > 1) {
            word.append('_');
            this.addNGrams(word);
        }
    }

    public void clear() {
        if (this.ngrams != null) {
            this.ngrams.clear();
        }
        this.normalization = 0;
        this.sorted = null;
        this.ordered = null;
    }

    public int getCount() {
        return this.ngrams.size();
    }

    public int getNormalization() {
        return this.normalization;
    }

    public void addNGrams(CharSequence word) {
        for (int i = this.minNGramLength; i <= this.maxNGramLength && i < word.length(); ++i) {
            this.addNGrams(word, i);
        }
    }

    private void addNGrams(CharSequence word, int n) {
        int end = word.length() - n;
        for (int i = 0; i <= end; ++i) {
            CharSequence cs = word.subSequence(i, i + n);
            NGram nge = (NGram)this.ngrams.get(cs);
            if (nge == null) {
                nge = new NGramImpl(cs);
                if (this.restricted != null && !this.restricted.contains(nge)) continue;
                this.ngrams.put(cs, nge);
                this.ordered = null;
            }
            nge.inc();
            ++this.normalization;
            this.sorted = null;
        }
    }

    public Iterator getSorted() {
        if (this.sorted == null) {
            this.sorted = this.ngrams.values().toArray(NO_NGRAM);
            Arrays.sort(this.sorted);
        }
        return Arrays.asList(this.sorted).iterator();
    }

    public NGram get(CharSequence seq) {
        int i;
        if (this.ordered == null) {
            this.ordered = this.ngrams.values().toArray(NO_NGRAM);
            Arrays.sort(this.ordered, CHAR_SEQ_COMPARATOR);
        }
        if ((i = Arrays.binarySearch(this.ordered, seq, CHAR_SEQ_COMPARATOR)) < 0) {
            return null;
        }
        return this.ordered[i];
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer(2000);
        Iterator i = this.getSorted();
        s2.append("NGramProfile: ").append(this.name).append('\n');
        while (i.hasNext()) {
            NGram entry = (NGram)i.next();
            s2.append(entry).append(' ').append(entry.getCount()).append('\n');
        }
        return s2.toString();
    }

    public void load(InputStream is) throws IOException {
        String line;
        BufferedReader bis = new BufferedReader(new UnicodeReader(is, "UTF-8"));
        this.ngrams.clear();
        int storeCount = -1;
        String eliminators = "";
        int discards = 0;
        while ((line = bis.readLine()) != null) {
            int l;
            int spacepos;
            String ngramsequence;
            if ((line = line.trim()).length() < 2) continue;
            if (line.charAt(0) == '-') {
                eliminators = eliminators + line.charAt(1);
                continue;
            }
            if (line.startsWith("#END")) break;
            if (line.charAt(0) == '#' || " ".equals(ngramsequence = line.substring(0, spacepos = line.indexOf(32)).trim().replace('_', ' '))) continue;
            int count = Integer.parseInt(line.substring(spacepos + 1).trim());
            if (line.startsWith("ngram_count")) {
                storeCount = count;
                continue;
            }
            if (ngramsequence.length() < this.minNGramLength || ngramsequence.length() > this.maxNGramLength) continue;
            for (l = 0; l < eliminators.length() && ngramsequence.indexOf(eliminators.charAt(l)) < 0; ++l) {
            }
            if (l < eliminators.length()) {
                ++discards;
                continue;
            }
            NGramImpl en = new NGramImpl(ngramsequence, count);
            this.ngrams.put(ngramsequence, en);
            this.normalization += count;
        }
        if (storeCount != -1 && storeCount != this.normalization) {
            System.err.println(" WARNING " + storeCount + " != " + this.normalization);
        }
    }

    public static NGramProfileImpl createProfile(String name, InputStream is, String encoding) throws IOException {
        String line;
        NGramProfileImpl newProfile = new NGramProfileImpl(name);
        BufferedReader bis = new BufferedReader(new UnicodeReader(is, encoding));
        while ((line = bis.readLine()) != null) {
            newProfile.analyze(line);
        }
        return newProfile;
    }

    public void save(OutputStream os) throws IOException {
        Iterator i = this.getSorted();
        os.write(("# NgramProfile generated at " + new Date() + " for Language Identification\n").getBytes());
        os.write(("ngram_count " + this.normalization + "\n").getBytes());
        while (i.hasNext()) {
            NGram e = (NGram)i.next();
            String line = e + " " + e.getCount() + "\n";
            os.write(line.getBytes("UTF-8"));
        }
        os.flush();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

