/*
 * Decompiled with CFR 0.152.
 */
package de.spieleck.app.cngram;

public class LightCharSequence
implements CharSequence {
    private char[] chars;
    private int hashCode;

    public LightCharSequence(CharSequence seq) {
        this.chars = new char[seq.length()];
        for (int i = 0; i < this.chars.length; ++i) {
            this.chars[i] = seq.charAt(i);
        }
        this.calcHashCode();
    }

    public LightCharSequence(CharSequence seq, int start, int end) {
        this.chars = new char[end - start];
        for (int i = start; i < end; ++i) {
            this.chars[i] = seq.charAt(i - start);
        }
        this.calcHashCode();
    }

    protected void calcHashCode() {
        this.hashCode = 42 + this.length();
        for (int i = 0; i < this.chars.length; ++i) {
            this.hashCode = this.hashCode * 0x110001 + this.charAt(i) + 1;
        }
    }

    public char charAt(int pos) {
        return this.chars[pos];
    }

    public int length() {
        return this.chars.length;
    }

    public CharSequence subSequence(int start, int end) {
        return new LightCharSequence(this, start, end);
    }

    public String toString() {
        return new String(this.chars);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LightCharSequence)) {
            return false;
        }
        LightCharSequence l = (LightCharSequence)o;
        if (l.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (l.charAt(i) == this.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

