/*
 * Decompiled with CFR 0.152.
 */
package de.spieleck.app.cngram;

import de.spieleck.app.cngram.NGram;
import de.spieleck.app.cngram.NGramMetric;
import de.spieleck.app.cngram.NGramProfile;
import java.util.Iterator;

public class C2xMetric
implements NGramMetric {
    public static final double ALPHA = 1.0;

    public double diff(NGramProfile p1, NGramProfile p2) {
        double u;
        double sum = 0.0;
        int norm1 = p1.getNormalization();
        int norm2 = p2.getNormalization();
        int norm = norm1 + norm2;
        double d1 = (double)norm1 / (double)norm;
        double d2 = (double)norm2 / (double)norm;
        Iterator i = p1.getSorted();
        while (i.hasNext()) {
            NGram ng1 = (NGram)i.next();
            NGram ng2 = p2.get(ng1);
            int c1 = ng1.getCount();
            int c2 = 0;
            if (ng2 != null) {
                c2 = ng2.getCount();
            }
            u = d1 * (double)(c1 + c2);
            sum += ((double)c1 - u) * ((double)c1 - u) / (u + 1.0);
            u = d2 * (double)(c1 + c2);
            sum += ((double)c2 - u) * ((double)c2 - u) / (u + 1.0);
        }
        i = p2.getSorted();
        while (i.hasNext()) {
            NGram ng2 = (NGram)i.next();
            if (p1.get(ng2) != null) continue;
            int c2 = ng2.getCount();
            u = d1 * (double)c2;
            sum += u * u / (u + 1.0);
            u = d2 * (double)c2;
            sum += ((double)c2 - u) * ((double)c2 - u) / (u + 1.0);
        }
        return sum / (double)norm * 2.0;
    }
}

