/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml.binary;

import de.julielab.xml.binary.BinaryDecodingResult;
import de.julielab.xml.binary.DataRange;
import de.julielab.xml.binary.JeDISAttribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryXmiBuilder {
    private static final Logger log = LoggerFactory.getLogger(BinaryXmiBuilder.class);
    private final Map<String, String> namespaces;

    public BinaryXmiBuilder(Map<String, String> nsAndXmiVersionMap) {
        if (nsAndXmiVersionMap == null || nsAndXmiVersionMap.isEmpty()) {
            throw new IllegalArgumentException("The XMI namespace map passed to the BinaryXmiBuilder is empty. This is an error because it is required to assembly valid XMI documents from annotation modules.");
        }
        this.namespaces = nsAndXmiVersionMap;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public ByteArrayOutputStream buildXmi(BinaryDecodingResult decodingResult) {
        return this.buildXmi(decodingResult, true);
    }

    public ByteArrayOutputStream buildXmi(BinaryDecodingResult decodingResult, boolean makeValidXmi) {
        byte[] xmiData = decodingResult.getXmiData().toByteArray();
        ByteArrayOutputStream ret = new ByteArrayOutputStream();
        try {
            if (makeValidXmi) {
                this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", ret);
                this.write("<xmi:XMI ", ret);
                for (String prefix : this.namespaces.keySet()) {
                    this.write("xmlns:", ret);
                    this.write(prefix, ret);
                    this.write("=\"", ret);
                    this.write(this.namespaces.get(prefix), ret);
                    this.write("\" ", ret);
                }
                ret.write(62);
                this.write("<cas:NULL xmi:id=\"0\" />", ret);
            }
            this.writeContent(xmiData, decodingResult, ret);
            if (makeValidXmi) {
                for (Integer sofaId : decodingResult.getSofaElements().keySet()) {
                    Collection<Integer> annotationIds = decodingResult.getSofaElements().get(sofaId);
                    this.write("<cas:View sofa=\"", ret);
                    this.write(sofaId, ret);
                    this.write("\" members=\"", ret);
                    this.write(annotationIds.stream().map(String::valueOf).collect(Collectors.joining(" ")), ret);
                    this.write("\" />", ret);
                }
                this.write("</xmi:XMI>", ret);
            }
            return ret;
        }
        catch (IOException e) {
            log.error("Could not create final XMI document", e);
            throw new IllegalArgumentException("Could not create final XMI document", e);
        }
    }

    private void writeContent(byte[] xmiData, BinaryDecodingResult decodingResult, ByteArrayOutputStream ret) throws IOException {
        List<DataRange> toModify = decodingResult.getXmiPortionsToModify();
        if (!toModify.isEmpty()) {
            int currentEnd = 0;
            for (int i = 0; i < toModify.size(); ++i) {
                DataRange dataRange = toModify.get(i);
                if (dataRange.getBegin() < currentEnd) continue;
                if (dataRange.isToBeOmitted() && decodingResult.isShrinkArraysAndListsIfReferenceNotLoaded()) {
                    ret.write(xmiData, currentEnd, dataRange.getBegin() - currentEnd);
                    currentEnd = dataRange.getEnd();
                    if (i != toModify.size() - 1) continue;
                    ret.write(xmiData, dataRange.getEnd(), xmiData.length - dataRange.getEnd());
                    continue;
                }
                if (!(dataRange instanceof JeDISAttribute)) continue;
                ret.write(xmiData, currentEnd, dataRange.getBegin() - currentEnd);
                currentEnd = dataRange.getEnd();
                JeDISAttribute a = (JeDISAttribute)dataRange;
                this.write(a.getName(), ret);
                this.write("=\"", ret);
                if (decodingResult.isShrinkArraysAndListsIfReferenceNotLoaded()) {
                    this.write(a.getFoundReferences().stream().map(String::valueOf).collect(Collectors.joining(" ")), ret);
                } else {
                    this.write(a.getReferencedIds().stream().map(id -> a.getFoundReferences().contains(id) ? id : 0).map(String::valueOf).collect(Collectors.joining(" ")), ret);
                }
                this.write("\" ", ret);
            }
            ret.write(xmiData, currentEnd, xmiData.length - currentEnd);
        } else {
            ret.write(xmiData);
        }
    }

    private void write(String s2, ByteArrayOutputStream baos) throws IOException {
        baos.write(s2.getBytes(StandardCharsets.UTF_8));
    }

    private void write(int i, ByteArrayOutputStream baos) throws IOException {
        baos.write(String.valueOf(i).getBytes(StandardCharsets.UTF_8));
    }
}

