/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml.binary;

import com.ctc.wstx.stax.WstxInputFactory;
import com.google.common.collect.HashMultiset;
import de.julielab.xml.JeDISVTDGraphNode;
import de.julielab.xml.XmiSplitUtilities;
import de.julielab.xml.binary.AttributeParser;
import de.julielab.xml.binary.BinaryStorageAnalysisResult;
import de.julielab.xml.binary.XmlByteSpan;
import de.julielab.xml.binary.XmlStartTag;
import de.julielab.xml.util.MissingBinaryMappingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryJeDISNodeEncoder {
    public static final int JEDIS_BINARY_MAGIC = 24981;
    private static final Logger log = LoggerFactory.getLogger(BinaryJeDISNodeEncoder.class);
    private final ByteBuffer bb8;
    private XMLInputFactory inputFactory = new WstxInputFactory();
    private byte[] currentNodeData;

    public BinaryJeDISNodeEncoder() {
        this.inputFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
        this.inputFactory.setProperty("com.ctc.wstx.maxAttributeSize", Integer.MAX_VALUE);
        this.bb8 = ByteBuffer.allocate(Math.max(64, 64));
    }

    public BinaryStorageAnalysisResult findMissingItemsForMapping(Collection<JeDISVTDGraphNode> nodesWithLabel, TypeSystem ts, Map<String, Integer> existingMapping, Map<String, Boolean> existingFeaturesToMap) {
        return this.findMissingItemsForMapping(nodesWithLabel, ts, existingMapping, existingFeaturesToMap, false);
    }

    public BinaryStorageAnalysisResult findMissingItemsForMapping(Collection<JeDISVTDGraphNode> nodesWithLabel, TypeSystem ts, Map<String, Integer> existingMapping, Map<String, Boolean> existingFeaturesToMap, boolean logMappedFeatures) {
        String currentXmiElementForLogging = null;
        try {
            HashMap<String, Set> featureValues = new HashMap<String, Set>();
            HashSet<String> xmiTagNames = new HashSet<String>();
            HashSet<String> featureAttributeNames = new HashSet<String>();
            HashMultiset<String> featureOccurrences = HashMultiset.create();
            AttributeParser attributeParser = new AttributeParser();
            for (JeDISVTDGraphNode jeDISVTDGraphNode : nodesWithLabel) {
                currentXmiElementForLogging = jeDISVTDGraphNode.getModuleXmlData();
                byte[] elementData = jeDISVTDGraphNode.getModuleXmlData().getBytes(StandardCharsets.UTF_8);
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(new ByteArrayInputStream(elementData), "UTF-8");
                while (reader.hasNext()) {
                    if (reader.next() != 1) continue;
                    QName elementName = reader.getName();
                    xmiTagNames.add(elementName.getLocalPart());
                    for (int attrIndex = 0; attrIndex < reader.getAttributeCount(); ++attrIndex) {
                        String featureName;
                        Feature feature;
                        String attrName = reader.getAttributeLocalName(attrIndex);
                        featureAttributeNames.add(attrName);
                        Type nodeType = ts.getType(jeDISVTDGraphNode.getTypeName());
                        if (nodeType == null || (feature = nodeType.getFeatureByBaseName(attrName)) == null || !ts.subsumes(ts.getType("uima.cas.String"), feature.getRange()) || existingFeaturesToMap.containsKey(featureName = feature.getName()) && !existingFeaturesToMap.get(featureName).booleanValue()) continue;
                        Set values = featureValues.compute(featureName, (k, v) -> v != null ? v : new HashSet());
                        XmlStartTag startTag = jeDISVTDGraphNode.getByteSegmentedStartTag(elementData);
                        String value = startTag.getAttributes().get(attrIndex).getAttributeValue().toString();
                        values.add(value);
                        featureOccurrences.add(featureName);
                    }
                }
            }
            HashMap<String, Boolean> featuresToMap = new HashMap<String, Boolean>();
            for (String featureName : featureValues.keySet()) {
                int numOccurrences;
                if (existingFeaturesToMap.containsKey(featureName)) continue;
                Set values = (Set)featureValues.get(featureName);
                int numValues = values.size();
                featuresToMap.put(featureName, (double)numValues / (double)(numOccurrences = featureOccurrences.count(featureName)) <= 0.5);
            }
            if (logMappedFeatures && log.isInfoEnabled()) {
                List list = featuresToMap.keySet().stream().filter(featuresToMap::get).collect(Collectors.toList());
                String none = featuresToMap.isEmpty() ? " none" : "";
                log.info("Determined features to map:{}", (Object)none);
                for (String featureName : list) {
                    Set values = (Set)featureValues.get(featureName);
                    int numValues = values.size();
                    log.info(featureName);
                    log.info("    feature occurrences: {}", (Object)featureOccurrences.count(featureName));
                    log.info("    number different values: {}", (Object)numValues);
                    log.info("    values: {}", (Object)values);
                }
            }
            Stream stream = xmiTagNames.stream();
            Stream featureValuesToMap = Stream.concat(featuresToMap.keySet().stream().filter(featuresToMap::get), existingFeaturesToMap.keySet().stream().filter(existingFeaturesToMap::get)).filter(featureValues::containsKey).map(featureValues::get).flatMap(Collection::stream);
            Stream<Object> itemsForMapping = Stream.concat(stream, featureAttributeNames.stream());
            itemsForMapping = Stream.concat(itemsForMapping, featureValuesToMap);
            itemsForMapping = itemsForMapping.filter(item -> !existingMapping.containsKey(item));
            Set<String> itemsForMappingList = itemsForMapping.collect(Collectors.toSet());
            return new BinaryStorageAnalysisResult(itemsForMappingList, featuresToMap, existingMapping.size());
        }
        catch (XMLStreamException e) {
            log.error("Could not parse XMI element {}", (Object)currentXmiElementForLogging, (Object)e);
            throw new IllegalArgumentException(e);
        }
    }

    public Map<String, ByteArrayOutputStream> encode(Collection<JeDISVTDGraphNode> nodesWithLabel, TypeSystem ts, Map<String, Integer> mapping, Map<String, Boolean> mappedFeatures) throws MissingBinaryMappingException {
        String currentXmiElementForLogging = null;
        Map nodesByLabel = nodesWithLabel.stream().flatMap(n -> n.getAnnotationModuleLabels().stream().map(l -> new ImmutablePair<JeDISVTDGraphNode, String>((JeDISVTDGraphNode)n, (String)l))).collect(Collectors.groupingBy(Pair::getRight, Collectors.mapping(Pair::getLeft, Collectors.toList())));
        try {
            HashMap<String, ByteArrayOutputStream> binaryAnnotationModuleData = new HashMap<String, ByteArrayOutputStream>();
            for (String label : nodesByLabel.keySet()) {
                ByteArrayOutputStream moduleData = new ByteArrayOutputStream();
                moduleData.write(97);
                moduleData.write(24981);
                List nodesForCurrentLabel = nodesByLabel.get(label);
                for (JeDISVTDGraphNode n2 : nodesForCurrentLabel) {
                    currentXmiElementForLogging = n2.getModuleXmlData();
                    ByteArrayOutputStream nodeData = new ByteArrayOutputStream();
                    this.currentNodeData = n2.getModuleXmlData().getBytes(StandardCharsets.UTF_8);
                    XMLStreamReader reader = this.inputFactory.createXMLStreamReader(new ByteArrayInputStream(this.currentNodeData), "UTF-8");
                    XmlStartTag xmlStartTag = n2.getByteSegmentedStartTag(this.currentNodeData);
                    boolean encounteredStart = false;
                    while (reader.hasNext()) {
                        int eventType = reader.next();
                        if (eventType == 1 && !encounteredStart) {
                            encounteredStart = true;
                            String tagName = reader.getName().getLocalPart();
                            this.writeInt(mapping.get(tagName), nodeData);
                            nodeData.write(reader.getAttributeCount());
                            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                                String attrName = reader.getAttributeLocalName(i);
                                this.writeInt(mapping.get(attrName), nodeData);
                                reader.getAttributeValue(i);
                                this.encodeAttributeValue(reader, i, attrName, xmlStartTag, n2, ts, mapping, mappedFeatures, nodeData);
                            }
                            continue;
                        }
                        if (eventType != 1) continue;
                        nodeData.write(0);
                        this.encodeEmbeddedStringArrays(reader, mapping, nodeData);
                    }
                    nodeData.write(1);
                    byte[] nodeDataBytes = nodeData.toByteArray();
                    moduleData.writeBytes(nodeDataBytes);
                }
                binaryAnnotationModuleData.put(label, moduleData);
            }
            return binaryAnnotationModuleData;
        }
        catch (XMLStreamException e) {
            log.error("Could not parse XMI element {}", (Object)currentXmiElementForLogging, (Object)e);
            throw new IllegalArgumentException(e);
        }
    }

    private void encodeEmbeddedStringArrays(XMLStreamReader reader, Map<String, Integer> mapping, ByteArrayOutputStream baos) throws XMLStreamException {
        HashMap<String, List> valuesByFeature = new HashMap<String, List>();
        while (reader.hasNext()) {
            if (reader.getEventType() == 1) {
                String feature = reader.getName().getLocalPart();
                reader.next();
                String value = reader.getText();
                valuesByFeature.compute(feature, (k, v) -> v != null ? v : new ArrayList()).add(value);
            }
            reader.next();
        }
        this.writeInt(valuesByFeature.keySet().size(), baos);
        for (String feature : valuesByFeature.keySet()) {
            Collection values = (Collection)valuesByFeature.get(feature);
            this.writeInt(mapping.get(feature), baos);
            this.writeInt(values.size(), baos);
            for (String value : values) {
                this.writeString(value, baos);
            }
        }
    }

    private void encodeAttributeValue(XMLStreamReader reader, int attributeIndex, String attrName, XmlStartTag xmlStartTag, JeDISVTDGraphNode n, TypeSystem ts, Map<String, Integer> mapping, Map<String, Boolean> mappedFeatures, ByteArrayOutputStream baos) throws MissingBinaryMappingException {
        Feature feature;
        String typeName = XmiSplitUtilities.resolveListSubtypes(n.getTypeName());
        Type nodeType = ts.getType(n.getTypeName());
        Feature feature2 = feature = nodeType != null ? nodeType.getFeatureByBaseName(attrName) : null;
        if (attrName.equals("xmi:id") || attrName.equals("sofa") || XmiSplitUtilities.isReferenceAttribute(nodeType, attrName, ts)) {
            this.handleReferenceAttributes(reader, attributeIndex, attrName, baos);
        } else if (XmiSplitUtilities.isListTypeName(typeName)) {
            this.handleListTypes(reader, attributeIndex, attrName, typeName, mapping, mappedFeatures, baos);
        } else if (XmiSplitUtilities.isMultiValuedFeatureAttribute(nodeType, attrName) || feature.getRange().isArray() || XmiSplitUtilities.isListTypeName(feature.getRange().getName())) {
            this.handleArrayElementFeature(reader, attributeIndex, attrName, typeName, nodeType, feature, baos, ts);
        } else if (feature.getRange().isPrimitive()) {
            this.handlePrimitiveFeatures(reader, attributeIndex, xmlStartTag, feature, mapping, mappedFeatures, baos, ts);
        } else {
            throw new IllegalArgumentException("Unhandled feature '" + attrName + "' of type '" + n.getTypeName() + "'");
        }
    }

    private void handlePrimitiveFeatures(XMLStreamReader reader, int attributeIndex, XmlStartTag xmlStartTag, Feature feature, Map<String, Integer> mapping, Map<String, Boolean> mappedFeatures, ByteArrayOutputStream baos, TypeSystem ts) throws MissingBinaryMappingException {
        if (ts.subsumes(ts.getType("uima.cas.String"), feature.getRange())) {
            this.writeStringWithMapping(attributeIndex, xmlStartTag, feature.getName(), mappedFeatures, mapping, baos);
        } else {
            String attributeValue = reader.getAttributeValue(attributeIndex);
            if (ts.subsumes(ts.getType("uima.cas.Float"), feature.getRange())) {
                this.writeDouble(Double.valueOf(attributeValue), baos);
            } else if (ts.subsumes(ts.getType("uima.cas.Double"), feature.getRange())) {
                this.writeDouble(Double.valueOf(attributeValue), baos);
            } else if (ts.subsumes(ts.getType("uima.cas.Short"), feature.getRange())) {
                this.writeShort(Short.valueOf(attributeValue), baos);
            } else if (ts.subsumes(ts.getType("uima.cas.Byte"), feature.getRange())) {
                baos.write(Byte.valueOf(attributeValue).byteValue());
            } else if (ts.subsumes(ts.getType("uima.cas.Integer"), feature.getRange())) {
                this.writeInt(Integer.valueOf(attributeValue), baos);
            } else if (ts.subsumes(ts.getType("uima.cas.Long"), feature.getRange())) {
                this.writeLong(Long.valueOf(attributeValue), baos);
            } else if (ts.subsumes(ts.getType("uima.cas.Boolean"), feature.getRange())) {
                baos.write(Boolean.valueOf(attributeValue) != false ? 1 : 0);
            } else {
                throw new IllegalArgumentException("Unhandled feature value encoding of feature " + feature.getName() + " of type " + feature.getRange().getName());
            }
        }
    }

    private void handleArrayElementFeature(XMLStreamReader reader, int attributeIndex, String attrName, String typeName, Type nodeType, Feature feature, ByteArrayOutputStream baos, TypeSystem ts) {
        String[] valueSplit = reader.getAttributeValue(attributeIndex).split(" ");
        this.writeInt(valueSplit.length, baos);
        Stream<String> arrayValues = Stream.of(valueSplit);
        String arrayTypeName = XmiSplitUtilities.isMultiValuedFeatureAttribute(nodeType, attrName) ? typeName : feature.getRange().getName();
        Type arrayType = ts.getType(arrayTypeName);
        if (ts.subsumes(ts.getType("uima.cas.DoubleArray"), arrayType) || ts.subsumes(ts.getType("uima.cas.FloatList"), arrayType)) {
            arrayValues.mapToDouble(Double::valueOf).forEach(d -> this.writeDouble(d, baos));
        } else if (ts.subsumes(ts.getType("uima.cas.ShortArray"), arrayType)) {
            arrayValues.mapToInt(Integer::valueOf).forEach(i -> this.writeShort((short)i, baos));
        } else if (ts.subsumes(ts.getType("uima.cas.ByteArray"), arrayType)) {
            arrayValues.mapToInt(Integer::valueOf).forEach(baos::write);
        } else if (ts.subsumes(ts.getType("uima.cas.BooleanArray"), arrayType)) {
            arrayValues.map(s2 -> Boolean.valueOf(s2) != false ? 1 : 0).forEach(baos::write);
        } else if (ts.subsumes(ts.getType("uima.cas.IntegerArray"), arrayType) || ts.subsumes(ts.getType("uima.cas.IntegerList"), arrayType)) {
            arrayValues.mapToInt(Integer::valueOf).forEach(i -> this.writeInt(i, baos));
        } else if (ts.subsumes(ts.getType("uima.cas.LongArray"), arrayType)) {
            arrayValues.mapToLong(Long::valueOf).forEach(l -> this.writeLong(l, baos));
        } else if (ts.subsumes(ts.getType("uima.cas.StringArray"), arrayType)) {
            if (arrayValues.filter(Predicate.not(String::isBlank)).count() > 0L) {
                throw new IllegalArgumentException("Unhandled case of a StringArray that is embedded into the type element but is not empty for feature '" + attrName + "' of type '" + typeName + "'.");
            }
            this.writeInt(0, baos);
        } else {
            throw new IllegalArgumentException("Unhandled feature '" + attrName + "' of type '" + typeName + "'.");
        }
    }

    private void handleListTypes(XMLStreamReader reader, int attributeIndex, String attrName, String typeName, Map<String, Integer> mapping, Map<String, Boolean> mappedFeatures, ByteArrayOutputStream baos) throws MissingBinaryMappingException {
        String attributeValue = reader.getAttributeValue(attributeIndex);
        if (attrName.equals("tail")) {
            this.writeInt(Integer.valueOf(attributeValue), baos);
        } else if (attrName.equals("head")) {
            if (typeName.equals("uima.cas.FloatList")) {
                this.writeDouble(Double.valueOf(attributeValue), baos);
            }
            if (typeName.equals("uima.cas.FSList")) {
                this.writeInt(Integer.valueOf(attributeValue), baos);
            }
            if (typeName.equals("uima.cas.IntegerList")) {
                this.writeInt(Integer.valueOf(attributeValue), baos);
            }
            if (typeName.equals("uima.cas.StringList")) {
                this.writeStringWithMapping(attributeValue, "uima.cas.NonEmptyStringList:head", mappedFeatures, mapping, baos);
            }
        }
    }

    private void handleReferenceAttributes(XMLStreamReader reader, int attributeIndex, String attrName, ByteArrayOutputStream baos) {
        String attributeValue = reader.getAttributeValue(attributeIndex);
        if (attrName.equals("xmi:id")) {
            this.writeInt(Integer.valueOf(attributeValue), baos);
        } else if (attrName.equals("sofa")) {
            baos.write(Byte.valueOf(attributeValue).byteValue());
        } else if (!attributeValue.isBlank()) {
            String[] referencedIds = attributeValue.split(" ");
            this.writeInt(referencedIds.length, baos);
            Stream.of(referencedIds).map(id -> id.equals("null") ? -1 : Integer.valueOf(id)).forEach(i -> this.writeInt((int)i, baos));
        } else {
            this.writeInt(0, baos);
        }
    }

    private void writeStringWithMapping(int attributeIndex, XmlStartTag xmlStartTag, String fullFeatureName, Map<String, Boolean> mappedFeatures, Map<String, Integer> mapping, ByteArrayOutputStream baos) throws MissingBinaryMappingException {
        if (mappedFeatures.get(fullFeatureName).booleanValue()) {
            String value = xmlStartTag.getAttributes().get(attributeIndex).getAttributeValue().toString();
            Integer id = mapping.get(value);
            if (id == null) {
                throw new MissingBinaryMappingException(value, "There is no string to ID mapping for the value '" + value + "' of feature '" + fullFeatureName + "'");
            }
            this.writeInt(id, baos);
        } else {
            XmlByteSpan attributeValue = xmlStartTag.getAttributes().get(attributeIndex).getAttributeValue();
            this.writeInt(attributeValue.getLength(), baos);
            this.writeStringBytes(attributeValue, baos);
        }
    }

    private void writeStringWithMapping(String attributeValue, String fullFeatureName, Map<String, Boolean> mappedFeatures, Map<String, Integer> mapping, ByteArrayOutputStream baos) throws MissingBinaryMappingException {
        if (mappedFeatures.get(fullFeatureName).booleanValue()) {
            Integer id = mapping.get(attributeValue);
            if (id == null) {
                throw new MissingBinaryMappingException(attributeValue, "There is no string to ID mapping for the value '" + attributeValue + "' of feature '" + fullFeatureName + "'");
            }
            this.writeInt(id, baos);
        } else {
            this.writeString(attributeValue, baos);
        }
    }

    private void writeInt(int i, ByteArrayOutputStream baos) {
        this.bb8.position(0);
        this.bb8.putInt(i);
        baos.write(this.bb8.array(), 0, 4);
    }

    private void writeDouble(double d, ByteArrayOutputStream baos) {
        this.bb8.position(0);
        this.bb8.putDouble(d);
        baos.write(this.bb8.array(), 0, 8);
    }

    private void writeShort(short s2, ByteArrayOutputStream baos) {
        this.bb8.position(0);
        this.bb8.putShort(s2);
        baos.write(this.bb8.array(), 0, 2);
    }

    private void writeLong(long l, ByteArrayOutputStream baos) {
        this.bb8.position(0);
        this.bb8.putLong(l);
        baos.write(this.bb8.array(), 0, 8);
    }

    private void writeString(String s2, ByteArrayOutputStream baos) {
        byte[] bytes = s2.getBytes(StandardCharsets.UTF_8);
        this.writeInt(bytes.length, baos);
        baos.writeBytes(bytes);
    }

    private void writeStringBytes(XmlByteSpan xmlByteSpan, ByteArrayOutputStream baos) {
        for (int i = xmlByteSpan.getStart(); i < xmlByteSpan.getEnd(); ++i) {
            byte b = xmlByteSpan.getXmlData()[i];
            baos.write(b);
        }
    }
}

