/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.xml.stream.events.XMLEvent;

public class StorageElement {
    private XMLEvent element;
    private String elementPrefix;
    private String elementNSUri;
    private String javaName;
    private Collection<String> storageKeys;

    public StorageElement(XMLEvent event, Collection<String> storageKeys) {
        this.element = this.checkIsElement(event);
        this.storageKeys = new HashSet<String>(storageKeys);
    }

    public StorageElement(XMLEvent event, String elementPrefix, String elementNSUri, String elementName, String javaName, Collection<String> storageKeys) {
        this.element = this.checkIsElement(event);
        this.elementPrefix = elementPrefix;
        this.elementNSUri = elementNSUri;
        this.javaName = javaName;
        this.storageKeys = new HashSet<String>(storageKeys);
    }

    private XMLEvent checkIsElement(XMLEvent event) {
        if (!(event.isStartElement() || event.isEndElement() || event.isCharacters())) {
            throw new IllegalArgumentException("Only start elements, end element events and text content are allowed in this class but has XMLStreamConstants event code " + event.getEventType());
        }
        return event;
    }

    public XMLEvent getElement() {
        return this.element;
    }

    public void setElement(XMLEvent event) {
        this.element = this.checkIsElement(event);
    }

    public String getElementPrefix() {
        return this.elementPrefix;
    }

    public void setElementPrefix(String elementPrefix) {
        this.elementPrefix = elementPrefix;
    }

    public String getElementNSUri() {
        return this.elementNSUri;
    }

    public void setElementNSUri(String elementNSUri) {
        this.elementNSUri = elementNSUri;
    }

    public String getElementName() {
        if (this.element.isStartElement()) {
            return this.element.asStartElement().getName().getLocalPart();
        }
        if (this.element.isEndElement()) {
            return this.element.asEndElement().getName().getLocalPart();
        }
        return "TEXT";
    }

    public String getElementTypeJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public Collection<String> getStorageKeys() {
        return this.storageKeys;
    }

    public void setStorageKeys(Collection<String> storageKey) {
        this.storageKeys = storageKey;
    }

    public void addStorageKeys(Collection<String> missingKeys) {
        this.storageKeys.addAll(missingKeys);
    }

    public String toString() {
        return this.getElementName() + ": " + this.storageKeys.stream().collect(Collectors.joining());
    }
}

