/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import de.julielab.xml.binary.AttributeParser;
import de.julielab.xml.binary.XmlStartTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JeDISVTDGraphNode {
    public static final JeDISVTDGraphNode CAS_NULL = new JeDISVTDGraphNode(0, 0);
    protected long elementFragment;
    protected Integer oldXmiId;
    protected Integer newXmiId;
    protected Set<String> annotationModuleLabels = Collections.emptySet();
    protected int sofaXmiId;
    protected String typeName;
    protected List<JeDISVTDGraphNode> predecessors = Collections.emptyList();
    private Map<String, List<Integer>> referencedXmiIds = Collections.emptyMap();
    private int byteOffset;
    private int byteLength;
    private String moduleXmlData;
    private XmlStartTag byteSegmentedStartTag;

    private JeDISVTDGraphNode(Integer oldXmiId, Integer newXmiId) {
        this();
        this.oldXmiId = oldXmiId;
        this.newXmiId = newXmiId;
    }

    public JeDISVTDGraphNode(Integer oldXmiId) {
        this();
        this.oldXmiId = oldXmiId;
    }

    public JeDISVTDGraphNode() {
    }

    public String toString() {
        return "JeDISVTDGraphNode{oldXmiId=" + this.oldXmiId + ", annotationModuleLabels=" + this.annotationModuleLabels + ", typeName='" + this.typeName + "'}";
    }

    public long getElementFragment() {
        return this.elementFragment;
    }

    public void setElementFragment(long elementFragment) {
        this.elementFragment = elementFragment;
        this.byteOffset = (int)elementFragment;
        this.byteLength = (int)(elementFragment >> 32);
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public void setByteLength(int byteLength) {
        this.byteLength = byteLength;
    }

    public Integer getOldXmiId() {
        return this.oldXmiId;
    }

    public void setOldXmiId(Integer oldXmiId) {
        this.oldXmiId = oldXmiId;
    }

    public Integer getNewXmiId() {
        return this.newXmiId;
    }

    public void setNewXmiId(Integer newXmiId) {
        this.newXmiId = newXmiId;
    }

    public Set<String> getAnnotationModuleLabels() {
        return this.annotationModuleLabels;
    }

    public void setAnnotationModuleLabels(Set<String> annotationModuleLabels) {
        this.annotationModuleLabels = annotationModuleLabels;
    }

    public int getSofaXmiId() {
        return this.sofaXmiId;
    }

    public void setSofaXmiId(int sofaXmiId) {
        this.sofaXmiId = sofaXmiId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public List<JeDISVTDGraphNode> getPredecessors() {
        return this.predecessors;
    }

    public void setPredecessors(List<JeDISVTDGraphNode> predecessors) {
        this.predecessors = predecessors;
    }

    public void addPredecessor(JeDISVTDGraphNode referencingNode) {
        if (this.predecessors.isEmpty()) {
            this.predecessors = new ArrayList<JeDISVTDGraphNode>();
        }
        this.predecessors.add(referencingNode);
    }

    public void addAnnotationModuleLabel(String typeName) {
        if (this.annotationModuleLabels.isEmpty()) {
            this.annotationModuleLabels = new HashSet<String>();
        }
        this.annotationModuleLabels.add(typeName);
    }

    public void addAnnotationModuleLabels(Set<String> labels) {
        labels.forEach(this::addAnnotationModuleLabel);
    }

    public Map<String, List<Integer>> getReferencedXmiIds() {
        return this.referencedXmiIds;
    }

    public void setReferencedXmiIds(Map<String, List<Integer>> referencedXmiIds) {
        this.referencedXmiIds = referencedXmiIds;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }

    public String getModuleXmlData() {
        return this.moduleXmlData;
    }

    public void setModuleData(String moduleXmlData) {
        this.moduleXmlData = moduleXmlData;
    }

    public XmlStartTag getByteSegmentedStartTag(byte[] elementData) {
        if (this.byteSegmentedStartTag == null) {
            AttributeParser attributeParser = new AttributeParser();
            this.byteSegmentedStartTag = attributeParser.parse(elementData);
        }
        return this.byteSegmentedStartTag;
    }

    public void setByteSegmentedStartTag(XmlStartTag byteSegmentedStartTag) {
        this.byteSegmentedStartTag = byteSegmentedStartTag;
    }
}

