/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.xml;

import com.google.common.collect.Sets;
import de.julielab.xml.JeDISVTDGraphNode;
import de.julielab.xml.SofaVTDGraphNode;
import de.julielab.xml.XmiSplitUtilities;
import de.julielab.xml.XmiSplitter;
import de.julielab.xml.util.XMISplitterException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uima.cas.TypeSystem;

public abstract class AbstractXmiSplitter
implements XmiSplitter {
    private static final int NO_SOFA_KEY = -1;
    private static final int SECOND_SOFA_MAP_KEY_START = -2;
    private static final int SOFA_UNKNOWN = Integer.MIN_VALUE;
    protected final Set<String> moduleAnnotationNames;
    protected final boolean recursively;
    protected final boolean storeBaseDocument;
    private final Set<String> baseDocumentAnnotations;
    protected int currentSecondSofaMapKey;
    protected Map<Integer, JeDISVTDGraphNode> nodesByXmiId;
    protected Map<String, Set<JeDISVTDGraphNode>> annotationModules;
    private Set<Integer> unavailableXmiId;

    public AbstractXmiSplitter(Set<String> moduleAnnotationNames, boolean recursively, boolean storeBaseDocument, Set<String> baseDocumentAnnotations) {
        this.moduleAnnotationNames = moduleAnnotationNames != null ? new HashSet<String>(moduleAnnotationNames) : null;
        this.recursively = recursively;
        this.storeBaseDocument = storeBaseDocument;
        Set<Object> set = this.baseDocumentAnnotations = baseDocumentAnnotations == null ? Collections.emptySet() : baseDocumentAnnotations;
        if (storeBaseDocument) {
            this.moduleAnnotationNames.add("DOCUMENT-MODULE");
        }
        if (moduleAnnotationNames != null && baseDocumentAnnotations != null && !Sets.intersection(moduleAnnotationNames, baseDocumentAnnotations).isEmpty()) {
            throw new IllegalArgumentException("The annotation types to build modules from and the annotation types to added to the base document overlap in: " + Sets.intersection(moduleAnnotationNames, baseDocumentAnnotations));
        }
    }

    protected ImmutablePair<Integer, Map<String, Integer>> assignNewXmiIds(Map<Integer, JeDISVTDGraphNode> nodesByXmiId, Map<String, Integer> existingSofaIdMap, int nextPossibleId) {
        HashMap<String, Integer> updatedSofaIdMap = null != existingSofaIdMap ? new HashMap<String, Integer>(existingSofaIdMap) : new HashMap();
        int currentXmiId = nextPossibleId;
        this.adaptSofaIdMap(nodesByXmiId, updatedSofaIdMap);
        for (String moduleName : this.annotationModules.keySet()) {
            if (!this.storeBaseDocument && moduleName.equals("DOCUMENT-MODULE")) continue;
            Set<JeDISVTDGraphNode> moduleNodes = this.annotationModules.get(moduleName);
            for (JeDISVTDGraphNode node : moduleNodes) {
                if (node instanceof SofaVTDGraphNode) continue;
                while (this.unavailableXmiId.contains(currentXmiId)) {
                    ++currentXmiId;
                }
                node.setNewXmiId(currentXmiId);
                this.unavailableXmiId.add(currentXmiId);
                ++currentXmiId;
            }
        }
        return new ImmutablePair<Integer, Map<String, Integer>>(currentXmiId, updatedSofaIdMap);
    }

    protected void adaptSofaIdMap(Map<Integer, JeDISVTDGraphNode> nodesByXmiId, Map<String, Integer> updatedSofaIdMap) {
        this.unavailableXmiId = new HashSet<Integer>();
        this.unavailableXmiId.add(0);
        int sofaKey = -2;
        int newSofaId = 1;
        while (nodesByXmiId.containsKey(sofaKey)) {
            int newSofaXmiId;
            SofaVTDGraphNode sofaNode = (SofaVTDGraphNode)nodesByXmiId.get(sofaKey);
            String sofaID = sofaNode.getSofaID();
            if (!updatedSofaIdMap.containsKey(sofaID)) {
                if (this.storeBaseDocument) {
                    updatedSofaIdMap.put(sofaID, newSofaId);
                    newSofaXmiId = newSofaId++;
                } else {
                    newSofaXmiId = Integer.MIN_VALUE;
                }
            } else {
                newSofaXmiId = updatedSofaIdMap.get(sofaID);
            }
            sofaNode.setNewXmiId(newSofaXmiId);
            this.unavailableXmiId.add(newSofaXmiId);
            --sofaKey;
        }
    }

    protected Map<String, Set<JeDISVTDGraphNode>> createAnnotationModules(Map<Integer, JeDISVTDGraphNode> nodesByXmiId) {
        HashMap<String, Set<JeDISVTDGraphNode>> modules = new HashMap<String, Set<JeDISVTDGraphNode>>();
        for (JeDISVTDGraphNode node : nodesByXmiId.values()) {
            for (String label : node.getAnnotationModuleLabels()) {
                if (!this.moduleAnnotationNames.contains(label)) continue;
                modules.compute(label, (l, list) -> {
                    HashSet<JeDISVTDGraphNode> ret = list == null ? new HashSet<JeDISVTDGraphNode>() : list;
                    ret.add(node);
                    return ret;
                });
            }
        }
        return modules;
    }

    protected void labelNodes(Map<Integer, JeDISVTDGraphNode> nodesByXmiId, Set<String> moduleAnnotationNames, boolean recursively) {
        if (null == moduleAnnotationNames) {
            return;
        }
        for (JeDISVTDGraphNode node : nodesByXmiId.values()) {
            Stream<String> allLabels = this.determineLabelsForNode(node, moduleAnnotationNames, recursively);
            node.setAnnotationModuleLabels(allLabels.collect(Collectors.toSet()));
        }
    }

    protected Stream<String> determineLabelsForNode(JeDISVTDGraphNode node, Set<String> moduleAnnotationNames, boolean recursively) {
        if (node == JeDISVTDGraphNode.CAS_NULL) {
            return Stream.empty();
        }
        if (!node.getAnnotationModuleLabels().isEmpty()) {
            return node.getAnnotationModuleLabels().stream();
        }
        Function<JeDISVTDGraphNode, Stream> fetchLabelsRecursively = n -> n.getPredecessors().stream().flatMap(p -> this.determineLabelsForNode((JeDISVTDGraphNode)p, moduleAnnotationNames, recursively));
        if (XmiSplitUtilities.isAnnotationType(node.getTypeName())) {
            if (moduleAnnotationNames.contains(node.getTypeName())) {
                return Stream.of(node.getTypeName());
            }
            if (this.storeBaseDocument && this.baseDocumentAnnotations.contains(node.getTypeName())) {
                return Stream.of("DOCUMENT-MODULE");
            }
            if (recursively) {
                return fetchLabelsRecursively.apply(node);
            }
            return Stream.empty();
        }
        if (this.storeBaseDocument && node.getTypeName().equals("uima.cas.Sofa")) {
            return Stream.of("DOCUMENT-MODULE");
        }
        return fetchLabelsRecursively.apply(node);
    }

    Map<Integer, JeDISVTDGraphNode> getNodesByXmiId() {
        return this.nodesByXmiId;
    }

    protected abstract String getNodeXml(JeDISVTDGraphNode var1) throws XMISplitterException;

    protected LinkedHashMap<String, ByteArrayOutputStream> createAnnotationModuleData(Map<Integer, JeDISVTDGraphNode> nodesByXmiId, Map<Integer, Integer> oldSofaXmiId2NewSofaXmiId, Map<String, Set<JeDISVTDGraphNode>> annotationModules, TypeSystem ts) throws XMISplitterException {
        LinkedHashMap<String, ByteArrayOutputStream> annotationModuleData = new LinkedHashMap<String, ByteArrayOutputStream>();
        HashMap<Integer, Set> backwardReferences = new HashMap<Integer, Set>();
        for (JeDISVTDGraphNode n : nodesByXmiId.values()) {
            for (String feature : n.getReferencedXmiIds().keySet()) {
                for (Integer referencedElementIds : n.getReferencedXmiIds().get(feature)) {
                    backwardReferences.compute(referencedElementIds, (k, v) -> v != null ? v : new HashSet()).add(new ImmutablePair<JeDISVTDGraphNode, String>(n, feature));
                }
            }
        }
        for (String moduleName : annotationModules.keySet()) {
            if (!this.storeBaseDocument && moduleName.equals("DOCUMENT-MODULE")) continue;
            Set<JeDISVTDGraphNode> moduleNodes = annotationModules.get(moduleName);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                String xmlElement;
                annotationModuleData.put(moduleName, baos);
                for (JeDISVTDGraphNode node : moduleNodes) {
                    if (node.getSofaXmiId() == Integer.MIN_VALUE) {
                        throw new IllegalArgumentException("An annotation module is requested that belongs to a Sofa that is not present in existing document data and that is also not to be stored now. This would bring inconsistency into the stored data because some elements would refer to a Sofa that does not exist.");
                    }
                    xmlElement = this.getNodeXml(node);
                    for (String featureName : node.getReferencedXmiIds().keySet()) {
                        List<Integer> references = node.getReferencedXmiIds().get(featureName);
                        Optional<Integer> anyReferenceId = references.stream().filter(nodesByXmiId::containsKey).map(oldId -> oldId == 0 ? oldId : ((JeDISVTDGraphNode)nodesByXmiId.get(oldId)).getNewXmiId()).filter(Objects::nonNull).findAny();
                        if (anyReferenceId.isPresent() || !XmiSplitUtilities.isListTypeName(node.getTypeName()) && !ts.getType(node.getTypeName()).isArray()) continue;
                        xmlElement = null;
                    }
                    if (xmlElement != null) continue;
                    node.getAnnotationModuleLabels().clear();
                    Set referencingNodes = (Set)backwardReferences.get(node.getOldXmiId());
                    for (Pair pairAndFeature : referencingNodes) {
                        ((JeDISVTDGraphNode)pairAndFeature.getLeft()).getReferencedXmiIds().get(pairAndFeature.getRight()).remove(node.getOldXmiId());
                    }
                    nodesByXmiId.remove(node.getOldXmiId());
                }
                for (JeDISVTDGraphNode node : moduleNodes) {
                    if (node.getAnnotationModuleLabels().isEmpty()) continue;
                    xmlElement = this.getNodeXml(node);
                    int oldSofaXmiId = node.getSofaXmiId();
                    if (oldSofaXmiId != -1) {
                        xmlElement = xmlElement.replaceFirst("sofa=\"[0-9]+\"", "sofa=\"" + nodesByXmiId.get(node.getSofaXmiId()).getNewXmiId() + "\"");
                    }
                    xmlElement = xmlElement.replaceFirst("xmi:id=\"[0-9]+\"", "xmi:id=\"" + node.getNewXmiId() + "\"");
                    for (String featureName : node.getReferencedXmiIds().keySet()) {
                        List<Integer> references = node.getReferencedXmiIds().get(featureName);
                        String newReferenceString = references.stream().filter(nodesByXmiId::containsKey).map(oldId -> oldId == 0 ? oldId : ((JeDISVTDGraphNode)nodesByXmiId.get(oldId)).getNewXmiId()).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.joining(" "));
                        if (!newReferenceString.isBlank()) {
                            xmlElement = xmlElement.replaceFirst(featureName + "=\"[0-9\\s]+\"", featureName + "=\"" + newReferenceString + "\"");
                            continue;
                        }
                        xmlElement = xmlElement.replaceFirst(featureName + "=\"[^\"]+\"", "");
                    }
                    node.setModuleData(xmlElement);
                    baos.write(node.getModuleXmlData().getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new XMISplitterException(e);
            }
        }
        return annotationModuleData;
    }

    Map<String, Set<JeDISVTDGraphNode>> getAnnotationModules() {
        return this.annotationModules;
    }
}

