/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.uima;

import de.julielab.jcore.ae.speciesassignment.desc.OrganismEnumeration.OrganismEnumeration;
import de.julielab.jcore.types.ConceptMention;
import de.julielab.jcore.types.Organism;
import de.julielab.jcore.types.ResourceEntry;
import de.julielab.jcore.utility.JCoReTools;
import de.julielab.jcore.utility.index.JCoReOverlapAnnotationIndex;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Organism Conjunction Postprocessing Annotator", description="Requires that the OrganismConjunction RUTA AE has been run before. Merges Organism annotations that have been recognized to be in a organism conjunction.")
@TypeCapability(inputs={"de.julielab.jcore.ae.genemapper.desc.OrganismEnumeration", "de.julielab.jcore.types.Organism"}, outputs={"de.julielab.jcore.types.Organism"})
public class OrganismConjunctionPostprocessingAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(OrganismConjunctionPostprocessingAnnotator.class);

    @Override
    public void process(JCas jCas) {
        try {
            JCoReOverlapAnnotationIndex organismIndex = new JCoReOverlapAnnotationIndex(jCas, Organism.type);
            for (OrganismEnumeration enumeration : jCas.getAnnotationIndex(OrganismEnumeration.type)) {
                List<Organism> originalOrganisms = organismIndex.search(enumeration).stream().sorted(Comparator.comparingInt(Annotation::getBegin)).collect(Collectors.toList());
                List<ResourceEntry> speciesEntries = originalOrganisms.stream().map(ConceptMention::getResourceEntryList).map(FSArray::toArray).flatMap(Arrays::stream).map(ResourceEntry.class::cast).collect(Collectors.toList());
                FSArray combinedSpeciesEntries = JCoReTools.addToFSArray(null, speciesEntries);
                Organism conjunction = new Organism(jCas, ((Organism)originalOrganisms.get(0)).getBegin(), ((Organism)originalOrganisms.get(originalOrganisms.size() - 1)).getEnd());
                conjunction.setResourceEntryList(combinedSpeciesEntries);
                conjunction.setComponentId(OrganismConjunctionPostprocessingAnnotator.class.getCanonicalName());
                conjunction.addToIndexes();
                speciesEntries.forEach(TOP::removeFromIndexes);
                originalOrganisms.forEach(TOP::removeFromIndexes);
            }
        }
        catch (Throwable e) {
            log.error("Exception occurred.", e);
            throw e;
        }
    }
}

