/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.services;

import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.services.CacheService;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.IOStreamUtilities;
import de.julielab.speciesassignment.Configuration;
import de.julielab.speciesassignment.SpeciesAssignmentRuntimeException;
import de.julielab.speciesassignment.cooccurrence.SynonymSpeciesCoocurrenceCacheKey;
import de.julielab.speciesassignment.spi.SynonymSpeciesCooccurrenceService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynonymSpeciesCooccurrenceServiceImpl
implements SynonymSpeciesCooccurrenceService {
    private static final Logger log = LoggerFactory.getLogger(SynonymSpeciesCooccurrenceServiceImpl.class);
    private static final AtomicInteger numInstances = new AtomicInteger(0);
    private final CacheService cacheService;
    private Map<String, Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>>> occurrenceData;
    private Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>> totalTaxIdFreqByScope;
    private int maxCount;
    private Cache<SynonymSpeciesCoocurrenceCacheKey, Pair<String, Double>> aprioriCache;
    private File synonymSpeciesCooccurrenceFile;

    @Inject
    public SynonymSpeciesCooccurrenceServiceImpl(@Named(value="synonymSpeciesOccurrencesFile") File synonymSpeciesCooccurrenceFile, CacheService cacheService) {
        this.cacheService = cacheService;
        if (synonymSpeciesCooccurrenceFile != null) {
            this.synonymSpeciesCooccurrenceFile = synonymSpeciesCooccurrenceFile;
        } else {
            log.warn("The path to the synonym species occurrences file was not specified. No co-ocurrence information will be available.");
        }
        assert (numInstances.incrementAndGet() == 1) : "There is more than one instance of " + SynonymSpeciesCooccurrenceServiceImpl.class.getCanonicalName() + " but it should be a singleton.";
    }

    private synchronized void loadData(File synonymSpeciesCooccurrenceFile) {
        if (this.occurrenceData == null) {
            try {
                log.debug("Reading gene synonym species cooccurrences from {}", (Object)synonymSpeciesCooccurrenceFile);
                long time = System.currentTimeMillis();
                this.occurrenceData = this.readData(synonymSpeciesCooccurrenceFile);
                this.maxCount = this.occurrenceData.keySet().stream().map(this.occurrenceData::get).flatMap(tax2ScopeCounts -> tax2ScopeCounts.keySet().stream().map(tax2ScopeCounts::get)).flatMap(scopeCounts -> scopeCounts.keySet().stream().map(scopeCounts::get)).mapToInt(Integer::intValue).max().orElse(0);
                this.totalTaxIdFreqByScope = new HashMap<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>>();
                for (String synonym : this.occurrenceData.keySet()) {
                    Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>> tax2occurrencecounts = this.occurrenceData.get(synonym);
                    for (String taxId : tax2occurrencecounts.keySet()) {
                        Map<SynonymSpeciesCooccurrenceService.Scope, Integer> occurrenceCounts = tax2occurrencecounts.get(taxId);
                        Map scopeCounts4tax = this.totalTaxIdFreqByScope.compute(taxId, (k, v) -> v != null ? v : new HashMap());
                        for (SynonymSpeciesCooccurrenceService.Scope scope : occurrenceCounts.keySet()) {
                            scopeCounts4tax.merge(scope, occurrenceCounts.get((Object)scope), Integer::sum);
                        }
                    }
                }
                this.aprioriCache = this.cacheService.getCacheManager().getCache("species-synonym-apriori-cache");
                log.debug("Finished reading {} records of gene synonym species cooccurrence data in {}ms.", (Object)this.occurrenceData.size(), (Object)(time - System.currentTimeMillis()));
            }
            catch (IOException e) {
                log.error("Could not read the gene synonym species cooccurrence data from {}", (Object)synonymSpeciesCooccurrenceFile, (Object)e);
                throw new SpeciesAssignmentRuntimeException(e);
            }
        }
    }

    @Override
    public int getCount(String synonym, String taxId, SynonymSpeciesCooccurrenceService.Scope scope) {
        this.loadData(this.synonymSpeciesCooccurrenceFile);
        return this.occurrenceData.getOrDefault(synonym, Collections.emptyMap()).getOrDefault(taxId, Collections.emptyMap()).getOrDefault((Object)scope, 0);
    }

    @Override
    public Map<SynonymSpeciesCooccurrenceService.Scope, Integer> getScopeCounts(String synonym, String taxId) {
        this.loadData(this.synonymSpeciesCooccurrenceFile);
        return this.occurrenceData.getOrDefault(synonym, Collections.emptyMap()).getOrDefault(taxId, Collections.emptyMap());
    }

    @Override
    public Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>> getSynonymCounts(String synonym) {
        this.loadData(this.synonymSpeciesCooccurrenceFile);
        return this.occurrenceData.getOrDefault(synonym, Collections.emptyMap());
    }

    private Map<String, Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>>> readData(File synonymSpeciesCooccurrenceFile) throws IOException {
        HashMap<String, Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>>> data = new HashMap<String, Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>>>();
        try (BufferedReader bw = IOStreamUtilities.getReaderFromInputStream(FileUtilities.findResource(synonymSpeciesCooccurrenceFile.getAbsolutePath()));){
            bw.lines().forEach(l -> {
                HashSet<String> errors = new HashSet<String>();
                try {
                    String[] split = l.split("\t");
                    String synonym = split[0].trim().intern();
                    String taxId = split[1].trim().intern();
                    SynonymSpeciesCooccurrenceService.Scope scope = SynonymSpeciesCooccurrenceService.Scope.valueOf(split[2].trim());
                    Integer frequency = Integer.valueOf(split[3]);
                    data.compute(synonym, (k, v) -> v != null ? v : new HashMap()).compute(taxId, (k, v) -> v != null ? v : new HashMap()).put(scope, frequency);
                }
                catch (Exception e) {
                    errors.add(e.getMessage());
                }
                if (errors.size() > 1) {
                    log.warn("There were errors when reading the synonym species co-occurrence file: {}", (Object)errors);
                }
            });
        }
        if (data.isEmpty()) {
            log.warn("Could not load any gene-species co-occurrence statistic values. Species assignment might not work right. The source file was {}.", (Object)synonymSpeciesCooccurrenceFile);
        }
        return data;
    }

    @Override
    public Set<Pair<String, Double>> getBestAPrioriTaxIdsForBestGeneCandidates(GeneMention gm, @Nullable SynonymSpeciesCooccurrenceService.Scope scope, @Nullable Set<String> filterTax, Parameters params) {
        if (gm.hasExactCandidateMatch()) {
            Optional<Pair<String, Double>> taxId = this.getBestAPrioriTaxId(gm.getBestCandidateSynonym(), scope, filterTax, params);
            if (taxId.isPresent()) {
                return Set.of(taxId.get());
            }
        } else {
            if (gm.hasApproximateCandidateMatch()) {
                HashSet<Pair<String, Double>> bestTaxIds = new HashSet<Pair<String, Double>>();
                for (String approxMatchSynonym : gm.getAllBestCandidateSynonyms(filterTax)) {
                    this.getBestAPrioriTaxId(approxMatchSynonym, scope, filterTax, params).ifPresent(bestTaxIds::add);
                }
                return bestTaxIds;
            }
            HashSet<Pair<String, Double>> bestTaxIds = new HashSet<Pair<String, Double>>();
            this.getBestAPrioriTaxId(gm.getNormalizedText(), scope, filterTax, params).ifPresent(bestTaxIds::add);
            return bestTaxIds;
        }
        return Collections.emptySet();
    }

    @Override
    public Optional<Pair<String, Double>> getBestAPrioriTaxId(String synonym, @Nullable SynonymSpeciesCooccurrenceService.Scope scope, @Nullable Set<String> filterTax, Parameters params) {
        Optional<Pair<String, Double>> res = Optional.empty();
        if (scope == null) {
            res = this.getBestAPrioriTaxId(synonym, filterTax, params);
        } else {
            Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>> synonymCounts = this.getSynonymCounts(synonym);
            double maxScore = -1.0;
            String bestTaxId = null;
            if (synonymCounts != null) {
                for (String taxId : synonymCounts.keySet()) {
                    double score;
                    if (filterTax != null && !filterTax.isEmpty() && !filterTax.contains(taxId) || !((score = (double)synonymCounts.get(taxId).getOrDefault((Object)scope, 0).intValue()) > maxScore)) continue;
                    maxScore = score;
                    bestTaxId = taxId;
                }
                if (bestTaxId != null) {
                    res = Optional.of(new ImmutablePair<Object, Double>(bestTaxId, maxScore));
                }
            }
        }
        return res;
    }

    @Override
    public Optional<Pair<String, Double>> getBestAPrioriTaxId(String synonym, @Nullable Set<String> filterTax, Parameters params) {
        this.loadData(this.synonymSpeciesCooccurrenceFile);
        HashMap<SynonymSpeciesCooccurrenceService.Scope, Double> scopeWeights = new HashMap<SynonymSpeciesCooccurrenceService.Scope, Double>();
        scopeWeights.put(SynonymSpeciesCooccurrenceService.Scope.DOCUMENT, Double.parseDouble((String)params.getOrDefault((Object)Configuration.PARAM_SYNONYM_APRIORI_SERVICE_SCOPE_WEIGHT_DOCUMENT, "0.333333")));
        scopeWeights.put(SynonymSpeciesCooccurrenceService.Scope.SENTENCE, Double.parseDouble((String)params.getOrDefault((Object)Configuration.PARAM_SYNONYM_APRIORI_SERVICE_SCOPE_WEIGHT_SENTENCE, "0.333333")));
        scopeWeights.put(SynonymSpeciesCooccurrenceService.Scope.MESH, Double.parseDouble((String)params.getOrDefault((Object)Configuration.PARAM_SYNONYM_APRIORI_SERVICE_SCOPE_WEIGHT_MESH, "0.333333")));
        SynonymSpeciesCoocurrenceCacheKey cacheKey = new SynonymSpeciesCoocurrenceCacheKey(synonym, filterTax, (Double)scopeWeights.get((Object)SynonymSpeciesCooccurrenceService.Scope.DOCUMENT), (Double)scopeWeights.get((Object)SynonymSpeciesCooccurrenceService.Scope.MESH), (Double)scopeWeights.get((Object)SynonymSpeciesCooccurrenceService.Scope.SENTENCE));
        assert (this.aprioriCache != null) : "The a priori synonym-species cache is null";
        ImmutablePair<Object, Double> idScore = this.aprioriCache.get(cacheKey);
        if (idScore == null) {
            double maxScore = -1.0;
            String bestTaxId = null;
            Map<String, Map<SynonymSpeciesCooccurrenceService.Scope, Integer>> synonymCounts = this.getSynonymCounts(synonym);
            if (synonymCounts != null) {
                for (String taxId : synonymCounts.keySet()) {
                    if (filterTax != null && !filterTax.isEmpty() && !filterTax.contains(taxId)) continue;
                    Map<SynonymSpeciesCooccurrenceService.Scope, Integer> scopeCounts = synonymCounts.get(taxId);
                    double score = 0.0;
                    for (SynonymSpeciesCooccurrenceService.Scope countedScope : scopeCounts.keySet()) {
                        score += (Double)scopeWeights.get((Object)countedScope) * Math.log(scopeCounts.get((Object)countedScope).intValue());
                    }
                    if (!(score > maxScore)) continue;
                    maxScore = score;
                    bestTaxId = taxId;
                }
            }
            idScore = bestTaxId != null ? new ImmutablePair<Object, Double>(bestTaxId, maxScore) : ImmutablePair.nullPair();
            this.aprioriCache.put(cacheKey, idScore);
        }
        return !idScore.equals(ImmutablePair.nullPair()) ? Optional.of(idScore) : Optional.empty();
    }

    @Override
    public Optional<Pair<String, Double>> getBestDocumentLevelAPrioriTaxId(GeneDocument document, Set<String> filterTaxIds, Parameters parameters) {
        HashMap<String, Double> synonymBasedTaxonomyScores = new HashMap<String, Double>();
        int normfactor = 0;
        for (GeneMention gm : document.getGenesIterable()) {
            Set<Pair<String, Double>> bestAPrioriTaxIdsForBestGeneCandidates = this.getBestAPrioriTaxIdsForBestGeneCandidates(gm, null, filterTaxIds, parameters);
            for (Pair pair : bestAPrioriTaxIdsForBestGeneCandidates) {
                synonymBasedTaxonomyScores.merge((String)pair.getLeft(), (Double)pair.getRight() / (double)bestAPrioriTaxIdsForBestGeneCandidates.size(), Double::sum);
            }
            ++normfactor;
        }
        double bestScore = 0.0;
        String bestTax = null;
        for (String string : synonymBasedTaxonomyScores.keySet()) {
            Double score = (Double)synonymBasedTaxonomyScores.get(string);
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestTax = string;
        }
        return bestTax == null ? Optional.empty() : Optional.of(new ImmutablePair<Object, Double>(bestTax, bestScore /= (double)normfactor));
    }
}

