/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.services;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.genemodel.GeneSpeciesOccurrence;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.speciesassignment.spi.SpeciesReferenceMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SpeciesReferenceMapperImpl
implements SpeciesReferenceMapper {
    private static final Logger log = LoggerFactory.getLogger(SpeciesReferenceMapperImpl.class);
    public Map<String, String> references;

    @Inject
    public SpeciesReferenceMapperImpl(Configuration config) throws IOException {
        String referenceSpeciesPath = config.getProperty("reference_species");
        if (referenceSpeciesPath == null) {
            log.warn("Reference species not specified in configuration file. Mapping will not occur.");
            this.references = Collections.emptyMap();
        } else {
            this.references = new HashMap<String, String>();
            File referenceSpeciesFile = new File(referenceSpeciesPath);
            try (Stream<String> lines = FileUtilities.getReaderFromFile(referenceSpeciesFile).lines();){
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    String line = (String)iterator.next();
                    String[] split = line.split("\\t");
                    String refId = split[0];
                    String taxId = split[1];
                    this.references.put(taxId, refId);
                }
            }
        }
    }

    @Override
    public void addReferences(Set<String> ids) {
        ArrayList<String> additionalIds = new ArrayList<String>();
        for (String id : ids) {
            if (!this.references.containsKey(id)) continue;
            additionalIds.add(this.references.get(id));
        }
        ids.addAll(additionalIds);
    }

    @Override
    public void addReferences(Multimap<String, GeneSpeciesOccurrence> ids) {
        HashMultimap<String, GeneSpeciesOccurrence> additionalIds = HashMultimap.create();
        for (Map.Entry<String, GeneSpeciesOccurrence> id : ids.entries()) {
            if (!this.references.containsKey(id.getKey())) continue;
            additionalIds.put(this.references.get(id.getKey()), id.getValue());
        }
        ids.putAll(additionalIds);
    }
}

