/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.services;

import com.google.common.collect.HashMultiset;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSpeciesOccurrence;
import de.julielab.geneexpbase.scoring.JaroWinklerScorer;
import de.julielab.geneexpbase.scoring.Scorer;
import de.julielab.speciesassignment.GeneCompatibleTaxFilter;
import de.julielab.speciesassignment.spi.SpeciesAssignmentSmoothing;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.Range;

public class SpeciesAssignmentSentenceSmoothing
implements SpeciesAssignmentSmoothing {
    private final GeneCompatibleTaxFilter geneCompatibleTaxFilter;
    private final Scorer scorer = new JaroWinklerScorer();

    @Inject
    public SpeciesAssignmentSentenceSmoothing(GeneCompatibleTaxFilter geneCompatibleTaxFilter) {
        this.geneCompatibleTaxFilter = geneCompatibleTaxFilter;
    }

    @Override
    public void smooth(GeneDocument document, Parameters parameters) {
        for (Range<Integer> sentence : document.getSentences()) {
            List genesInSentence = document.getOverlappingGenes(sentence).collect(Collectors.toList());
            if (genesInSentence.isEmpty()) continue;
            HashMultiset taxIdsInGenes = HashMultiset.create();
            genesInSentence.stream().map(GeneMention::getTaxonomyIds).flatMap(Collection::stream).forEach(taxIdsInGenes::add);
            if (taxIdsInGenes.isEmpty()) continue;
            String maxTax = Collections.max(taxIdsInGenes, Comparator.comparingInt(taxIdsInGenes::count));
            genesInSentence.stream().filter(gm -> gm.getTaxonomyOccurrences().values().contains((Object)GeneSpeciesOccurrence.COMPOUND)).filter(gm -> !this.geneCompatibleTaxFilter.checkForCompatibleTaxonomyCandidates((GeneMention)gm, Set.of(maxTax), this.scorer, parameters).isEmpty()).forEach(gm -> gm.setTaxonomyIds(List.of(maxTax)));
        }
    }
}

